/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.build.logger.BuildLogger;
import java.text.MessageFormat;
import org.shaded.eclipse.jgit.lib.ProgressMonitor;

public class BuildLoggerProgressMonitor
implements ProgressMonitor {
    private static final long MESSAGE_INTERVAL = 10000L;
    private final BuildLogger buildLogger;
    private long lastMessageTS;
    private int lastTotalWork;
    private int lastWork;

    public BuildLoggerProgressMonitor(BuildLogger buildLogger) {
        this.buildLogger = buildLogger;
    }

    public void start(int totalTasks) {
    }

    public void beginTask(String title, int totalWork) {
        this.lastTotalWork = totalWork;
        this.lastWork = 0;
        String message = MessageFormat.format("Git: {0}{1,choice,0#|1# ({1})}", title, totalWork);
        this.buildLogger.addBuildLogEntry(message);
        this.lastMessageTS = System.currentTimeMillis();
    }

    public void update(int completed) {
        this.lastWork += completed;
        long now = System.currentTimeMillis();
        if (now > this.lastMessageTS + 10000L) {
            String message = this.lastTotalWork > 0 ? MessageFormat.format("Git: {0,number,percent} ({1}/{2})", (double)this.lastWork / (double)this.lastTotalWork, this.lastWork, this.lastTotalWork) : MessageFormat.format("Git: ({0})", this.lastWork);
            this.buildLogger.addBuildLogEntry(message);
            this.lastMessageTS = now;
        }
    }

    public void endTask() {
        this.lastTotalWork = 0;
    }

    public boolean isCancelled() {
        return false;
    }
}

