/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.revwalk.filter;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.shaded.eclipse.jgit.JGitText;
import org.shaded.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.shaded.eclipse.jgit.errors.MissingObjectException;
import org.shaded.eclipse.jgit.lib.Constants;
import org.shaded.eclipse.jgit.revwalk.RevCommit;
import org.shaded.eclipse.jgit.revwalk.RevWalk;
import org.shaded.eclipse.jgit.revwalk.filter.RevFilter;

public abstract class PatternMatchRevFilter
extends RevFilter {
    private final String patternText;
    private final Matcher compiledPattern;

    protected static final String forceToRaw(String patternText) {
        byte[] b = Constants.encode(patternText);
        StringBuilder needle = new StringBuilder(b.length);
        for (int i = 0; i < b.length; ++i) {
            needle.append((char)(b[i] & 0xFF));
        }
        return needle.toString();
    }

    protected PatternMatchRevFilter(String pattern, boolean innerString, boolean rawEncoding, int flags) {
        if (pattern.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().cannotMatchOnEmptyString);
        }
        this.patternText = pattern;
        if (innerString) {
            if (!pattern.startsWith("^") && !pattern.startsWith(".*")) {
                pattern = ".*" + pattern;
            }
            if (!pattern.endsWith("$") && !pattern.endsWith(".*")) {
                pattern = pattern + ".*";
            }
        }
        String p = rawEncoding ? PatternMatchRevFilter.forceToRaw(pattern) : pattern;
        this.compiledPattern = Pattern.compile(p, flags).matcher("");
    }

    public String pattern() {
        return this.patternText;
    }

    public boolean include(RevWalk walker, RevCommit cmit) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.compiledPattern.reset(this.text(cmit)).matches();
    }

    protected abstract CharSequence text(RevCommit var1);

    public String toString() {
        return super.toString() + "(\"" + this.patternText + "\")";
    }
}

