/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.shaded.eclipse.jgit.util.FS_POSIX_Java5;
import org.shaded.eclipse.jgit.util.FS_POSIX_Java6;
import org.shaded.eclipse.jgit.util.FS_Win32;
import org.shaded.eclipse.jgit.util.FS_Win32_Cygwin;

public abstract class FS {
    public static final FS DETECTED = FS.detect(null);
    private final File userHome = this.userHomeImpl();

    public static FS detect(Boolean cygwinUsed) {
        if (FS_Win32.detect()) {
            boolean useCygwin;
            boolean bl = useCygwin = cygwinUsed == null && FS_Win32_Cygwin.detect() || Boolean.TRUE.equals(cygwinUsed);
            if (useCygwin) {
                return new FS_Win32_Cygwin();
            }
            return new FS_Win32();
        }
        if (FS_POSIX_Java6.detect()) {
            return new FS_POSIX_Java6();
        }
        return new FS_POSIX_Java5();
    }

    protected FS() {
    }

    public abstract boolean supportsExecute();

    public abstract boolean canExecute(File var1);

    public abstract boolean setExecute(File var1, boolean var2);

    public File resolve(File dir, String name) {
        File abspn = new File(name);
        if (abspn.isAbsolute()) {
            return abspn;
        }
        return new File(dir, name);
    }

    public File userHome() {
        return this.userHome;
    }

    public abstract boolean retryFailedLockFileCommit();

    protected File userHomeImpl() {
        String home = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("user.home");
            }
        });
        if (home == null || home.length() == 0) {
            return null;
        }
        return new File(home).getAbsoluteFile();
    }

    static File searchPath(String path, String ... lookFor) {
        for (String p : path.split(File.pathSeparator)) {
            for (String command : lookFor) {
                File e = new File(p, command);
                if (!e.isFile()) continue;
                return e.getAbsoluteFile();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String readPipe(File dir, String[] command, String encoding) {
        try {
            Process p = Runtime.getRuntime().exec(command, null, dir);
            BufferedReader lineRead = new BufferedReader(new InputStreamReader(p.getInputStream(), encoding));
            String r = null;
            try {
                r = lineRead.readLine();
            }
            finally {
                p.getOutputStream().close();
                p.getErrorStream().close();
                lineRead.close();
            }
            while (true) {
                try {
                    if (p.waitFor() == 0 && r != null && r.length() > 0) {
                        return r;
                    }
                }
                catch (InterruptedException ie) {
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public abstract File gitPrefix();

    public abstract ProcessBuilder runInShell(String var1, String[] var2);
}

