/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.transport;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.shaded.eclipse.jgit.JGitText;
import org.shaded.eclipse.jgit.errors.NotSupportedException;
import org.shaded.eclipse.jgit.errors.TransportException;
import org.shaded.eclipse.jgit.lib.Repository;
import org.shaded.eclipse.jgit.transport.BundleFetchConnection;
import org.shaded.eclipse.jgit.transport.FetchConnection;
import org.shaded.eclipse.jgit.transport.PushConnection;
import org.shaded.eclipse.jgit.transport.Transport;
import org.shaded.eclipse.jgit.transport.TransportBundle;
import org.shaded.eclipse.jgit.transport.URIish;
import org.shaded.eclipse.jgit.util.FS;

class TransportBundleFile
extends Transport
implements TransportBundle {
    private final File bundle;

    static boolean canHandle(URIish uri, FS fs) {
        if (uri.getHost() != null || uri.getPort() > 0 || uri.getUser() != null || uri.getPass() != null || uri.getPath() == null) {
            return false;
        }
        if ("file".equals(uri.getScheme()) || uri.getScheme() == null) {
            File f = fs.resolve(new File("."), uri.getPath());
            return f.isFile() || f.getName().endsWith(".bundle");
        }
        return false;
    }

    TransportBundleFile(Repository local, URIish uri) {
        super(local, uri);
        this.bundle = local.getFS().resolve(new File("."), uri.getPath()).getAbsoluteFile();
    }

    public FetchConnection openFetch() throws NotSupportedException, TransportException {
        FileInputStream src;
        try {
            src = new FileInputStream(this.bundle);
        }
        catch (FileNotFoundException err) {
            throw new TransportException(this.uri, JGitText.get().notFound);
        }
        return new BundleFetchConnection(this, src);
    }

    public PushConnection openPush() throws NotSupportedException {
        throw new NotSupportedException(JGitText.get().pushIsNotSupportedForBundleTransport);
    }

    public void close() {
    }
}

