/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import org.shaded.eclipse.jgit.JGitText;
import org.shaded.eclipse.jgit.api.GitCommand;
import org.shaded.eclipse.jgit.api.errors.JGitInternalException;
import org.shaded.eclipse.jgit.api.errors.NoFilepatternException;
import org.shaded.eclipse.jgit.dircache.DirCache;
import org.shaded.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.shaded.eclipse.jgit.dircache.DirCacheBuilder;
import org.shaded.eclipse.jgit.dircache.DirCacheEntry;
import org.shaded.eclipse.jgit.dircache.DirCacheIterator;
import org.shaded.eclipse.jgit.lib.ObjectInserter;
import org.shaded.eclipse.jgit.lib.Repository;
import org.shaded.eclipse.jgit.treewalk.FileTreeIterator;
import org.shaded.eclipse.jgit.treewalk.TreeWalk;
import org.shaded.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.shaded.eclipse.jgit.treewalk.filter.PathFilterGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddCommand
extends GitCommand<DirCache> {
    private Collection<String> filepatterns = new LinkedList<String>();
    private WorkingTreeIterator workingTreeIterator;
    private boolean update = false;

    public AddCommand(Repository repo) {
        super(repo);
    }

    public AddCommand addFilepattern(String filepattern) {
        this.checkCallable();
        this.filepatterns.add(filepattern);
        return this;
    }

    public AddCommand setWorkingTreeIterator(WorkingTreeIterator f) {
        this.workingTreeIterator = f;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DirCache call() throws NoFilepatternException {
        if (this.filepatterns.isEmpty()) {
            throw new NoFilepatternException(JGitText.get().atLeastOnePatternIsRequired);
        }
        this.checkCallable();
        DirCache dc = null;
        boolean addAll = false;
        if (this.filepatterns.contains(".")) {
            addAll = true;
        }
        ObjectInserter inserter = this.repo.newObjectInserter();
        try {
            dc = this.repo.lockDirCache();
            DirCacheBuilder builder = dc.builder();
            TreeWalk tw = new TreeWalk(this.repo);
            tw.addTree(new DirCacheBuildIterator(builder));
            if (this.workingTreeIterator == null) {
                this.workingTreeIterator = new FileTreeIterator(this.repo);
            }
            tw.addTree(this.workingTreeIterator);
            tw.setRecursive(true);
            if (!addAll) {
                tw.setFilter(PathFilterGroup.createFromStrings(this.filepatterns));
            }
            String lastAddedFile = null;
            while (tw.next()) {
                String path = tw.getPathString();
                WorkingTreeIterator f = tw.getTree(1, WorkingTreeIterator.class);
                if (tw.getTree(0, DirCacheIterator.class) == null && f != null && f.isEntryIgnored() || path.equals(lastAddedFile) || this.update && tw.getTree(0, DirCacheIterator.class) == null) continue;
                DirCacheIterator c = tw.getTree(0, DirCacheIterator.class);
                if (f != null) {
                    long sz = f.getEntryLength();
                    DirCacheEntry entry = new DirCacheEntry(path);
                    if (c == null || c.getDirCacheEntry() == null || !c.getDirCacheEntry().isAssumeValid()) {
                        entry.setLength(sz);
                        entry.setLastModified(f.getEntryLastModified());
                        entry.setFileMode(f.getEntryFileMode());
                        InputStream in = f.openEntryStream();
                        try {
                            entry.setObjectId(inserter.insert(3, sz, in));
                        }
                        finally {
                            in.close();
                        }
                        builder.add(entry);
                        lastAddedFile = path;
                        continue;
                    }
                    builder.add(c.getDirCacheEntry());
                    continue;
                }
                if (this.update) continue;
                builder.add(c.getDirCacheEntry());
            }
            inserter.flush();
            builder.commit();
            this.setCallable(false);
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfAddCommand, e);
        }
        finally {
            inserter.release();
            if (dc != null) {
                dc.unlock();
            }
        }
        return dc;
    }

    public AddCommand setUpdate(boolean update) {
        this.update = update;
        return this;
    }

    public boolean isUpdate() {
        return this.update;
    }
}

