/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.transport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.shaded.eclipse.jgit.JGitText;
import org.shaded.eclipse.jgit.errors.TransportException;
import org.shaded.eclipse.jgit.lib.Repository;
import org.shaded.eclipse.jgit.transport.BasePackFetchConnection;
import org.shaded.eclipse.jgit.transport.BasePackPushConnection;
import org.shaded.eclipse.jgit.transport.FetchConnection;
import org.shaded.eclipse.jgit.transport.PackTransport;
import org.shaded.eclipse.jgit.transport.PacketLineOut;
import org.shaded.eclipse.jgit.transport.PushConnection;
import org.shaded.eclipse.jgit.transport.TcpTransport;
import org.shaded.eclipse.jgit.transport.URIish;

class TransportGitAnon
extends TcpTransport
implements PackTransport {
    static final int GIT_PORT = 9418;

    static boolean canHandle(URIish uri) {
        return "git".equals(uri.getScheme());
    }

    TransportGitAnon(Repository local, URIish uri) {
        super(local, uri);
    }

    public FetchConnection openFetch() throws TransportException {
        return new TcpFetchConnection();
    }

    public PushConnection openPush() throws TransportException {
        return new TcpPushConnection();
    }

    public void close() {
    }

    Socket openConnection() throws TransportException {
        int tms = this.getTimeout() > 0 ? this.getTimeout() * 1000 : 0;
        int port = this.uri.getPort() > 0 ? this.uri.getPort() : 9418;
        Socket s = new Socket();
        try {
            InetAddress host = InetAddress.getByName(this.uri.getHost());
            s.bind(null);
            s.connect(new InetSocketAddress(host, port), tms);
        }
        catch (IOException c) {
            try {
                s.close();
            }
            catch (IOException closeErr) {
                // empty catch block
            }
            if (c instanceof UnknownHostException) {
                throw new TransportException(this.uri, JGitText.get().unknownHost);
            }
            if (c instanceof ConnectException) {
                throw new TransportException(this.uri, c.getMessage());
            }
            throw new TransportException(this.uri, c.getMessage(), c);
        }
        return s;
    }

    void service(String name, PacketLineOut pckOut) throws IOException {
        StringBuilder cmd = new StringBuilder();
        cmd.append(name);
        cmd.append(' ');
        cmd.append(this.uri.getPath());
        cmd.append('\u0000');
        cmd.append("host=");
        cmd.append(this.uri.getHost());
        if (this.uri.getPort() > 0 && this.uri.getPort() != 9418) {
            cmd.append(":");
            cmd.append(this.uri.getPort());
        }
        cmd.append('\u0000');
        pckOut.writeString(cmd.toString());
        pckOut.flush();
    }

    class TcpPushConnection
    extends BasePackPushConnection {
        private Socket sock;

        TcpPushConnection() throws TransportException {
            super(TransportGitAnon.this);
            this.sock = TransportGitAnon.this.openConnection();
            try {
                InputStream sIn = this.sock.getInputStream();
                OutputStream sOut = this.sock.getOutputStream();
                sIn = new BufferedInputStream(sIn);
                sOut = new BufferedOutputStream(sOut);
                this.init(sIn, sOut);
                TransportGitAnon.this.service("git-receive-pack", this.pckOut);
            }
            catch (IOException err) {
                this.close();
                throw new TransportException(this.uri, JGitText.get().remoteHungUpUnexpectedly, err);
            }
            this.readAdvertisedRefs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            super.close();
            if (this.sock != null) {
                try {
                    try {
                        this.sock.close();
                    }
                    catch (IOException iOException) {
                        Object var3_2 = null;
                        this.sock = null;
                    }
                    Object var3_1 = null;
                    this.sock = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.sock = null;
                    throw throwable;
                }
            }
        }
    }

    class TcpFetchConnection
    extends BasePackFetchConnection {
        private Socket sock;

        TcpFetchConnection() throws TransportException {
            super(TransportGitAnon.this);
            this.sock = TransportGitAnon.this.openConnection();
            try {
                InputStream sIn = this.sock.getInputStream();
                OutputStream sOut = this.sock.getOutputStream();
                sIn = new BufferedInputStream(sIn);
                sOut = new BufferedOutputStream(sOut);
                this.init(sIn, sOut);
                TransportGitAnon.this.service("git-upload-pack", this.pckOut);
            }
            catch (IOException err) {
                this.close();
                throw new TransportException(this.uri, JGitText.get().remoteHungUpUnexpectedly, err);
            }
            this.readAdvertisedRefs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            super.close();
            if (this.sock != null) {
                try {
                    try {
                        this.sock.close();
                    }
                    catch (IOException iOException) {
                        Object var3_2 = null;
                        this.sock = null;
                    }
                    Object var3_1 = null;
                    this.sock = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.sock = null;
                    throw throwable;
                }
            }
        }
    }
}

