/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.storage.file;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.shaded.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.shaded.eclipse.jgit.errors.MissingObjectException;
import org.shaded.eclipse.jgit.errors.StoredObjectRepresentationNotAvailableException;
import org.shaded.eclipse.jgit.lib.AbbreviatedObjectId;
import org.shaded.eclipse.jgit.lib.AnyObjectId;
import org.shaded.eclipse.jgit.lib.InflaterCache;
import org.shaded.eclipse.jgit.lib.ObjectId;
import org.shaded.eclipse.jgit.lib.ObjectLoader;
import org.shaded.eclipse.jgit.lib.ObjectReader;
import org.shaded.eclipse.jgit.lib.ProgressMonitor;
import org.shaded.eclipse.jgit.revwalk.RevObject;
import org.shaded.eclipse.jgit.storage.file.ByteArrayWindow;
import org.shaded.eclipse.jgit.storage.file.ByteWindow;
import org.shaded.eclipse.jgit.storage.file.FileObjectDatabase;
import org.shaded.eclipse.jgit.storage.file.LocalCachedPack;
import org.shaded.eclipse.jgit.storage.file.LocalObjectToPack;
import org.shaded.eclipse.jgit.storage.file.PackFile;
import org.shaded.eclipse.jgit.storage.file.WindowCache;
import org.shaded.eclipse.jgit.storage.pack.CachedPack;
import org.shaded.eclipse.jgit.storage.pack.ObjectReuseAsIs;
import org.shaded.eclipse.jgit.storage.pack.ObjectToPack;
import org.shaded.eclipse.jgit.storage.pack.PackOutputStream;
import org.shaded.eclipse.jgit.storage.pack.PackWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WindowCursor
extends ObjectReader
implements ObjectReuseAsIs {
    final byte[] tempId = new byte[20];
    private Inflater inf;
    private ByteWindow window;
    final FileObjectDatabase db;

    WindowCursor(FileObjectDatabase db) {
        this.db = db;
    }

    @Override
    public ObjectReader newReader() {
        return new WindowCursor(this.db);
    }

    @Override
    public Collection<ObjectId> resolve(AbbreviatedObjectId id) throws IOException {
        if (id.isComplete()) {
            return Collections.singleton(id.toObjectId());
        }
        HashSet<ObjectId> matches = new HashSet<ObjectId>(4);
        this.db.resolve(matches, id);
        return matches;
    }

    @Override
    public boolean has(AnyObjectId objectId) throws IOException {
        return this.db.has(objectId);
    }

    @Override
    public ObjectLoader open(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectLoader ldr = this.db.openObject(this, objectId);
        if (ldr == null) {
            if (typeHint == -1) {
                throw new MissingObjectException(objectId.copy(), "unknown");
            }
            throw new MissingObjectException(objectId.copy(), typeHint);
        }
        if (typeHint != -1 && ldr.getType() != typeHint) {
            throw new IncorrectObjectTypeException(objectId.copy(), typeHint);
        }
        return ldr;
    }

    @Override
    public long getObjectSize(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        long sz = this.db.getObjectSize(this, objectId);
        if (sz < 0L) {
            if (typeHint == -1) {
                throw new MissingObjectException(objectId.copy(), "unknown");
            }
            throw new MissingObjectException(objectId.copy(), typeHint);
        }
        return sz;
    }

    @Override
    public LocalObjectToPack newObjectToPack(RevObject obj) {
        return new LocalObjectToPack(obj);
    }

    @Override
    public void selectObjectRepresentation(PackWriter packer, ProgressMonitor monitor, Iterable<ObjectToPack> objects) throws IOException, MissingObjectException {
        for (ObjectToPack otp : objects) {
            this.db.selectObjectRepresentation(packer, otp, this);
            monitor.update(1);
        }
    }

    @Override
    public void copyObjectAsIs(PackOutputStream out, ObjectToPack otp) throws IOException, StoredObjectRepresentationNotAvailableException {
        LocalObjectToPack src = (LocalObjectToPack)otp;
        src.pack.copyAsIs(out, src, this);
    }

    @Override
    public void writeObjects(PackOutputStream out, List<ObjectToPack> list) throws IOException {
        for (ObjectToPack otp : list) {
            out.writeObject(otp);
        }
    }

    @Override
    public Collection<CachedPack> getCachedPacks() throws IOException {
        return this.db.getCachedPacks();
    }

    int copy(PackFile pack, long position, byte[] dstbuf, int dstoff, int cnt) throws IOException {
        int need;
        int r;
        long length = pack.length;
        for (need = cnt; need > 0 && position < length; need -= r) {
            this.pin(pack, position);
            r = this.window.copy(position, dstbuf, dstoff, need);
            position += (long)r;
            dstoff += r;
        }
        return cnt - need;
    }

    @Override
    public void copyPackAsIs(PackOutputStream out, CachedPack pack) throws IOException {
        ((LocalCachedPack)pack).copyAsIs(out, this);
    }

    void copyPackAsIs(PackFile pack, PackOutputStream out, long position, long cnt) throws IOException {
        while (0L < cnt) {
            this.pin(pack, position);
            int ptr = (int)(position - this.window.start);
            int n = (int)Math.min((long)(this.window.size() - ptr), cnt);
            this.window.write(out, position, n);
            position += (long)n;
            cnt -= (long)n;
        }
    }

    int inflate(PackFile pack, long position, byte[] dstbuf, int dstoff) throws IOException, DataFormatException {
        int n;
        this.prepareInflater();
        this.pin(pack, position);
        position += (long)this.window.setInput(position, this.inf);
        do {
            if ((n = this.inf.inflate(dstbuf, dstoff, dstbuf.length - dstoff)) != 0) continue;
            if (this.inf.needsInput()) {
                this.pin(pack, position);
                position += (long)this.window.setInput(position, this.inf);
                continue;
            }
            if (this.inf.finished()) {
                return dstoff;
            }
            throw new DataFormatException();
        } while ((dstoff += n) < dstbuf.length);
        return dstoff;
    }

    ByteArrayWindow quickCopy(PackFile p, long pos, long cnt) throws IOException {
        this.pin(p, pos);
        if (this.window instanceof ByteArrayWindow && this.window.contains(p, pos + (cnt - 1L))) {
            return (ByteArrayWindow)this.window;
        }
        return null;
    }

    Inflater inflater() {
        this.prepareInflater();
        return this.inf;
    }

    private void prepareInflater() {
        if (this.inf == null) {
            this.inf = InflaterCache.get();
        } else {
            this.inf.reset();
        }
    }

    void pin(PackFile pack, long position) throws IOException {
        ByteWindow w = this.window;
        if (w == null || !w.contains(pack, position)) {
            this.window = null;
            this.window = WindowCache.get(pack, position);
        }
    }

    int getStreamFileThreshold() {
        return WindowCache.getStreamFileThreshold();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        this.window = null;
        try {
            InflaterCache.release(this.inf);
        }
        finally {
            this.inf = null;
        }
    }
}

