/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.lib;

import java.io.IOException;
import java.text.MessageFormat;
import org.shaded.eclipse.jgit.JGitText;
import org.shaded.eclipse.jgit.errors.MissingObjectException;
import org.shaded.eclipse.jgit.lib.AnyObjectId;
import org.shaded.eclipse.jgit.lib.ObjectId;
import org.shaded.eclipse.jgit.lib.PersonIdent;
import org.shaded.eclipse.jgit.lib.Ref;
import org.shaded.eclipse.jgit.lib.RefDatabase;
import org.shaded.eclipse.jgit.lib.Repository;
import org.shaded.eclipse.jgit.revwalk.RevCommit;
import org.shaded.eclipse.jgit.revwalk.RevObject;
import org.shaded.eclipse.jgit.revwalk.RevWalk;

public abstract class RefUpdate {
    private ObjectId newValue;
    private boolean force;
    private PersonIdent refLogIdent;
    private String refLogMessage;
    private boolean refLogIncludeResult;
    private ObjectId oldValue;
    private ObjectId expValue;
    private Result result = Result.NOT_ATTEMPTED;
    private final Ref ref;

    protected RefUpdate(Ref ref) {
        this.ref = ref;
        this.oldValue = ref.getObjectId();
        this.refLogMessage = "";
    }

    protected abstract RefDatabase getRefDatabase();

    protected abstract Repository getRepository();

    protected abstract boolean tryLock(boolean var1) throws IOException;

    protected abstract void unlock();

    protected abstract Result doUpdate(Result var1) throws IOException;

    protected abstract Result doDelete(Result var1) throws IOException;

    protected abstract Result doLink(String var1) throws IOException;

    public String getName() {
        return this.getRef().getName();
    }

    public Ref getRef() {
        return this.ref;
    }

    public ObjectId getNewObjectId() {
        return this.newValue;
    }

    public void setNewObjectId(AnyObjectId id) {
        this.newValue = id.copy();
    }

    public ObjectId getExpectedOldObjectId() {
        return this.expValue;
    }

    public void setExpectedOldObjectId(AnyObjectId id) {
        this.expValue = id != null ? id.toObjectId() : null;
    }

    public boolean isForceUpdate() {
        return this.force;
    }

    public void setForceUpdate(boolean b) {
        this.force = b;
    }

    public PersonIdent getRefLogIdent() {
        return this.refLogIdent;
    }

    public void setRefLogIdent(PersonIdent pi) {
        this.refLogIdent = pi;
    }

    public String getRefLogMessage() {
        return this.refLogMessage;
    }

    protected boolean isRefLogIncludingResult() {
        return this.refLogIncludeResult;
    }

    public void setRefLogMessage(String msg, boolean appendStatus) {
        if (msg == null && !appendStatus) {
            this.disableRefLog();
        } else if (msg == null && appendStatus) {
            this.refLogMessage = "";
            this.refLogIncludeResult = true;
        } else {
            this.refLogMessage = msg;
            this.refLogIncludeResult = appendStatus;
        }
    }

    public void disableRefLog() {
        this.refLogMessage = null;
        this.refLogIncludeResult = false;
    }

    public ObjectId getOldObjectId() {
        return this.oldValue;
    }

    protected void setOldObjectId(ObjectId old) {
        this.oldValue = old;
    }

    public Result getResult() {
        return this.result;
    }

    private void requireCanDoUpdate() {
        if (this.newValue == null) {
            throw new IllegalStateException(JGitText.get().aNewObjectIdIsRequired);
        }
    }

    public Result forceUpdate() throws IOException {
        this.force = true;
        return this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result update() throws IOException {
        RevWalk rw = new RevWalk(this.getRepository());
        try {
            Result result = this.update(rw);
            return result;
        }
        finally {
            rw.release();
        }
    }

    public Result update(RevWalk walk) throws IOException {
        this.requireCanDoUpdate();
        try {
            this.result = this.updateImpl(walk, new Store(){

                Result execute(Result status) throws IOException {
                    if (status == Result.NO_CHANGE) {
                        return status;
                    }
                    return RefUpdate.this.doUpdate(status);
                }
            });
            return this.result;
        }
        catch (IOException x) {
            this.result = Result.IO_FAILURE;
            throw x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result delete() throws IOException {
        RevWalk rw = new RevWalk(this.getRepository());
        try {
            Result result = this.delete(rw);
            return result;
        }
        finally {
            rw.release();
        }
    }

    public Result delete(RevWalk walk) throws IOException {
        String myName = this.getRef().getLeaf().getName();
        if (myName.startsWith("refs/heads/")) {
            Ref head = this.getRefDatabase().getRef("HEAD");
            while (head.isSymbolic()) {
                if (!myName.equals((head = head.getTarget()).getName())) continue;
                this.result = Result.REJECTED_CURRENT_BRANCH;
                return this.result;
            }
        }
        try {
            this.result = this.updateImpl(walk, new Store(){

                Result execute(Result status) throws IOException {
                    return RefUpdate.this.doDelete(status);
                }
            });
            return this.result;
        }
        catch (IOException x) {
            this.result = Result.IO_FAILURE;
            throw x;
        }
    }

    public Result link(String target) throws IOException {
        if (!target.startsWith("refs/")) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().illegalArgumentNotA, "refs/"));
        }
        if (this.getRefDatabase().isNameConflicting(this.getName())) {
            return Result.LOCK_FAILURE;
        }
        try {
            Ref dst;
            if (!this.tryLock(false)) {
                Result result = Result.LOCK_FAILURE;
                return result;
            }
            Ref old = this.getRefDatabase().getRef(this.getName());
            if (old != null && old.isSymbolic() && target.equals((dst = old.getTarget()).getName())) {
                Result result = this.result = Result.NO_CHANGE;
                return result;
            }
            if (old != null && old.getObjectId() != null) {
                this.setOldObjectId(old.getObjectId());
            }
            if ((dst = this.getRefDatabase().getRef(target)) != null && dst.getObjectId() != null) {
                this.setNewObjectId(dst.getObjectId());
            }
            Result result = this.result = this.doLink(target);
            return result;
        }
        catch (IOException x) {
            this.result = Result.IO_FAILURE;
            throw x;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result updateImpl(RevWalk walk, Store store) throws IOException {
        if (this.getRefDatabase().isNameConflicting(this.getName())) {
            return Result.LOCK_FAILURE;
        }
        try {
            RevObject oldObj;
            Result result;
            if (!this.tryLock(true)) {
                Result result2 = Result.LOCK_FAILURE;
                return result2;
            }
            if (this.expValue != null) {
                ObjectId o;
                ObjectId objectId = o = this.oldValue != null ? this.oldValue : ObjectId.zeroId();
                if (!AnyObjectId.equals(this.expValue, o)) {
                    Result result3 = Result.LOCK_FAILURE;
                    return result3;
                }
            }
            if (this.oldValue == null) {
                result = store.execute(Result.NEW);
                return result;
            }
            RevObject newObj = RefUpdate.safeParse(walk, this.newValue);
            if (newObj == (oldObj = RefUpdate.safeParse(walk, this.oldValue))) {
                result = store.execute(Result.NO_CHANGE);
                return result;
            }
            if (newObj instanceof RevCommit && oldObj instanceof RevCommit && walk.isMergedInto((RevCommit)oldObj, (RevCommit)newObj)) {
                result = store.execute(Result.FAST_FORWARD);
                return result;
            }
            if (this.isForceUpdate()) {
                result = store.execute(Result.FORCED);
                return result;
            }
            result = Result.REJECTED;
            return result;
        }
        finally {
            this.unlock();
        }
    }

    private static RevObject safeParse(RevWalk rw, AnyObjectId id) throws IOException {
        try {
            return id != null ? rw.parseAny(id) : null;
        }
        catch (MissingObjectException e) {
            return null;
        }
    }

    private abstract class Store {
        private Store() {
        }

        abstract Result execute(Result var1) throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Result {
        NOT_ATTEMPTED,
        LOCK_FAILURE,
        NO_CHANGE,
        NEW,
        FORCED,
        FAST_FORWARD,
        REJECTED,
        REJECTED_CURRENT_BRANCH,
        IO_FAILURE,
        RENAMED;

    }
}

