/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.util;

import java.io.File;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import org.shaded.eclipse.jgit.util.FS;
import org.shaded.eclipse.jgit.util.StringUtils;
import org.shaded.eclipse.jgit.util.SystemReader;

class FS_Win32
extends FS {
    FS_Win32() {
    }

    static boolean detect() {
        String osDotName = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("os.name");
            }
        });
        return osDotName != null && StringUtils.toLowerCase(osDotName).indexOf("windows") != -1;
    }

    public boolean supportsExecute() {
        return false;
    }

    public boolean canExecute(File f) {
        return false;
    }

    public boolean setExecute(File f, boolean canExec) {
        return false;
    }

    public boolean retryFailedLockFileCommit() {
        return true;
    }

    public File gitPrefix() {
        String path = SystemReader.getInstance().getenv("PATH");
        File gitExe = FS_Win32.searchPath(path, "git.exe", "git.cmd");
        if (gitExe != null) {
            return gitExe.getParentFile().getParentFile();
        }
        String w = FS_Win32.readPipe(this.userHome(), new String[]{"bash", "--login", "-c", "which git"}, Charset.defaultCharset().name());
        if (w != null) {
            return new File(w).getParentFile().getParentFile();
        }
        return null;
    }

    protected File userHomeImpl() {
        String home = SystemReader.getInstance().getenv("HOME");
        if (home != null) {
            return this.resolve(null, home);
        }
        String homeDrive = SystemReader.getInstance().getenv("HOMEDRIVE");
        if (homeDrive != null) {
            String homePath = SystemReader.getInstance().getenv("HOMEPATH");
            return new File(homeDrive, homePath);
        }
        String homeShare = SystemReader.getInstance().getenv("HOMESHARE");
        if (homeShare != null) {
            return new File(homeShare);
        }
        return super.userHomeImpl();
    }

    public ProcessBuilder runInShell(String cmd, String[] args) {
        ArrayList<String> argv = new ArrayList<String>(3 + args.length);
        argv.add("cmd.exe");
        argv.add("/c");
        argv.add(cmd);
        argv.addAll(Arrays.asList(args));
        ProcessBuilder proc = new ProcessBuilder(new String[0]);
        proc.command(argv);
        return proc;
    }
}

