/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.storage.pack;

import java.util.concurrent.Executor;
import org.shaded.eclipse.jgit.lib.Config;
import org.shaded.eclipse.jgit.lib.Repository;

public class PackConfig {
    public static final boolean DEFAULT_REUSE_DELTAS = true;
    public static final boolean DEFAULT_REUSE_OBJECTS = true;
    public static final boolean DEFAULT_DELTA_COMPRESS = true;
    public static final boolean DEFAULT_DELTA_BASE_AS_OFFSET = false;
    public static final int DEFAULT_MAX_DELTA_DEPTH = 50;
    public static final int DEFAULT_DELTA_SEARCH_WINDOW_SIZE = 10;
    public static final int DEFAULT_BIG_FILE_THRESHOLD = 0x3200000;
    public static final long DEFAULT_DELTA_CACHE_SIZE = 0x3200000L;
    public static final int DEFAULT_DELTA_CACHE_LIMIT = 100;
    public static final int DEFAULT_INDEX_VERSION = 2;
    private int compressionLevel = -1;
    private boolean reuseDeltas = true;
    private boolean reuseObjects = true;
    private boolean deltaBaseAsOffset = false;
    private boolean deltaCompress = true;
    private int maxDeltaDepth = 50;
    private int deltaSearchWindowSize = 10;
    private long deltaSearchMemoryLimit;
    private long deltaCacheSize = 0x3200000L;
    private int deltaCacheLimit = 100;
    private int bigFileThreshold = 0x3200000;
    private int threads;
    private Executor executor;
    private int indexVersion = 2;

    public PackConfig() {
    }

    public PackConfig(Repository db) {
        this.fromConfig(db.getConfig());
    }

    public PackConfig(Config cfg) {
        this.fromConfig(cfg);
    }

    public boolean isReuseDeltas() {
        return this.reuseDeltas;
    }

    public void setReuseDeltas(boolean reuseDeltas) {
        this.reuseDeltas = reuseDeltas;
    }

    public boolean isReuseObjects() {
        return this.reuseObjects;
    }

    public void setReuseObjects(boolean reuseObjects) {
        this.reuseObjects = reuseObjects;
    }

    public boolean isDeltaBaseAsOffset() {
        return this.deltaBaseAsOffset;
    }

    public void setDeltaBaseAsOffset(boolean deltaBaseAsOffset) {
        this.deltaBaseAsOffset = deltaBaseAsOffset;
    }

    public boolean isDeltaCompress() {
        return this.deltaCompress;
    }

    public void setDeltaCompress(boolean deltaCompress) {
        this.deltaCompress = deltaCompress;
    }

    public int getMaxDeltaDepth() {
        return this.maxDeltaDepth;
    }

    public void setMaxDeltaDepth(int maxDeltaDepth) {
        this.maxDeltaDepth = maxDeltaDepth;
    }

    public int getDeltaSearchWindowSize() {
        return this.deltaSearchWindowSize;
    }

    public void setDeltaSearchWindowSize(int objectCount) {
        if (objectCount <= 2) {
            this.setDeltaCompress(false);
        } else {
            this.deltaSearchWindowSize = objectCount;
        }
    }

    public long getDeltaSearchMemoryLimit() {
        return this.deltaSearchMemoryLimit;
    }

    public void setDeltaSearchMemoryLimit(long memoryLimit) {
        this.deltaSearchMemoryLimit = memoryLimit;
    }

    public long getDeltaCacheSize() {
        return this.deltaCacheSize;
    }

    public void setDeltaCacheSize(long size) {
        this.deltaCacheSize = size;
    }

    public int getDeltaCacheLimit() {
        return this.deltaCacheLimit;
    }

    public void setDeltaCacheLimit(int size) {
        this.deltaCacheLimit = size;
    }

    public int getBigFileThreshold() {
        return this.bigFileThreshold;
    }

    public void setBigFileThreshold(int bigFileThreshold) {
        this.bigFileThreshold = bigFileThreshold;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int level) {
        this.compressionLevel = level;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public int getIndexVersion() {
        return this.indexVersion;
    }

    public void setIndexVersion(int version) {
        this.indexVersion = version;
    }

    public void fromConfig(Config rc) {
        this.setMaxDeltaDepth(rc.getInt("pack", "depth", this.getMaxDeltaDepth()));
        this.setDeltaSearchWindowSize(rc.getInt("pack", "window", this.getDeltaSearchWindowSize()));
        this.setDeltaSearchMemoryLimit(rc.getLong("pack", "windowmemory", this.getDeltaSearchMemoryLimit()));
        this.setDeltaCacheSize(rc.getLong("pack", "deltacachesize", this.getDeltaCacheSize()));
        this.setDeltaCacheLimit(rc.getInt("pack", "deltacachelimit", this.getDeltaCacheLimit()));
        this.setCompressionLevel(rc.getInt("pack", "compression", rc.getInt("core", "compression", this.getCompressionLevel())));
        this.setIndexVersion(rc.getInt("pack", "indexversion", this.getIndexVersion()));
        this.setBigFileThreshold(rc.getInt("core", "bigfilethreshold", this.getBigFileThreshold()));
        this.setThreads(rc.getInt("pack", "threads", this.getThreads()));
        this.setReuseDeltas(rc.getBoolean("pack", "reusedeltas", this.isReuseDeltas()));
        this.setReuseObjects(rc.getBoolean("pack", "reuseobjects", this.isReuseObjects()));
        this.setDeltaCompress(rc.getBoolean("pack", "deltacompression", this.isDeltaCompress()));
    }
}

