/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.storage.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Set;
import org.shaded.eclipse.jgit.JGitText;
import org.shaded.eclipse.jgit.errors.MissingObjectException;
import org.shaded.eclipse.jgit.lib.AbbreviatedObjectId;
import org.shaded.eclipse.jgit.lib.AnyObjectId;
import org.shaded.eclipse.jgit.lib.MutableObjectId;
import org.shaded.eclipse.jgit.lib.ObjectId;
import org.shaded.eclipse.jgit.storage.file.PackIndexV1;
import org.shaded.eclipse.jgit.storage.file.PackIndexV2;
import org.shaded.eclipse.jgit.storage.file.PackIndexWriter;
import org.shaded.eclipse.jgit.util.IO;
import org.shaded.eclipse.jgit.util.NB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PackIndex
implements Iterable<MutableEntry> {
    protected byte[] packChecksum;

    public static PackIndex open(File idxFile) throws IOException {
        PackIndexV1 v2;
        FileInputStream fd = new FileInputStream(idxFile);
        try {
            byte[] hdr = new byte[8];
            IO.readFully(fd, hdr, 0, hdr.length);
            if (PackIndex.isTOC(hdr)) {
                int v2 = NB.decodeInt32(hdr, 4);
                switch (v2) {
                    case 2: {
                        PackIndexV2 packIndexV2 = new PackIndexV2(fd);
                        return packIndexV2;
                    }
                }
                throw new IOException(MessageFormat.format(JGitText.get().unsupportedPackIndexVersion, v2));
            }
            v2 = new PackIndexV1(fd, hdr);
        }
        catch (IOException ioe) {
            String path = idxFile.getAbsolutePath();
            IOException err = new IOException(MessageFormat.format(JGitText.get().unreadablePackIndex, path));
            err.initCause(ioe);
            throw err;
        }
        finally {
            try {
                fd.close();
            }
            catch (IOException err2) {}
        }
        return v2;
    }

    private static boolean isTOC(byte[] h) {
        byte[] toc = PackIndexWriter.TOC;
        for (int i = 0; i < toc.length; ++i) {
            if (h[i] == toc[i]) continue;
            return false;
        }
        return true;
    }

    public boolean hasObject(AnyObjectId id) {
        return this.findOffset(id) != -1L;
    }

    @Override
    public abstract Iterator<MutableEntry> iterator();

    abstract long getObjectCount();

    abstract long getOffset64Count();

    abstract ObjectId getObjectId(long var1);

    final ObjectId getObjectId(int nthPosition) {
        if (nthPosition >= 0) {
            return this.getObjectId((long)nthPosition);
        }
        int u31 = nthPosition >>> 1;
        int one = nthPosition & 1;
        return this.getObjectId((long)u31 << 1 | (long)one);
    }

    abstract long findOffset(AnyObjectId var1);

    abstract long findCRC32(AnyObjectId var1) throws MissingObjectException, UnsupportedOperationException;

    abstract boolean hasCRC32Support();

    abstract void resolve(Set<ObjectId> var1, AbbreviatedObjectId var2, int var3) throws IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class EntriesIterator
    implements Iterator<MutableEntry> {
        protected final MutableEntry entry = this.initEntry();
        protected long returnedNumber = 0L;

        EntriesIterator() {
        }

        protected abstract MutableEntry initEntry();

        @Override
        public boolean hasNext() {
            return this.returnedNumber < PackIndex.this.getObjectCount();
        }

        @Override
        public abstract MutableEntry next();

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class MutableEntry {
        final MutableObjectId idBuffer = new MutableObjectId();
        long offset;

        public long getOffset() {
            return this.offset;
        }

        public String name() {
            this.ensureId();
            return this.idBuffer.name();
        }

        public ObjectId toObjectId() {
            this.ensureId();
            return this.idBuffer.toObjectId();
        }

        public MutableEntry cloneEntry() {
            MutableEntry r = new MutableEntry();
            this.ensureId();
            r.idBuffer.fromObjectId(this.idBuffer);
            r.offset = this.offset;
            return r;
        }

        void ensureId() {
        }
    }
}

