/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.storage.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.shaded.eclipse.jgit.lib.ObjectId;
import org.shaded.eclipse.jgit.storage.file.ObjectDirectory;
import org.shaded.eclipse.jgit.storage.file.PackFile;
import org.shaded.eclipse.jgit.storage.file.WindowCursor;
import org.shaded.eclipse.jgit.storage.pack.CachedPack;
import org.shaded.eclipse.jgit.storage.pack.PackOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LocalCachedPack
extends CachedPack {
    private final ObjectDirectory odb;
    private final Set<ObjectId> tips;
    private final String[] packNames;

    LocalCachedPack(ObjectDirectory odb, Set<ObjectId> tips, List<String> packNames) {
        this.odb = odb;
        this.tips = tips.size() == 1 ? Collections.singleton(tips.iterator().next()) : Collections.unmodifiableSet(tips);
        this.packNames = packNames.toArray(new String[packNames.size()]);
    }

    @Override
    public Set<ObjectId> getTips() {
        return this.tips;
    }

    @Override
    public long getObjectCount() throws IOException {
        long cnt = 0L;
        for (String packName : this.packNames) {
            cnt += this.getPackFile(packName).getObjectCount();
        }
        return cnt;
    }

    void copyAsIs(PackOutputStream out, WindowCursor wc) throws IOException {
        for (String packName : this.packNames) {
            this.getPackFile(packName).copyPackAsIs(out, wc);
        }
    }

    @Override
    public <T extends ObjectId> Set<ObjectId> hasObject(Iterable<T> toFind) throws IOException {
        PackFile[] packs = new PackFile[this.packNames.length];
        for (int i = 0; i < this.packNames.length; ++i) {
            packs[i] = this.getPackFile(this.packNames[i]);
        }
        HashSet<ObjectId> have = new HashSet<ObjectId>();
        block1: for (ObjectId id : toFind) {
            for (PackFile pack : packs) {
                if (!pack.hasObject(id)) continue;
                have.add(id);
                continue block1;
            }
        }
        return have;
    }

    private PackFile getPackFile(String packName) throws FileNotFoundException {
        for (PackFile pack : this.odb.getPacks()) {
            if (!packName.equals(pack.getPackName())) continue;
            return pack;
        }
        throw new FileNotFoundException(this.getPackFilePath(packName));
    }

    private String getPackFilePath(String packName) {
        File packDir = new File(this.odb.getDirectory(), "pack");
        return new File(packDir, "pack-" + packName + ".pack").getPath();
    }
}

