/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.revwalk.filter;

import java.io.IOException;
import java.util.Date;
import org.shaded.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.shaded.eclipse.jgit.errors.MissingObjectException;
import org.shaded.eclipse.jgit.errors.StopWalkException;
import org.shaded.eclipse.jgit.revwalk.RevCommit;
import org.shaded.eclipse.jgit.revwalk.RevWalk;
import org.shaded.eclipse.jgit.revwalk.filter.RevFilter;

public abstract class CommitTimeRevFilter
extends RevFilter {
    final int when;

    public static final RevFilter before(Date ts) {
        return new Before(ts.getTime());
    }

    public static final RevFilter after(Date ts) {
        return new After(ts.getTime());
    }

    public static final RevFilter between(Date since, Date until) {
        return new Between(since.getTime(), until.getTime());
    }

    CommitTimeRevFilter(long ts) {
        this.when = (int)(ts / 1000L);
    }

    public RevFilter clone() {
        return this;
    }

    private static class Between
    extends CommitTimeRevFilter {
        private final int until;

        Between(long since, long until) {
            super(since);
            this.until = (int)(until / 1000L);
        }

        public boolean include(RevWalk walker, RevCommit cmit) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
            return cmit.getCommitTime() <= this.until && cmit.getCommitTime() >= this.when;
        }

        public String toString() {
            return super.toString() + "(" + new Date((long)this.when * 1000L) + " - " + new Date((long)this.until * 1000L) + ")";
        }
    }

    private static class After
    extends CommitTimeRevFilter {
        After(long ts) {
            super(ts);
        }

        public boolean include(RevWalk walker, RevCommit cmit) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
            if (cmit.getCommitTime() < this.when) {
                throw StopWalkException.INSTANCE;
            }
            return true;
        }

        public String toString() {
            return super.toString() + "(" + new Date((long)this.when * 1000L) + ")";
        }
    }

    private static class Before
    extends CommitTimeRevFilter {
        Before(long ts) {
            super(ts);
        }

        public boolean include(RevWalk walker, RevCommit cmit) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
            return cmit.getCommitTime() <= this.when;
        }

        public String toString() {
            return super.toString() + "(" + new Date((long)this.when * 1000L) + ")";
        }
    }
}

