/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.revwalk;

import java.io.IOException;
import java.text.MessageFormat;
import org.shaded.eclipse.jgit.JGitText;
import org.shaded.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.shaded.eclipse.jgit.errors.MissingObjectException;
import org.shaded.eclipse.jgit.revwalk.AbstractRevQueue;
import org.shaded.eclipse.jgit.revwalk.BoundaryGenerator;
import org.shaded.eclipse.jgit.revwalk.DateRevQueue;
import org.shaded.eclipse.jgit.revwalk.DelayRevQueue;
import org.shaded.eclipse.jgit.revwalk.FIFORevQueue;
import org.shaded.eclipse.jgit.revwalk.FixUninterestingGenerator;
import org.shaded.eclipse.jgit.revwalk.Generator;
import org.shaded.eclipse.jgit.revwalk.LIFORevQueue;
import org.shaded.eclipse.jgit.revwalk.MergeBaseGenerator;
import org.shaded.eclipse.jgit.revwalk.ObjectWalk;
import org.shaded.eclipse.jgit.revwalk.PendingGenerator;
import org.shaded.eclipse.jgit.revwalk.RevCommit;
import org.shaded.eclipse.jgit.revwalk.RevSort;
import org.shaded.eclipse.jgit.revwalk.RevWalk;
import org.shaded.eclipse.jgit.revwalk.RewriteGenerator;
import org.shaded.eclipse.jgit.revwalk.RewriteTreeFilter;
import org.shaded.eclipse.jgit.revwalk.TopoSortGenerator;
import org.shaded.eclipse.jgit.revwalk.filter.AndRevFilter;
import org.shaded.eclipse.jgit.revwalk.filter.RevFilter;
import org.shaded.eclipse.jgit.treewalk.filter.TreeFilter;

class StartGenerator
extends Generator {
    private final RevWalk walker;

    StartGenerator(RevWalk w) {
        this.walker = w;
    }

    int outputType() {
        return 0;
    }

    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevWalk w = this.walker;
        RevFilter rf = w.getRevFilter();
        TreeFilter tf = w.getTreeFilter();
        AbstractRevQueue q = this.walker.queue;
        w.reader.walkAdviceBeginCommits(w, w.roots);
        if (rf == RevFilter.MERGE_BASE) {
            if (tf != TreeFilter.ALL) {
                throw new IllegalStateException(MessageFormat.format(JGitText.get().cannotCombineTreeFilterWithRevFilter, tf, rf));
            }
            MergeBaseGenerator mbg = new MergeBaseGenerator(w);
            this.walker.pending = mbg;
            this.walker.queue = AbstractRevQueue.EMPTY_QUEUE;
            mbg.init(q);
            return mbg.next();
        }
        boolean uninteresting = q.anybodyHasFlag(4);
        boolean boundary = this.walker.hasRevSort(RevSort.BOUNDARY);
        if (!boundary && this.walker instanceof ObjectWalk) {
            boundary = true;
        }
        if (boundary && !uninteresting) {
            boundary = false;
        }
        int pendingOutputType = 0;
        DateRevQueue pending = q instanceof DateRevQueue ? (DateRevQueue)q : new DateRevQueue(q);
        if (tf != TreeFilter.ALL) {
            rf = AndRevFilter.create(rf, new RewriteTreeFilter(w, tf));
            pendingOutputType |= 6;
        }
        this.walker.queue = q;
        Generator g = new PendingGenerator(w, pending, rf, pendingOutputType);
        if (boundary) {
            ((PendingGenerator)g).canDispose = false;
        }
        if ((g.outputType() & 4) != 0) {
            g = new FIFORevQueue(g);
            g = new RewriteGenerator(g);
        }
        if (this.walker.hasRevSort(RevSort.TOPO) && (g.outputType() & 8) == 0) {
            g = new TopoSortGenerator(g);
        }
        if (this.walker.hasRevSort(RevSort.REVERSE)) {
            g = new LIFORevQueue(g);
        }
        if (boundary) {
            g = new BoundaryGenerator(w, g);
        } else if (uninteresting) {
            if (pending.peek() != null) {
                g = new DelayRevQueue(g);
            }
            g = new FixUninterestingGenerator(g);
        }
        w.pending = g;
        return g.next();
    }
}

