/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.merge;

import java.util.ArrayList;
import java.util.List;
import org.shaded.eclipse.jgit.lib.Ref;
import org.shaded.eclipse.jgit.lib.Repository;
import org.shaded.eclipse.jgit.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeMessageFormatter {
    public String format(List<Ref> refsToMerge, Ref target) {
        StringBuilder sb = new StringBuilder();
        sb.append("Merge ");
        ArrayList<String> branches = new ArrayList<String>();
        ArrayList<String> remoteBranches = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        ArrayList<String> commits = new ArrayList<String>();
        ArrayList<String> others = new ArrayList<String>();
        for (Ref ref : refsToMerge) {
            if (ref.getName().startsWith("refs/heads/")) {
                branches.add("'" + Repository.shortenRefName(ref.getName()) + "'");
                continue;
            }
            if (ref.getName().startsWith("refs/remotes/")) {
                remoteBranches.add("'" + Repository.shortenRefName(ref.getName()) + "'");
                continue;
            }
            if (ref.getName().startsWith("refs/tags/")) {
                tags.add("'" + Repository.shortenRefName(ref.getName()) + "'");
                continue;
            }
            if (ref.getName().equals(ref.getObjectId().getName())) {
                commits.add("'" + ref.getName() + "'");
                continue;
            }
            others.add(ref.getName());
        }
        ArrayList<String> listings = new ArrayList<String>();
        if (!branches.isEmpty()) {
            listings.add(MergeMessageFormatter.joinNames(branches, "branch", "branches"));
        }
        if (!remoteBranches.isEmpty()) {
            listings.add(MergeMessageFormatter.joinNames(remoteBranches, "remote branch", "remote branches"));
        }
        if (!tags.isEmpty()) {
            listings.add(MergeMessageFormatter.joinNames(tags, "tag", "tags"));
        }
        if (!commits.isEmpty()) {
            listings.add(MergeMessageFormatter.joinNames(commits, "commit", "commits"));
        }
        if (!others.isEmpty()) {
            listings.add(StringUtils.join(others, ", ", " and "));
        }
        sb.append(StringUtils.join(listings, ", "));
        String targetName = target.getLeaf().getName();
        if (!targetName.equals("refs/heads/master")) {
            String targetShortName = Repository.shortenRefName(target.getName());
            sb.append(" into " + targetShortName);
        }
        return sb.toString();
    }

    private static String joinNames(List<String> names, String singular, String plural) {
        if (names.size() == 1) {
            return singular + " " + names.get(0);
        }
        return plural + " " + StringUtils.join(names, ", ", " and ");
    }
}

