/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.lib;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.shaded.eclipse.jgit.JGitText;
import org.shaded.eclipse.jgit.errors.CheckoutConflictException;
import org.shaded.eclipse.jgit.lib.AbstractIndexTreeVisitor;
import org.shaded.eclipse.jgit.lib.GitIndex;
import org.shaded.eclipse.jgit.lib.IndexTreeWalker;
import org.shaded.eclipse.jgit.lib.ObjectId;
import org.shaded.eclipse.jgit.lib.Repository;
import org.shaded.eclipse.jgit.lib.Tree;
import org.shaded.eclipse.jgit.lib.TreeEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class WorkDirCheckout {
    File root;
    GitIndex index;
    private boolean failOnConflict = true;
    Tree merge;
    ArrayList<String> conflicts = new ArrayList();
    ArrayList<String> removed = new ArrayList();
    Tree head = null;
    HashMap<String, ObjectId> updated = new HashMap();

    public void setFailOnConflict(boolean failOnConflict) {
        this.failOnConflict = failOnConflict;
    }

    WorkDirCheckout(Repository repo, File workDir, GitIndex oldIndex, GitIndex newIndex) throws IOException {
        this.root = workDir;
        this.index = oldIndex;
        this.merge = repo.mapTree(newIndex.writeTree());
    }

    public WorkDirCheckout(Repository repo, File root, GitIndex index, Tree merge) {
        this.root = root;
        this.index = index;
        this.merge = merge;
    }

    public WorkDirCheckout(Repository repo, File root, Tree head, GitIndex index, Tree merge) {
        this(repo, root, index, merge);
        this.head = head;
    }

    public void checkout() throws IOException {
        if (this.head == null) {
            this.prescanOneTree();
        } else {
            this.prescanTwoTrees();
        }
        if (!this.conflicts.isEmpty() && this.failOnConflict) {
            String[] entries = this.conflicts.toArray(new String[0]);
            throw new CheckoutConflictException(entries);
        }
        this.cleanUpConflicts();
        if (this.head == null) {
            this.checkoutOutIndexNoHead();
        } else {
            this.checkoutTwoTrees();
        }
    }

    private void checkoutTwoTrees() throws FileNotFoundException, IOException {
        for (String string : this.removed) {
            this.index.remove(this.root, new File(this.root, string));
        }
        for (Map.Entry entry : this.updated.entrySet()) {
            GitIndex.Entry newEntry = this.index.addEntry(this.merge.findBlobMember((String)entry.getKey()));
            this.index.checkoutEntry(this.root, newEntry);
        }
    }

    private void checkoutOutIndexNoHead() throws IOException {
        new IndexTreeWalker(this.index, this.merge, this.root, new AbstractIndexTreeVisitor(){

            public void visitEntry(TreeEntry m, GitIndex.Entry i, File f) throws IOException {
                if (f.getName().equals(".gitmodules")) {
                    throw new UnsupportedOperationException(JGitText.get().submodulesNotSupported);
                }
                if (m == null) {
                    WorkDirCheckout.this.index.remove(WorkDirCheckout.this.root, f);
                    return;
                }
                boolean needsCheckout = false;
                if (i == null) {
                    needsCheckout = true;
                } else if (i.getObjectId().equals(m.getId())) {
                    if (i.isModified(WorkDirCheckout.this.root, true)) {
                        needsCheckout = true;
                    }
                } else {
                    needsCheckout = true;
                }
                if (needsCheckout) {
                    GitIndex.Entry newEntry = WorkDirCheckout.this.index.addEntry(m);
                    WorkDirCheckout.this.index.checkoutEntry(WorkDirCheckout.this.root, newEntry);
                }
            }
        }).walk();
    }

    private void cleanUpConflicts() throws CheckoutConflictException {
        for (String c : this.conflicts) {
            File conflict = new File(this.root, c);
            if (!conflict.delete()) {
                throw new CheckoutConflictException(MessageFormat.format(JGitText.get().cannotDeleteFile, c));
            }
            this.removeEmptyParents(conflict);
        }
        for (String r : this.removed) {
            File file = new File(this.root, r);
            file.delete();
            this.removeEmptyParents(file);
        }
    }

    private void removeEmptyParents(File f) {
        File parentFile = f.getParentFile();
        while (!parentFile.equals(this.root) && parentFile.list().length == 0) {
            parentFile.delete();
            parentFile = parentFile.getParentFile();
        }
    }

    void prescanOneTree() throws IOException {
        new IndexTreeWalker(this.index, this.merge, this.root, new AbstractIndexTreeVisitor(){

            public void visitEntry(TreeEntry m, GitIndex.Entry i, File file) throws IOException {
                if (m != null) {
                    if (!file.isFile()) {
                        WorkDirCheckout.this.checkConflictsWithFile(file);
                    }
                } else if (file.exists()) {
                    WorkDirCheckout.this.removed.add(i.getName());
                    WorkDirCheckout.this.conflicts.remove(i.getName());
                }
            }
        }).walk();
        this.conflicts.removeAll(this.removed);
    }

    private ArrayList<String> listFiles(File file) {
        ArrayList<String> list = new ArrayList<String>();
        this.listFiles(file, list);
        return list;
    }

    private void listFiles(File dir, ArrayList<String> list) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                this.listFiles(f, list);
                continue;
            }
            list.add(Repository.stripWorkDir(this.root, f));
        }
    }

    public ArrayList<String> getConflicts() {
        return this.conflicts;
    }

    public ArrayList<String> getRemoved() {
        return this.removed;
    }

    void prescanTwoTrees() throws IOException {
        new IndexTreeWalker(this.index, this.head, this.merge, this.root, new AbstractIndexTreeVisitor(){

            public void visitEntry(TreeEntry treeEntry, TreeEntry auxEntry, GitIndex.Entry indexEntry, File file) throws IOException {
                if (treeEntry instanceof Tree || auxEntry instanceof Tree) {
                    throw new IllegalArgumentException(JGitText.get().cantPassMeATree);
                }
                WorkDirCheckout.this.processEntry(treeEntry, auxEntry, indexEntry);
            }

            public void finishVisitTree(Tree tree, Tree auxTree, String curDir) throws IOException {
                if (curDir.length() == 0) {
                    return;
                }
                if (auxTree != null && WorkDirCheckout.this.index.getEntry(curDir) != null) {
                    WorkDirCheckout.this.removed.add(curDir);
                }
            }
        }).walk();
        this.removed.removeAll(this.conflicts);
        for (String path : this.updated.keySet()) {
            if (this.index.getEntry(path) != null) continue;
            File file = new File(this.root, path);
            if (file.isFile()) {
                this.conflicts.add(path);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.checkConflictsWithFile(file);
        }
        this.conflicts.removeAll(this.removed);
    }

    void processEntry(TreeEntry h, TreeEntry m, GitIndex.Entry i) throws IOException {
        String name;
        ObjectId hId;
        ObjectId iId = i == null ? null : i.getObjectId();
        ObjectId mId = m == null ? null : m.getId();
        ObjectId objectId = hId = h == null ? null : h.getId();
        String string = i != null ? i.getName() : (name = h != null ? h.getFullName() : m.getFullName());
        if (i == null) {
            if (h == null) {
                this.updated.put(name, mId);
            } else if (m == null) {
                this.removed.add(name);
            } else {
                this.updated.put(name, mId);
            }
        } else if (h == null) {
            if (m == null || mId.equals(iId)) {
                if (this.hasParentBlob(this.merge, name)) {
                    if (i.isModified(this.root, true)) {
                        this.conflicts.add(name);
                    } else {
                        this.removed.add(name);
                    }
                }
            } else {
                this.conflicts.add(name);
            }
        } else if (m == null) {
            if (hId.equals(iId)) {
                if (i.isModified(this.root, true)) {
                    this.conflicts.add(name);
                } else {
                    this.removed.add(name);
                }
            } else {
                this.conflicts.add(name);
            }
        } else if (!(hId.equals(mId) || hId.equals(iId) || mId.equals(iId))) {
            this.conflicts.add(name);
        } else if (hId.equals(iId) && !mId.equals(iId)) {
            if (i.isModified(this.root, true)) {
                this.conflicts.add(name);
            } else {
                this.updated.put(name, mId);
            }
        }
    }

    private boolean hasParentBlob(Tree t, String name) throws IOException {
        if (name.indexOf("/") == -1) {
            return false;
        }
        String parent = name.substring(0, name.lastIndexOf("/"));
        if (t.findBlobMember(parent) != null) {
            return true;
        }
        return this.hasParentBlob(t, parent);
    }

    private void checkConflictsWithFile(File file) {
        if (file.isDirectory()) {
            ArrayList<String> childFiles = this.listFiles(file);
            this.conflicts.addAll(childFiles);
        } else {
            File parent = file.getParentFile();
            while (!parent.equals(this.root) && !parent.isDirectory()) {
                if (parent.isFile()) {
                    this.conflicts.add(Repository.stripWorkDir(this.root, parent));
                    break;
                }
                parent = parent.getParentFile();
            }
        }
    }
}

