/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import org.shaded.eclipse.jgit.JGitText;
import org.shaded.eclipse.jgit.api.GitCommand;
import org.shaded.eclipse.jgit.api.errors.InvalidRefNameException;
import org.shaded.eclipse.jgit.api.errors.JGitInternalException;
import org.shaded.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.shaded.eclipse.jgit.api.errors.RefNotFoundException;
import org.shaded.eclipse.jgit.errors.AmbiguousObjectException;
import org.shaded.eclipse.jgit.lib.ObjectId;
import org.shaded.eclipse.jgit.lib.Ref;
import org.shaded.eclipse.jgit.lib.RefUpdate;
import org.shaded.eclipse.jgit.lib.Repository;
import org.shaded.eclipse.jgit.lib.StoredConfig;
import org.shaded.eclipse.jgit.revwalk.RevCommit;
import org.shaded.eclipse.jgit.revwalk.RevWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateBranchCommand
extends GitCommand<Ref> {
    private String name;
    private boolean force = false;
    private SetupUpstreamMode upstreamMode;
    private String startPoint = "HEAD";
    private RevCommit startCommit;

    protected CreateBranchCommand(Repository repo) {
        super(repo);
    }

    @Override
    public Ref call() throws JGitInternalException, RefAlreadyExistsException, RefNotFoundException, InvalidRefNameException {
        this.checkCallable();
        this.processOptions();
        try {
            String autosetupflag;
            String refLogMessage;
            Ref baseRef;
            boolean exists;
            Ref refToCheck = this.repo.getRef(this.name);
            boolean bl = exists = refToCheck != null && refToCheck.getName().startsWith("refs/heads/");
            if (!this.force && exists) {
                throw new RefAlreadyExistsException(MessageFormat.format(JGitText.get().refAlreadExists, this.name));
            }
            ObjectId startAt = this.getStartPoint();
            String startPointFullName = null;
            if (this.startPoint != null && (baseRef = this.repo.getRef(this.startPoint)) != null) {
                startPointFullName = baseRef.getName();
            }
            String baseBranch = "";
            if (startPointFullName == null) {
                String baseCommit;
                if (this.startCommit != null) {
                    baseCommit = this.startCommit.getShortMessage();
                } else {
                    RevCommit commit = new RevWalk(this.repo).parseCommit(this.repo.resolve(this.startPoint));
                    baseCommit = commit.getShortMessage();
                }
                refLogMessage = exists ? "branch: Reset start-point to commit " + baseCommit : "branch: Created from commit " + baseCommit;
            } else if (startPointFullName.startsWith("refs/heads/") || startPointFullName.startsWith("refs/remotes/")) {
                baseBranch = startPointFullName;
                refLogMessage = exists ? "branch: Reset start-point to branch " + startPointFullName : "branch: Created from branch " + baseBranch;
            } else {
                refLogMessage = exists ? "branch: Reset start-point to tag " + startPointFullName : "branch: Created from tag " + startPointFullName;
            }
            RefUpdate updateRef = this.repo.updateRef("refs/heads/" + this.name);
            updateRef.setNewObjectId(startAt);
            updateRef.setRefLogMessage(refLogMessage, false);
            RefUpdate.Result updateResult = exists && this.force ? updateRef.forceUpdate() : updateRef.update();
            this.setCallable(false);
            boolean ok = false;
            switch (updateResult) {
                case NEW: {
                    ok = !exists;
                    break;
                }
                case NO_CHANGE: 
                case FAST_FORWARD: 
                case FORCED: {
                    ok = exists;
                    break;
                }
            }
            if (!ok) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().createBranchUnexpectedResult, updateResult.name()));
            }
            Ref result = this.repo.getRef(this.name);
            if (result == null) {
                throw new JGitInternalException(JGitText.get().createBranchFailedUnknownReason);
            }
            if (baseBranch.length() == 0) {
                return result;
            }
            boolean doConfigure = this.upstreamMode == SetupUpstreamMode.SET_UPSTREAM || this.upstreamMode == SetupUpstreamMode.TRACK ? true : (this.upstreamMode == SetupUpstreamMode.NOTRACK ? false : ("false".equals(autosetupflag = this.repo.getConfig().getString("branch", null, "autosetupmerge")) ? false : ("always".equals(autosetupflag) ? true : baseBranch.startsWith("refs/remotes/"))));
            if (doConfigure) {
                StoredConfig config = this.repo.getConfig();
                String[] tokens = baseBranch.split("/", 4);
                boolean isRemote = tokens[1].equals("remotes");
                if (isRemote) {
                    String remoteName = tokens[2];
                    String branchName = tokens[3];
                    config.setString("branch", this.name, "remote", remoteName);
                    config.setString("branch", this.name, "merge", "refs/heads/" + branchName);
                } else {
                    config.setString("branch", this.name, "remote", ".");
                    config.setString("branch", this.name, "merge", baseBranch);
                }
                config.save();
            }
            return result;
        }
        catch (IOException ioe) {
            throw new JGitInternalException(ioe.getMessage(), ioe);
        }
    }

    private ObjectId getStartPoint() throws AmbiguousObjectException, RefNotFoundException, IOException {
        if (this.startCommit != null) {
            return this.startCommit.getId();
        }
        ObjectId result = null;
        result = this.repo.resolve(this.startPoint == null ? "HEAD" : this.startPoint);
        if (result == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, this.startPoint != null ? this.startPoint : "HEAD"));
        }
        return result;
    }

    private void processOptions() throws InvalidRefNameException {
        if (this.name == null || !Repository.isValidRefName("refs/heads/" + this.name)) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().branchNameInvalid, this.name == null ? "<null>" : this.name));
        }
    }

    public CreateBranchCommand setName(String name) {
        this.checkCallable();
        this.name = name;
        return this;
    }

    public CreateBranchCommand setForce(boolean force) {
        this.checkCallable();
        this.force = force;
        return this;
    }

    public CreateBranchCommand setStartPoint(String startPoint) {
        this.checkCallable();
        this.startPoint = startPoint;
        this.startCommit = null;
        return this;
    }

    public CreateBranchCommand setStartPoint(RevCommit startPoint) {
        this.checkCallable();
        this.startCommit = startPoint;
        this.startPoint = null;
        return this;
    }

    public CreateBranchCommand setUpstreamMode(SetupUpstreamMode mode) {
        this.checkCallable();
        this.upstreamMode = mode;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SetupUpstreamMode {
        TRACK,
        NOTRACK,
        SET_UPSTREAM;

    }
}

