/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.net.ConnectException;
import java.net.UnknownHostException;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.TcpTransport;
import org.eclipse.jgit.transport.URIish;

public abstract class SshTransport
extends TcpTransport {
    private SshSessionFactory sch = SshSessionFactory.getInstance();
    protected Session sock;

    protected SshTransport(Repository local, URIish uri) {
        super(local, uri);
    }

    public void setSshSessionFactory(SshSessionFactory factory) {
        if (factory == null) {
            throw new NullPointerException(JGitText.get().theFactoryMustNotBeNull);
        }
        if (this.sock != null) {
            throw new IllegalStateException(JGitText.get().anSSHSessionHasBeenAlreadyCreated);
        }
        this.sch = factory;
    }

    public SshSessionFactory getSshSessionFactory() {
        return this.sch;
    }

    protected void initSession() throws TransportException {
        if (this.sock != null) {
            return;
        }
        int tms = this.getTimeout() > 0 ? this.getTimeout() * 1000 : 0;
        String user = this.uri.getUser();
        String pass = this.uri.getPass();
        String host = this.uri.getHost();
        int port = this.uri.getPort();
        try {
            this.sock = this.sch.getSession(user, pass, host, port, this.getCredentialsProvider(), this.local.getFS());
            if (!this.sock.isConnected()) {
                this.sock.connect(tms);
            }
        }
        catch (JSchException je) {
            Throwable c = je.getCause();
            if (c instanceof UnknownHostException) {
                throw new TransportException(this.uri, JGitText.get().unknownHost);
            }
            if (c instanceof ConnectException) {
                throw new TransportException(this.uri, c.getMessage());
            }
            throw new TransportException(this.uri, je.getMessage(), je);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.sock != null) {
            try {
                this.sch.releaseSession(this.sock);
                Object var2_1 = null;
                this.sock = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.sock = null;
                throw throwable;
            }
        }
    }
}

