/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;

public class ReceiveCommand {
    private final ObjectId oldId;
    private final ObjectId newId;
    private final String name;
    private Type type;
    private Ref ref;
    private Result status;
    private String message;

    public ReceiveCommand(ObjectId oldId, ObjectId newId, String name) {
        this.oldId = oldId;
        this.newId = newId;
        this.name = name;
        this.type = Type.UPDATE;
        if (ObjectId.zeroId().equals(oldId)) {
            this.type = Type.CREATE;
        }
        if (ObjectId.zeroId().equals(newId)) {
            this.type = Type.DELETE;
        }
        this.status = Result.NOT_ATTEMPTED;
    }

    public ObjectId getOldId() {
        return this.oldId;
    }

    public ObjectId getNewId() {
        return this.newId;
    }

    public String getRefName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public Ref getRef() {
        return this.ref;
    }

    public Result getResult() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setResult(Result s) {
        this.setResult(s, null);
    }

    public void setResult(Result s, String m) {
        this.status = s;
        this.message = m;
    }

    void setRef(Ref r) {
        this.ref = r;
    }

    void setType(Type t) {
        this.type = t;
    }

    public String toString() {
        return this.getType().name() + ": " + this.getOldId().name() + " " + this.getNewId().name() + " " + this.getRefName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Result {
        NOT_ATTEMPTED,
        REJECTED_NOCREATE,
        REJECTED_NODELETE,
        REJECTED_NONFASTFORWARD,
        REJECTED_CURRENT_BRANCH,
        REJECTED_MISSING_OBJECT,
        REJECTED_OTHER_REASON,
        LOCK_FAILURE,
        OK;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        CREATE,
        UPDATE,
        UPDATE_NONFASTFORWARD,
        DELETE;

    }
}

