/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.transport;

import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.shaded.eclipse.jgit.JGitText;

public class URIish
implements Serializable {
    private static final String SCHEME_P = "([a-z][a-z0-9+-]+)://";
    private static final String OPT_USER_PWD_P = "(?:([^/:@]+)(?::([^/]+))?@)?";
    private static final String HOST_P = "([^/:]+)";
    private static final String OPT_PORT_P = "(?::(\\d+))?";
    private static final String USER_HOME_P = "(?:/~(?:[^/]+))";
    private static final String OPT_DRIVE_LETTER_P = "(?:[A-Za-z]:)?";
    private static final String RELATIVE_PATH_P = "(?:(?:[^/]+/)*[^/]+/?)";
    private static final String PATH_P = "((?:[A-Za-z]:)?/?(?:(?:[^/]+/)*[^/]+/?))";
    private static final long serialVersionUID = 1L;
    private static final Pattern FULL_URI = Pattern.compile("^([a-z][a-z0-9+-]+)://(?:(?:([^/:@]+)(?::([^/]+))?@)?([^/:]+)(?::(\\d+))?((?:/~(?:[^/]+))?/))?(.+)?$");
    private static final Pattern LOCAL_FILE = Pattern.compile("^(/?((?:[A-Za-z]:)?/?(?:(?:[^/]+/)*[^/]+/?)))$");
    private static final Pattern SINGLE_SLASH_FILE_URI = Pattern.compile("^(file):(/(?!/)((?:[A-Za-z]:)?/?(?:(?:[^/]+/)*[^/]+/?)))$");
    private static final Pattern RELATIVE_SCP_URI = Pattern.compile("^(?:([^/:@]+)(?::([^/]+))?@)?([^/:]+):((?:(?:/~(?:[^/]+))/)?(?:(?:[^/]+/)*[^/]+/?))$");
    private static final Pattern ABSOLUTE_SCP_URI = Pattern.compile("^(?:([^/:@]+)(?::([^/]+))?@)?([^/:]{2,}):(/(?:(?:[^/]+/)*[^/]+/?))$");
    private String scheme;
    private String path;
    private String user;
    private String pass;
    private int port = -1;
    private String host;

    public URIish(String s) throws URISyntaxException {
        s = s.replace('\\', '/');
        Matcher matcher = SINGLE_SLASH_FILE_URI.matcher(s);
        if (matcher.matches()) {
            this.scheme = matcher.group(1);
            this.path = this.cleanLeadingSlashes(matcher.group(2), this.scheme);
        } else {
            matcher = FULL_URI.matcher(s);
            if (matcher.matches()) {
                this.scheme = matcher.group(1);
                this.user = matcher.group(2);
                this.pass = matcher.group(3);
                this.host = matcher.group(4);
                if (matcher.group(5) != null) {
                    this.port = Integer.parseInt(matcher.group(5));
                }
                this.path = this.cleanLeadingSlashes(this.n2e(matcher.group(6)) + this.n2e(matcher.group(7)), this.scheme);
            } else {
                matcher = RELATIVE_SCP_URI.matcher(s);
                if (matcher.matches()) {
                    this.user = matcher.group(1);
                    this.pass = matcher.group(2);
                    this.host = matcher.group(3);
                    this.path = matcher.group(4);
                } else {
                    matcher = ABSOLUTE_SCP_URI.matcher(s);
                    if (matcher.matches()) {
                        this.user = matcher.group(1);
                        this.pass = matcher.group(2);
                        this.host = matcher.group(3);
                        this.path = matcher.group(4);
                    } else {
                        matcher = LOCAL_FILE.matcher(s);
                        if (matcher.matches()) {
                            this.path = matcher.group(1);
                        } else {
                            throw new URISyntaxException(s, JGitText.get().cannotParseGitURIish);
                        }
                    }
                }
            }
        }
    }

    private String n2e(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    private String cleanLeadingSlashes(String p, String s) {
        if (p.length() >= 3 && p.charAt(0) == '/' && p.charAt(2) == ':' && (p.charAt(1) >= 'A' && p.charAt(1) <= 'Z' || p.charAt(1) >= 'a' && p.charAt(1) <= 'z')) {
            return p.substring(1);
        }
        if (s != null && p.length() >= 2 && p.charAt(0) == '/' && p.charAt(1) == '~') {
            return p.substring(1);
        }
        return p;
    }

    public URIish(URL u) {
        this.scheme = u.getProtocol();
        this.path = u.getPath();
        String ui = u.getUserInfo();
        if (ui != null) {
            int d = ui.indexOf(58);
            this.user = d < 0 ? ui : ui.substring(0, d);
            this.pass = d < 0 ? null : ui.substring(d + 1);
        }
        this.port = u.getPort();
        this.host = u.getHost();
    }

    public URIish() {
    }

    private URIish(URIish u) {
        this.scheme = u.scheme;
        this.path = u.path;
        this.user = u.user;
        this.pass = u.pass;
        this.port = u.port;
        this.host = u.host;
    }

    public boolean isRemote() {
        return this.getHost() != null;
    }

    public String getHost() {
        return this.host;
    }

    public URIish setHost(String n) {
        URIish r = new URIish(this);
        r.host = n;
        return r;
    }

    public String getScheme() {
        return this.scheme;
    }

    public URIish setScheme(String n) {
        URIish r = new URIish(this);
        r.scheme = n;
        return r;
    }

    public String getPath() {
        return this.path;
    }

    public URIish setPath(String n) {
        URIish r = new URIish(this);
        r.path = n;
        return r;
    }

    public String getUser() {
        return this.user;
    }

    public URIish setUser(String n) {
        URIish r = new URIish(this);
        r.user = n;
        return r;
    }

    public String getPass() {
        return this.pass;
    }

    public URIish setPass(String n) {
        URIish r = new URIish(this);
        r.pass = n;
        return r;
    }

    public int getPort() {
        return this.port;
    }

    public URIish setPort(int n) {
        URIish r = new URIish(this);
        r.port = n > 0 ? n : -1;
        return r;
    }

    public int hashCode() {
        int hc = 0;
        if (this.getScheme() != null) {
            hc = hc * 31 + this.getScheme().hashCode();
        }
        if (this.getUser() != null) {
            hc = hc * 31 + this.getUser().hashCode();
        }
        if (this.getPass() != null) {
            hc = hc * 31 + this.getPass().hashCode();
        }
        if (this.getHost() != null) {
            hc = hc * 31 + this.getHost().hashCode();
        }
        if (this.getPort() > 0) {
            hc = hc * 31 + this.getPort();
        }
        if (this.getPath() != null) {
            hc = hc * 31 + this.getPath().hashCode();
        }
        return hc;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof URIish)) {
            return false;
        }
        URIish b = (URIish)obj;
        if (!URIish.eq(this.getScheme(), b.getScheme())) {
            return false;
        }
        if (!URIish.eq(this.getUser(), b.getUser())) {
            return false;
        }
        if (!URIish.eq(this.getPass(), b.getPass())) {
            return false;
        }
        if (!URIish.eq(this.getHost(), b.getHost())) {
            return false;
        }
        if (this.getPort() != b.getPort()) {
            return false;
        }
        return URIish.eq(this.getPath(), b.getPath());
    }

    private static boolean eq(String a, String b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public String toPrivateString() {
        return this.format(true);
    }

    public String toString() {
        return this.format(false);
    }

    private String format(boolean includePassword) {
        StringBuilder r = new StringBuilder();
        if (this.getScheme() != null) {
            r.append(this.getScheme());
            r.append("://");
        }
        if (this.getUser() != null) {
            r.append(this.getUser());
            if (includePassword && this.getPass() != null) {
                r.append(':');
                r.append(this.getPass());
            }
        }
        if (this.getHost() != null) {
            if (this.getUser() != null) {
                r.append('@');
            }
            r.append(this.getHost());
            if (this.getScheme() != null && this.getPort() > 0) {
                r.append(':');
                r.append(this.getPort());
            }
        }
        if (this.getPath() != null) {
            if (this.getScheme() != null) {
                if (!this.getPath().startsWith("/")) {
                    r.append('/');
                }
            } else if (this.getHost() != null) {
                r.append(':');
            }
            r.append(this.getPath());
        }
        return r.toString();
    }

    public String getHumanishName() throws IllegalArgumentException {
        if ("".equals(this.getPath()) || this.getPath() == null) {
            throw new IllegalArgumentException();
        }
        String[] elements = this.getPath().split("/");
        if (elements.length == 0) {
            throw new IllegalArgumentException();
        }
        String result = elements[elements.length - 1];
        if (".git".equals(result)) {
            result = elements[elements.length - 2];
        } else if (result.endsWith(".git")) {
            result = result.substring(0, result.length() - ".git".length());
        }
        return result;
    }
}

