/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.NoMessageException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.errors.UnmergedPathException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitCommand
extends GitCommand<RevCommit> {
    private PersonIdent author;
    private PersonIdent committer;
    private String message;
    private boolean all;
    private List<ObjectId> parents = new LinkedList<ObjectId>();

    protected CommitCommand(Repository repo) {
        super(repo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RevCommit call() throws NoHeadException, NoMessageException, UnmergedPathException, ConcurrentRefUpdateException, JGitInternalException, WrongRepositoryStateException {
        this.checkCallable();
        RepositoryState state = this.repo.getRepositoryState();
        if (!state.canCommit()) {
            throw new WrongRepositoryStateException(MessageFormat.format(JGitText.get().cannotCommitOnARepoWithState, state.name()));
        }
        this.processOptions(state);
        try {
            Ref head;
            if (this.all && !this.repo.isBare() && this.repo.getWorkTree() != null) {
                Git git = new Git(this.repo);
                try {
                    git.add().addFilepattern(".").setUpdate(true).call();
                }
                catch (NoFilepatternException e) {
                    throw new JGitInternalException(e.getMessage(), e);
                }
            }
            if ((head = this.repo.getRef("HEAD")) == null) {
                throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
            }
            ObjectId headId = this.repo.resolve("HEAD^{commit}");
            if (headId != null) {
                this.parents.add(0, headId);
            }
            DirCache index = this.repo.lockDirCache();
            try {
                ObjectInserter odi = this.repo.newObjectInserter();
                try {
                    ObjectId indexTreeId = index.writeTree(odi);
                    CommitBuilder commit = new CommitBuilder();
                    commit.setCommitter(this.committer);
                    commit.setAuthor(this.author);
                    commit.setMessage(this.message);
                    commit.setParentIds(this.parents);
                    commit.setTreeId(indexTreeId);
                    ObjectId commitId = odi.insert(commit);
                    odi.flush();
                    RevWalk revWalk = new RevWalk(this.repo);
                    try {
                        RevCommit revCommit = revWalk.parseCommit(commitId);
                        RefUpdate ru = this.repo.updateRef("HEAD");
                        ru.setNewObjectId(commitId);
                        ru.setRefLogMessage("commit : " + revCommit.getShortMessage(), false);
                        ru.setExpectedOldObjectId(headId);
                        RefUpdate.Result rc = ru.update();
                        switch (rc) {
                            case NEW: 
                            case FAST_FORWARD: {
                                this.setCallable(false);
                                if (state == RepositoryState.MERGING_RESOLVED) {
                                    this.repo.writeMergeCommitMsg(null);
                                    this.repo.writeMergeHeads(null);
                                }
                                RevCommit revCommit2 = revCommit;
                                return revCommit2;
                            }
                            case REJECTED: 
                            case LOCK_FAILURE: {
                                throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, ru.getRef(), rc);
                            }
                        }
                        throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{"HEAD", commitId.toString(), rc}));
                    }
                    finally {
                        revWalk.release();
                    }
                }
                finally {
                    odi.release();
                }
            }
            finally {
                index.unlock();
            }
        }
        catch (UnmergedPathException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfCommitCommand, e);
        }
    }

    private void processOptions(RepositoryState state) throws NoMessageException {
        if (this.committer == null) {
            this.committer = new PersonIdent(this.repo);
        }
        if (this.author == null) {
            this.author = this.committer;
        }
        if (state == RepositoryState.MERGING_RESOLVED) {
            try {
                this.parents = this.repo.readMergeHeads();
            }
            catch (IOException e) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccuredDuringReadingOfGIT_DIR, "MERGE_HEAD", e), e);
            }
            if (this.message == null) {
                try {
                    this.message = this.repo.readMergeCommitMsg();
                }
                catch (IOException e) {
                    throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccuredDuringReadingOfGIT_DIR, "MERGE_MSG", e), e);
                }
            }
        }
        if (this.message == null) {
            throw new NoMessageException(JGitText.get().commitMessageNotSpecified);
        }
    }

    public CommitCommand setMessage(String message) {
        this.checkCallable();
        this.message = message;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public CommitCommand setCommitter(PersonIdent committer) {
        this.checkCallable();
        this.committer = committer;
        return this;
    }

    public CommitCommand setCommitter(String name, String email) {
        this.checkCallable();
        return this.setCommitter(new PersonIdent(name, email));
    }

    public PersonIdent getCommitter() {
        return this.committer;
    }

    public CommitCommand setAuthor(PersonIdent author) {
        this.checkCallable();
        this.author = author;
        return this;
    }

    public CommitCommand setAuthor(String name, String email) {
        this.checkCallable();
        return this.setAuthor(new PersonIdent(name, email));
    }

    public PersonIdent getAuthor() {
        return this.author;
    }

    public CommitCommand setAll(boolean all) {
        this.all = all;
        return this;
    }
}

