/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.AuthorImpl;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.commit.CommitImpl;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plugins.git.GitAuthenticationType;
import com.atlassian.bamboo.plugins.git.GitCacheDirectory;
import com.atlassian.bamboo.plugins.git.GitMavenPomAccessor;
import com.atlassian.bamboo.plugins.git.GitOperationHelper;
import com.atlassian.bamboo.repository.AbstractRepository;
import com.atlassian.bamboo.repository.CustomVariableProviderRepository;
import com.atlassian.bamboo.repository.MavenPomAccessor;
import com.atlassian.bamboo.repository.MavenPomAccessorCapableRepository;
import com.atlassian.bamboo.repository.NameValuePair;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.repository.SelectableAuthenticationRepository;
import com.atlassian.bamboo.security.StringEncrypter;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildChangesImpl;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.agent.remote.RemoteBuildDirectoryManager;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.util.concurrent.LazyReference;
import com.atlassian.util.concurrent.Supplier;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.opensymphony.xwork.TextProvider;
import com.opensymphony.xwork.util.LocalizedTextUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.log4j.Logger;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitRepository
extends AbstractRepository
implements MavenPomAccessorCapableRepository,
SelectableAuthenticationRepository,
CustomVariableProviderRepository {
    private static final String REPOSITORY_GIT_NAME = "repository.git.name";
    private static final String REPOSITORY_GIT_REPOSITORY_URL = "repository.git.repositoryUrl";
    private static final String REPOSITORY_GIT_AUTHENTICATION_TYPE = "repository.git.authenticationType";
    private static final String REPOSITORY_GIT_USERNAME = "repository.git.username";
    private static final String REPOSITORY_GIT_PASSWORD = "repository.git.password";
    private static final String REPOSITORY_GIT_BRANCH = "repository.git.branch";
    private static final String REPOSITORY_GIT_SSH_KEY = "repository.git.ssh.key";
    private static final String REPOSITORY_GIT_SSH_PASSPHRASE = "repository.git.ssh.passphrase";
    private static final String REPOSITORY_GIT_USE_SHALLOW_CLONES = "repository.git.useShallowClones";
    private static final String REPOSITORY_GIT_MAVEN_PATH = "repository.git.maven.path";
    private static final String TEMPORARY_GIT_PASSWORD = "temporary.git.password";
    private static final String TEMPORARY_GIT_PASSWORD_CHANGE = "temporary.git.password.change";
    private static final String TEMPORARY_GIT_SSH_PASSPHRASE = "temporary.git.ssh.passphrase";
    private static final String TEMPORARY_GIT_SSH_PASSPHRASE_CHANGE = "temporary.git.ssh.passphrase.change";
    private static final String TEMPORARY_GIT_SSH_KEY_FROM_FILE = "temporary.git.ssh.keyfile";
    private static final String TEMPORARY_GIT_SSH_KEY_CHANGE = "temporary.git.ssh.key.change";
    private static final GitAuthenticationType defaultAuthenticationType = GitAuthenticationType.NONE;
    private static boolean USE_SHALLOW_CLONES = new SystemProperty(false, new String[]{"atlassian.bamboo.git.useShallowClones", "ATLASSIAN_BAMBOO_GIT_USE_SHALLOW_CLONES"}).getValue(true);
    private static final Logger log = Logger.getLogger(GitRepository.class);
    final GitRepositoryAccessData accessData = new GitRepositoryAccessData();
    private transient String pathToPom;

    @NotNull
    public String getName() {
        return this.textProvider.getText(REPOSITORY_GIT_NAME);
    }

    public String getHost() {
        return null;
    }

    public boolean isRepositoryDifferent(@NotNull Repository repository) {
        if (repository instanceof GitRepository) {
            GitRepository gitRepo = (GitRepository)repository;
            return !new EqualsBuilder().append((Object)this.accessData.repositoryUrl, (Object)gitRepo.accessData.repositoryUrl).append((Object)this.accessData.branch, (Object)gitRepo.accessData.branch).append((Object)this.accessData.username, (Object)gitRepo.accessData.username).append((Object)this.accessData.sshKey, (Object)gitRepo.accessData.sshKey).isEquals();
        }
        return true;
    }

    @NotNull
    public BuildChanges collectChangesSinceLastBuild(@NotNull String planKey, final @Nullable String lastVcsRevisionKey) throws RepositoryException {
        try {
            final GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData();
            final BuildLogger buildLogger = this.buildLoggerManager.getBuildLogger(PlanKeys.getPlanKey((String)planKey));
            final GitOperationHelper helper = new GitOperationHelper(buildLogger, this.textProvider);
            final String targetRevision = helper.obtainLatestRevision(substitutedAccessData);
            if (targetRevision.equals(lastVcsRevisionKey)) {
                return new BuildChangesImpl(targetRevision);
            }
            final File cacheDirectory = this.getCacheDirectory();
            if (lastVcsRevisionKey == null) {
                buildLogger.addBuildLogEntry(this.textProvider.getText("repository.git.messages.ccRepositoryNeverChecked", Arrays.asList(targetRevision)));
                try {
                    GitCacheDirectory.getCacheLock(cacheDirectory).withLock((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws RepositoryException {
                            boolean doShallowFetch = USE_SHALLOW_CLONES && substitutedAccessData.useShallowClones && !cacheDirectory.isDirectory();
                            helper.fetch(cacheDirectory, substitutedAccessData, doShallowFetch);
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    throw new RepositoryException(e.getMessage(), (Throwable)e);
                }
                return new BuildChangesImpl(targetRevision);
            }
            BuildChanges buildChanges = (BuildChanges)GitCacheDirectory.getCacheLock(cacheDirectory).withLock((Supplier)new Supplier<BuildChanges>(){

                public BuildChanges get() {
                    try {
                        helper.fetch(cacheDirectory, substitutedAccessData, false);
                        return helper.extractCommits(cacheDirectory, lastVcsRevisionKey, targetRevision);
                    }
                    catch (Exception e) {
                        try {
                            buildLogger.addBuildLogEntry(GitRepository.this.textProvider.getText("repository.git.messages.ccRecover.failedToCollectChangesets", Arrays.asList(cacheDirectory)));
                            FileUtils.deleteQuietly((File)cacheDirectory);
                            buildLogger.addBuildLogEntry(GitRepository.this.textProvider.getText("repository.git.messages.ccRecover.cleanedCacheDirectory", Arrays.asList(cacheDirectory)));
                            helper.fetch(cacheDirectory, substitutedAccessData, false);
                            buildLogger.addBuildLogEntry(GitRepository.this.textProvider.getText("repository.git.messages.ccRecover.fetchedRemoteRepository", Arrays.asList(cacheDirectory)));
                            BuildChanges extractedChanges = helper.extractCommits(cacheDirectory, lastVcsRevisionKey, targetRevision);
                            buildLogger.addBuildLogEntry(GitRepository.this.textProvider.getText("repository.git.messages.ccRecover.completed"));
                            return extractedChanges;
                        }
                        catch (Exception e2) {
                            log.error((Object)buildLogger.addBuildLogEntry(GitRepository.this.textProvider.getText("repository.git.messages.ccRecover.failedToExtractChangesets")), (Throwable)e2);
                            return null;
                        }
                    }
                }
            });
            if (buildChanges != null && !buildChanges.getChanges().isEmpty()) {
                return buildChanges;
            }
            return new BuildChangesImpl(targetRevision, Collections.singletonList(new CommitImpl((Author)new AuthorImpl("[unknown]"), this.textProvider.getText("repository.git.messages.unknownChanges", Arrays.asList(lastVcsRevisionKey, targetRevision)), new Date())));
        }
        catch (RuntimeException e) {
            throw new RepositoryException(this.textProvider.getText("repository.git.messages.runtimeException"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String retrieveSourceCode(@NotNull BuildContext buildContext, @Nullable String nullableTargetRevision) throws RepositoryException {
        final GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData();
        final BuildLogger buildLogger = this.buildLoggerManager.getBuildLogger(buildContext.getPlanResultKey());
        String planKey = buildContext.getPlanKey();
        final File sourceDirectory = this.getSourceCodeDirectory(planKey);
        final boolean doShallowFetch = USE_SHALLOW_CLONES && substitutedAccessData.useShallowClones;
        boolean isOnLocalAgent = !(this.buildDirectoryManager instanceof RemoteBuildDirectoryManager);
        final GitOperationHelper helper = new GitOperationHelper(buildLogger, this.textProvider);
        final String targetRevision = nullableTargetRevision != null ? nullableTargetRevision : helper.obtainLatestRevision(substitutedAccessData);
        final String previousRevision = helper.getCurrentRevision(sourceDirectory);
        if (isOnLocalAgent) {
            final File cacheDirectory = this.getCacheDirectory();
            return (String)GitCacheDirectory.getCacheLock(cacheDirectory).withLock((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    try {
                        helper.fetch(cacheDirectory, substitutedAccessData, doShallowFetch);
                    }
                    catch (Exception e) {
                        buildLogger.addBuildLogEntry(GitRepository.this.textProvider.getText("repository.git.messages.rsRecover.failedToFetchCache", Arrays.asList(cacheDirectory)));
                        FileUtils.deleteQuietly((File)cacheDirectory);
                        buildLogger.addBuildLogEntry(GitRepository.this.textProvider.getText("repository.git.messages.rsRecover.cleanedCacheDirectory", Arrays.asList(cacheDirectory)));
                        helper.fetch(cacheDirectory, substitutedAccessData, doShallowFetch);
                        buildLogger.addBuildLogEntry(GitRepository.this.textProvider.getText("repository.git.messages.rsRecover.fetchingCacheCompleted", Arrays.asList(cacheDirectory)));
                    }
                    try {
                        return helper.checkout(cacheDirectory, sourceDirectory, targetRevision, previousRevision);
                    }
                    catch (Exception e) {
                        String errorLog = GitRepository.this.textProvider.getText("repository.git.messages.rsRecover.failedToCheckout", Arrays.asList(sourceDirectory));
                        log.error((Object)errorLog, (Throwable)e);
                        buildLogger.addBuildLogEntry(errorLog);
                        FileUtils.deleteQuietly((File)sourceDirectory);
                        buildLogger.addBuildLogEntry(GitRepository.this.textProvider.getText("repository.git.messages.rsRecover.cleanedSourceDirectory", Arrays.asList(sourceDirectory)));
                        String returnRevision = helper.checkout(cacheDirectory, sourceDirectory, targetRevision, null);
                        buildLogger.addBuildLogEntry(GitRepository.this.textProvider.getText("repository.git.messages.rsRecover.checkoutCompleted"));
                        return returnRevision;
                    }
                }
            });
        }
        {
            catch (Exception e) {
                throw new RepositoryException(this.textProvider.getText("repository.git.messages.runtimeException"), (Throwable)e);
            }
            try {
                helper.fetch(sourceDirectory, substitutedAccessData, doShallowFetch);
                return helper.checkout(null, sourceDirectory, targetRevision, previousRevision);
            }
            catch (Exception e) {}
            {
                buildLogger.addBuildLogEntry(this.textProvider.getText("repository.git.messages.rsRecover.failedToCheckout", Arrays.asList(sourceDirectory)));
                FileUtils.deleteQuietly((File)sourceDirectory);
                buildLogger.addBuildLogEntry(this.textProvider.getText("repository.git.messages.rsRecover.cleanedSourceDirectory", Arrays.asList(sourceDirectory)));
                helper.fetch(sourceDirectory, substitutedAccessData, false);
                buildLogger.addBuildLogEntry(this.textProvider.getText("repository.git.messages.rsRecover.fetchingCompleted", Arrays.asList(sourceDirectory)));
                String returnRevision = helper.checkout(null, sourceDirectory, targetRevision, null);
                buildLogger.addBuildLogEntry(this.textProvider.getText("repository.git.messages.rsRecover.checkoutCompleted"));
                return returnRevision;
            }
        }
    }

    @Deprecated
    @NotNull
    public String retrieveSourceCode(@NotNull String planKey, @Nullable String vcsRevisionKey) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void addDefaultValues(@NotNull BuildConfiguration buildConfiguration) {
        buildConfiguration.setProperty(REPOSITORY_GIT_USE_SHALLOW_CLONES, (Object)true);
    }

    public void prepareConfigObject(@NotNull BuildConfiguration buildConfiguration) {
        LazyReference<StringEncrypter> encrypterRef = new LazyReference<StringEncrypter>(){

            protected StringEncrypter create() throws Exception {
                return new StringEncrypter();
            }
        };
        if (buildConfiguration.getBoolean(TEMPORARY_GIT_PASSWORD_CHANGE)) {
            buildConfiguration.setProperty(REPOSITORY_GIT_PASSWORD, (Object)((StringEncrypter)encrypterRef.get()).encrypt(buildConfiguration.getString(TEMPORARY_GIT_PASSWORD)));
        }
        if (buildConfiguration.getBoolean(TEMPORARY_GIT_SSH_PASSPHRASE_CHANGE)) {
            buildConfiguration.setProperty(REPOSITORY_GIT_SSH_PASSPHRASE, (Object)((StringEncrypter)encrypterRef.get()).encrypt(buildConfiguration.getString(TEMPORARY_GIT_SSH_PASSPHRASE)));
        }
        if (buildConfiguration.getBoolean(TEMPORARY_GIT_SSH_KEY_CHANGE)) {
            Object o = buildConfiguration.getProperty(TEMPORARY_GIT_SSH_KEY_FROM_FILE);
            if (o instanceof File) {
                String key;
                try {
                    key = FileUtils.readFileToString((File)((File)o));
                }
                catch (IOException e) {
                    log.error((Object)"Cannot read uploaded ssh key file", (Throwable)e);
                    return;
                }
                buildConfiguration.setProperty(REPOSITORY_GIT_SSH_KEY, (Object)((StringEncrypter)encrypterRef.get()).encrypt(key));
            } else {
                buildConfiguration.clearProperty(REPOSITORY_GIT_SSH_KEY);
            }
        }
    }

    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        super.populateFromConfig(config);
        this.accessData.repositoryUrl = StringUtils.trimToEmpty((String)config.getString(REPOSITORY_GIT_REPOSITORY_URL));
        this.accessData.username = config.getString(REPOSITORY_GIT_USERNAME, "");
        this.accessData.password = config.getString(REPOSITORY_GIT_PASSWORD);
        this.accessData.branch = config.getString(REPOSITORY_GIT_BRANCH, "");
        this.accessData.sshKey = config.getString(REPOSITORY_GIT_SSH_KEY, "");
        this.accessData.sshPassphrase = config.getString(REPOSITORY_GIT_SSH_PASSPHRASE);
        this.accessData.authenticationType = this.safeParseAuthenticationType(config.getString(REPOSITORY_GIT_AUTHENTICATION_TYPE));
        this.accessData.useShallowClones = config.getBoolean(REPOSITORY_GIT_USE_SHALLOW_CLONES);
        this.pathToPom = config.getString(REPOSITORY_GIT_MAVEN_PATH);
    }

    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        HierarchicalConfiguration configuration = super.toConfiguration();
        configuration.setProperty(REPOSITORY_GIT_REPOSITORY_URL, (Object)this.accessData.repositoryUrl);
        configuration.setProperty(REPOSITORY_GIT_USERNAME, (Object)this.accessData.username);
        configuration.setProperty(REPOSITORY_GIT_PASSWORD, (Object)this.accessData.password);
        configuration.setProperty(REPOSITORY_GIT_BRANCH, (Object)this.accessData.branch);
        configuration.setProperty(REPOSITORY_GIT_SSH_KEY, (Object)this.accessData.sshKey);
        configuration.setProperty(REPOSITORY_GIT_SSH_PASSPHRASE, (Object)this.accessData.sshPassphrase);
        configuration.setProperty(REPOSITORY_GIT_AUTHENTICATION_TYPE, this.accessData.authenticationType != null ? this.accessData.authenticationType.name() : null);
        configuration.setProperty(REPOSITORY_GIT_USE_SHALLOW_CLONES, (Object)this.accessData.useShallowClones);
        return configuration;
    }

    @NotNull
    public ErrorCollection validate(@NotNull BuildConfiguration buildConfiguration) {
        ErrorCollection errorCollection;
        block12: {
            errorCollection = super.validate(buildConfiguration);
            String repositoryUrl = StringUtils.trim((String)buildConfiguration.getString(REPOSITORY_GIT_REPOSITORY_URL));
            GitAuthenticationType authenticationType = this.safeParseAuthenticationType(buildConfiguration.getString(REPOSITORY_GIT_AUTHENTICATION_TYPE));
            if (StringUtils.isBlank((String)repositoryUrl)) {
                errorCollection.addError(REPOSITORY_GIT_REPOSITORY_URL, this.textProvider.getText("repository.git.messages.missingRepositoryUrl"));
            } else {
                boolean hasUsername = StringUtils.isNotBlank((String)buildConfiguration.getString(REPOSITORY_GIT_USERNAME));
                boolean hasPassword = StringUtils.isNotBlank((String)buildConfiguration.getString(REPOSITORY_GIT_PASSWORD));
                try {
                    URIish uri = new URIish(repositoryUrl);
                    if (authenticationType == GitAuthenticationType.SSH_KEYPAIR && ("http".equals(uri.getScheme()) || "https".equals(uri.getScheme()))) {
                        errorCollection.addError(REPOSITORY_GIT_AUTHENTICATION_TYPE, this.textProvider.getText("repository.git.messages.unsupportedHttpAuthenticationType"));
                    } else if (authenticationType == GitAuthenticationType.PASSWORD) {
                        boolean duplicatePassword;
                        boolean duplicateUsername = hasUsername && StringUtils.isNotBlank((String)uri.getUser());
                        boolean bl = duplicatePassword = hasPassword && StringUtils.isNotBlank((String)uri.getPass());
                        if (duplicateUsername || duplicatePassword) {
                            errorCollection.addError(REPOSITORY_GIT_REPOSITORY_URL, (duplicateUsername ? this.textProvider.getText("repository.git.messages.duplicateUsernameField") : "") + (duplicateUsername && duplicatePassword ? " " : "") + (duplicatePassword ? this.textProvider.getText("repository.git.messages.duplicatePasswordField") : ""));
                        }
                        if (duplicateUsername) {
                            errorCollection.addError(REPOSITORY_GIT_USERNAME, this.textProvider.getText("repository.git.messages.duplicateUsernameField"));
                        }
                        if (duplicatePassword) {
                            errorCollection.addError(TEMPORARY_GIT_PASSWORD_CHANGE, this.textProvider.getText("repository.git.messages.duplicatePasswordField"));
                        }
                        if (uri.getHost() == null && hasUsername) {
                            errorCollection.addError(REPOSITORY_GIT_USERNAME, this.textProvider.getText("repository.git.messages.unsupportedUsernameField"));
                        }
                    }
                }
                catch (URISyntaxException e) {
                    if (!hasUsername) break block12;
                    errorCollection.addError(REPOSITORY_GIT_USERNAME, this.textProvider.getText("repository.git.messages.unsupportedUsernameField"));
                }
            }
        }
        if (buildConfiguration.getString(REPOSITORY_GIT_MAVEN_PATH, "").contains("..")) {
            errorCollection.addError(REPOSITORY_GIT_MAVEN_PATH, this.textProvider.getText("repository.git.messages.invalidPomPath"));
        }
        return errorCollection;
    }

    @NotNull
    public Map<String, String> getCustomVariables() {
        HashMap variables = Maps.newHashMap();
        variables.put(REPOSITORY_GIT_REPOSITORY_URL, this.accessData.repositoryUrl);
        variables.put(REPOSITORY_GIT_BRANCH, this.accessData.branch);
        variables.put(REPOSITORY_GIT_USERNAME, this.accessData.username);
        return variables;
    }

    @NotNull
    public MavenPomAccessor getMavenPomAccessor() {
        return new GitMavenPomAccessor(this, this.textProvider).withPath(this.pathToPom);
    }

    @NotNull
    public List<NameValuePair> getAuthenticationTypes() {
        return Lists.transform(Arrays.asList(GitAuthenticationType.values()), (Function)new Function<GitAuthenticationType, NameValuePair>(){

            public NameValuePair apply(GitAuthenticationType from) {
                String typeName = from.name();
                return new NameValuePair(typeName, GitRepository.this.getAuthTypeName(typeName));
            }
        });
    }

    public String getAuthType() {
        return this.accessData.authenticationType != null ? this.accessData.authenticationType.name() : defaultAuthenticationType.name();
    }

    GitAuthenticationType safeParseAuthenticationType(String typeName) {
        if (typeName == null) {
            return defaultAuthenticationType;
        }
        try {
            return GitAuthenticationType.valueOf(typeName);
        }
        catch (IllegalArgumentException e) {
            return defaultAuthenticationType;
        }
    }

    String getAuthTypeName(String authType) {
        return this.textProvider.getText("repository.git.authenticationType." + StringUtils.lowerCase((String)authType));
    }

    GitRepositoryAccessData getSubstitutedAccessData() {
        GitRepositoryAccessData substituted = new GitRepositoryAccessData();
        substituted.repositoryUrl = this.substituteString(this.accessData.repositoryUrl);
        substituted.branch = this.substituteString(this.accessData.branch);
        substituted.username = this.substituteString(this.accessData.username);
        substituted.password = this.accessData.password;
        substituted.sshKey = this.accessData.sshKey;
        substituted.sshPassphrase = this.accessData.sshPassphrase;
        substituted.authenticationType = this.accessData.authenticationType;
        substituted.useShallowClones = this.accessData.useShallowClones;
        return substituted;
    }

    public boolean isUseShallowClones() {
        return this.accessData.useShallowClones;
    }

    public String getRepositoryUrl() {
        return this.accessData.repositoryUrl;
    }

    public String getBranch() {
        return this.accessData.branch;
    }

    public String getAuthTypeName() {
        return this.getAuthTypeName(this.getAuthType());
    }

    public File getCacheDirectory() {
        return GitCacheDirectory.getCacheDirectory(this.buildDirectoryManager.getBaseBuildWorkingDirectory(), this.getSubstitutedAccessData());
    }

    public synchronized void setTextProvider(TextProvider textProvider) {
        super.setTextProvider(textProvider);
        if (textProvider.getText(REPOSITORY_GIT_NAME) == null) {
            LocalizedTextUtil.addDefaultResourceBundle((String)"com.atlassian.bamboo.plugins.git.i18n");
        }
    }

    static class GitRepositoryAccessData
    implements Serializable {
        String repositoryUrl;
        String branch;
        String username;
        String password;
        String sshKey;
        String sshPassphrase;
        GitAuthenticationType authenticationType;
        boolean useShallowClones;

        GitRepositoryAccessData() {
        }
    }
}

