/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.plugins.git.GitAuthenticationType;
import com.atlassian.bamboo.plugins.git.GitRepository;
import com.atlassian.bamboo.repository.AbstractRepository;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.security.StringEncrypter;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.opensymphony.xwork.TextProvider;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitHubRepository
extends AbstractRepository {
    private static final String REPOSITORY_GITHUB_USERNAME = "repository.github.username";
    private static final String REPOSITORY_GITHUB_PASSWORD = "repository.github.password";
    private static final String REPOSITORY_GITHUB_REPOSITORY = "repository.github.repository";
    private static final String REPOSITORY_GITHUB_BRANCH = "repository.github.branch";
    private static final String REPOSITORY_GITHUB_USE_SHALLOW_CLONES = "repository.github.useShallowClones";
    private static final String REPOSITORY_GITHUB_TEMPORARY_PASSWORD = "repository.github.temporary.password";
    private static final String TEMPORARY_GITHUB_PASSWORD_CHANGE = "temporary.github.password.change";
    private static final String REPOSITORY_GITHUB_ERROR_MISSING_REPOSITORY = "repository.github.error.missingRepository";
    private static final Logger log = Logger.getLogger(GitHubRepository.class);
    private GitRepository gitRepository = new GitRepository();
    private String username;
    private String password;
    private String repository;
    private String branch;
    private boolean useShallowClones;

    public void setBuildDirectoryManager(BuildDirectoryManager buildDirectoryManager) {
        super.setBuildDirectoryManager(buildDirectoryManager);
        this.gitRepository.setBuildDirectoryManager(buildDirectoryManager);
    }

    public void setBuildLoggerManager(BuildLoggerManager buildLoggerManager) {
        super.setBuildLoggerManager(buildLoggerManager);
        this.gitRepository.setBuildLoggerManager(buildLoggerManager);
    }

    public void setTextProvider(TextProvider textProvider) {
        super.setTextProvider(textProvider);
        this.gitRepository.setTextProvider(textProvider);
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        super.setCustomVariableContext(customVariableContext);
        this.gitRepository.setCustomVariableContext(customVariableContext);
    }

    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        super.setTemplateRenderer(templateRenderer);
        this.gitRepository.setTemplateRenderer(templateRenderer);
    }

    @NotNull
    public String getName() {
        return "GitHub";
    }

    public String getHost() {
        return null;
    }

    public boolean isRepositoryDifferent(@NotNull Repository repository) {
        if (repository instanceof GitHubRepository) {
            GitHubRepository ghRepo = (GitHubRepository)repository;
            return !new EqualsBuilder().append((Object)this.repository, (Object)ghRepo.getRepository()).append((Object)this.branch, (Object)ghRepo.getBranch()).isEquals();
        }
        return true;
    }

    public void addDefaultValues(@NotNull BuildConfiguration buildConfiguration) {
        buildConfiguration.setProperty(REPOSITORY_GITHUB_USE_SHALLOW_CLONES, (Object)true);
    }

    public void prepareConfigObject(@NotNull BuildConfiguration buildConfiguration) {
        buildConfiguration.setProperty(REPOSITORY_GITHUB_USERNAME, (Object)buildConfiguration.getString(REPOSITORY_GITHUB_USERNAME, "").trim());
        if (buildConfiguration.getBoolean(TEMPORARY_GITHUB_PASSWORD_CHANGE)) {
            buildConfiguration.setProperty(REPOSITORY_GITHUB_PASSWORD, (Object)new StringEncrypter().encrypt(buildConfiguration.getString(REPOSITORY_GITHUB_TEMPORARY_PASSWORD)));
        }
        buildConfiguration.setProperty(REPOSITORY_GITHUB_REPOSITORY, (Object)buildConfiguration.getString(REPOSITORY_GITHUB_REPOSITORY, "").trim());
        buildConfiguration.setProperty(REPOSITORY_GITHUB_BRANCH, (Object)buildConfiguration.getString(REPOSITORY_GITHUB_BRANCH, "").trim());
    }

    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        super.populateFromConfig(config);
        this.username = config.getString(REPOSITORY_GITHUB_USERNAME);
        this.password = config.getString(REPOSITORY_GITHUB_PASSWORD);
        this.repository = config.getString(REPOSITORY_GITHUB_REPOSITORY);
        this.branch = config.getString(REPOSITORY_GITHUB_BRANCH);
        this.useShallowClones = config.getBoolean(REPOSITORY_GITHUB_USE_SHALLOW_CLONES);
        this.gitRepository.accessData.repositoryUrl = "https://github.com/" + this.repository + ".git";
        this.gitRepository.accessData.username = this.username;
        this.gitRepository.accessData.password = this.password;
        this.gitRepository.accessData.branch = this.branch;
        this.gitRepository.accessData.sshKey = "";
        this.gitRepository.accessData.sshPassphrase = "";
        this.gitRepository.accessData.authenticationType = GitAuthenticationType.PASSWORD;
        this.gitRepository.accessData.useShallowClones = this.useShallowClones;
    }

    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        HierarchicalConfiguration configuration = super.toConfiguration();
        configuration.setProperty(REPOSITORY_GITHUB_USERNAME, (Object)this.username);
        configuration.setProperty(REPOSITORY_GITHUB_PASSWORD, (Object)this.password);
        configuration.setProperty(REPOSITORY_GITHUB_REPOSITORY, (Object)this.repository);
        configuration.setProperty(REPOSITORY_GITHUB_BRANCH, (Object)this.branch);
        configuration.setProperty(REPOSITORY_GITHUB_USE_SHALLOW_CLONES, (Object)this.useShallowClones);
        return configuration;
    }

    @NotNull
    public ErrorCollection validate(@NotNull BuildConfiguration buildConfiguration) {
        ErrorCollection errorCollection = super.validate(buildConfiguration);
        if (StringUtils.isBlank((String)buildConfiguration.getString(REPOSITORY_GITHUB_REPOSITORY))) {
            errorCollection.addError(REPOSITORY_GITHUB_REPOSITORY, this.textProvider.getText(REPOSITORY_GITHUB_ERROR_MISSING_REPOSITORY));
        }
        return errorCollection;
    }

    @NotNull
    public BuildChanges collectChangesSinceLastBuild(@NotNull String planKey, @Nullable String lastVcsRevisionKey) throws RepositoryException {
        return this.gitRepository.collectChangesSinceLastBuild(planKey, lastVcsRevisionKey);
    }

    @NotNull
    public String retrieveSourceCode(@NotNull BuildContext buildContext, @Nullable String vcsRevision) throws RepositoryException {
        return this.gitRepository.retrieveSourceCode(buildContext, vcsRevision);
    }

    public String retrieveSourceCode(@NotNull String planKey, @Nullable String vcsRevisionKey) throws RepositoryException {
        return this.gitRepository.retrieveSourceCode(planKey, vcsRevisionKey);
    }

    public String getUsername() {
        return this.username;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getBranch() {
        return this.branch;
    }

    public boolean isUseShallowClones() {
        return this.useShallowClones;
    }

    String getPassword() {
        return this.password;
    }
}

