/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.transport.DaemonClient;
import org.eclipse.jgit.transport.DaemonService;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.UploadPack;
import org.eclipse.jgit.util.FS;

public class Daemon {
    public static final int DEFAULT_PORT = 9418;
    private static final int BACKLOG = 5;
    private InetSocketAddress myAddress;
    private final DaemonService[] services;
    private final ThreadGroup processors;
    private volatile boolean exportAll;
    private Map<String, Repository> exports;
    private Collection<File> exportBase;
    private boolean run;
    private Thread acceptThread;
    private int timeout;
    private PackConfig packConfig;

    public Daemon() {
        this(null);
    }

    public Daemon(InetSocketAddress addr) {
        this.myAddress = addr;
        this.exports = new ConcurrentHashMap<String, Repository>();
        this.exportBase = new CopyOnWriteArrayList<File>();
        this.processors = new ThreadGroup("Git-Daemon");
        this.services = new DaemonService[]{new DaemonService("upload-pack", "uploadpack"){
            {
                this.setEnabled(true);
            }

            protected void execute(DaemonClient dc, Repository db) throws IOException {
                UploadPack rp = new UploadPack(db);
                InputStream in = dc.getInputStream();
                rp.setTimeout(Daemon.this.getTimeout());
                rp.setPackConfig(Daemon.this.packConfig);
                rp.upload(in, dc.getOutputStream(), null);
            }
        }, new DaemonService("receive-pack", "receivepack"){
            {
                this.setEnabled(false);
            }

            protected void execute(DaemonClient dc, Repository db) throws IOException {
                InetAddress peer = dc.getRemoteAddress();
                String host = peer.getCanonicalHostName();
                if (host == null) {
                    host = peer.getHostAddress();
                }
                ReceivePack rp = new ReceivePack(db);
                InputStream in = dc.getInputStream();
                String name = "anonymous";
                String email = "anonymous@" + host;
                rp.setRefLogIdent(new PersonIdent("anonymous", email));
                rp.setTimeout(Daemon.this.getTimeout());
                rp.receive(in, dc.getOutputStream(), null);
            }
        }};
    }

    public synchronized InetSocketAddress getAddress() {
        return this.myAddress;
    }

    public synchronized DaemonService getService(String name) {
        if (!name.startsWith("git-")) {
            name = "git-" + name;
        }
        for (DaemonService s : this.services) {
            if (!s.getCommandName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public boolean isExportAll() {
        return this.exportAll;
    }

    public void setExportAll(boolean export) {
        this.exportAll = export;
    }

    public void exportRepository(String name, Repository db) {
        if (!name.endsWith(".git")) {
            name = name + ".git";
        }
        this.exports.put(name, db);
        RepositoryCache.register(db);
    }

    public void exportDirectory(File dir) {
        this.exportBase.add(dir);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int seconds) {
        this.timeout = seconds;
    }

    public void setPackConfig(PackConfig pc) {
        this.packConfig = pc;
    }

    public synchronized void start() throws IOException {
        if (this.acceptThread != null) {
            throw new IllegalStateException(JGitText.get().daemonAlreadyRunning);
        }
        final ServerSocket listenSock = new ServerSocket(this.myAddress != null ? this.myAddress.getPort() : 0, 5, this.myAddress != null ? this.myAddress.getAddress() : null);
        this.myAddress = (InetSocketAddress)listenSock.getLocalSocketAddress();
        this.run = true;
        this.acceptThread = new Thread(this.processors, "Git-Daemon-Accept"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (Daemon.this.isRunning()) {
                    try {
                        Daemon.this.startClient(listenSock.accept());
                    }
                    catch (InterruptedIOException e) {
                    }
                    catch (IOException e) {
                        // empty catch block
                        break;
                    }
                }
                try {
                    listenSock.close();
                }
                catch (IOException iOException) {
                    Daemon daemon = Daemon.this;
                    synchronized (daemon) {
                        Daemon.this.acceptThread = null;
                    }
                }
                finally {
                    Daemon e = Daemon.this;
                    synchronized (e) {
                        Daemon.this.acceptThread = null;
                    }
                }
            }
        };
        this.acceptThread.start();
    }

    public synchronized boolean isRunning() {
        return this.run;
    }

    public synchronized void stop() {
        if (this.acceptThread != null) {
            this.run = false;
            this.acceptThread.interrupt();
        }
    }

    private void startClient(final Socket s) {
        final DaemonClient dc = new DaemonClient(this);
        SocketAddress peer = s.getRemoteSocketAddress();
        if (peer instanceof InetSocketAddress) {
            dc.setRemoteAddress(((InetSocketAddress)peer).getAddress());
        }
        new Thread(this.processors, "Git-Daemon-Client " + peer.toString()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    dc.execute(s);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        s.getInputStream().close();
                    }
                    catch (IOException e) {}
                    try {
                        s.getOutputStream().close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }.start();
    }

    synchronized DaemonService matchService(String cmd) {
        for (DaemonService d : this.services) {
            if (!d.handles(cmd)) continue;
            return d;
        }
        return null;
    }

    Repository openRepository(String name) {
        if (!(name = name.replace('\\', '/')).startsWith("/")) {
            return null;
        }
        if (name.startsWith("//")) {
            return null;
        }
        if (name.contains("/../")) {
            return null;
        }
        Repository db = this.exports.get((name = name.substring(1)).endsWith(".git") ? name : name + ".git");
        if (db != null) {
            db.incrementOpen();
            return db;
        }
        for (File baseDir : this.exportBase) {
            File gitdir = RepositoryCache.FileKey.resolve(new File(baseDir, name), FS.DETECTED);
            if (gitdir == null || !this.canExport(gitdir)) continue;
            return Daemon.openRepository(gitdir);
        }
        return null;
    }

    private static Repository openRepository(File gitdir) {
        try {
            return RepositoryCache.open(RepositoryCache.FileKey.exact(gitdir, FS.DETECTED));
        }
        catch (IOException err) {
            return null;
        }
    }

    private boolean canExport(File d) {
        if (this.isExportAll()) {
            return true;
        }
        return new File(d, "git-daemon-export-ok").exists();
    }
}

