/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.plugins.git.GitRepository;
import com.atlassian.util.concurrent.Function;
import com.atlassian.util.concurrent.ManagedLock;
import com.atlassian.util.concurrent.ManagedLocks;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class GitCacheDirectory {
    static final String GIT_REPOSITORY_CACHE_DIRECTORY = "_git-repositories-cache";
    static final Function<File, ManagedLock> cacheLockFactory = ManagedLocks.weakManagedLockFactory();
    private static final Logger log = Logger.getLogger(GitCacheDirectory.class);

    @NotNull
    static File getCacheDirectory(@NotNull File workingDirectory, @NotNull GitRepository.GitRepositoryAccessData repositoryData) {
        String repositorySha = repositoryData.useShallowClones ? GitCacheDirectory.calculateAggregateSha(repositoryData.repositoryUrl, repositoryData.username, repositoryData.branch) : GitCacheDirectory.calculateAggregateSha(repositoryData.repositoryUrl, repositoryData.username);
        File cacheDirectory = new File(workingDirectory, GIT_REPOSITORY_CACHE_DIRECTORY);
        return new File(cacheDirectory, repositorySha);
    }

    static String calculateAggregateSha(String ... params) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (String param : params) {
            if (param != null) {
                try {
                    baos.write(param.getBytes("UTF-8"));
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot happen: Error writing string to byte array", e);
                }
            }
            baos.write(0);
        }
        return DigestUtils.shaHex((byte[])baos.toByteArray());
    }

    public static ManagedLock getCacheLock(@NotNull File cache) {
        return (ManagedLock)cacheLockFactory.get((Object)cache);
    }
}

