/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plugins.git.GitCacheDirectory;
import com.atlassian.bamboo.plugins.git.GitRepository;
import com.atlassian.bamboo.v2.build.repository.RepositoryV2;
import com.atlassian.bamboo.ww2.actions.PlanActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import com.atlassian.util.concurrent.Supplier;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class DeleteGitCacheDirectoryAction
extends PlanActionSupport
implements PlanEditSecurityAware {
    private static final Logger log = Logger.getLogger(DeleteGitCacheDirectoryAction.class);

    public String doExecute() throws Exception {
        final String buildKey = this.getBuildKey();
        Plan plan = this.planManager.getPlanByKey(buildKey);
        if (plan == null) {
            String message = this.getText("repository.git.messages.cache.cleanFailedNoPlan", Arrays.asList(buildKey));
            log.error((Object)message);
            this.addActionError(message);
            return "error";
        }
        RepositoryV2 repository = plan.getBuildDefinition().getRepositoryV2();
        if (!(repository instanceof GitRepository)) {
            String message = this.getText("repository.git.messages.cache.notGit", Arrays.asList(buildKey));
            log.error((Object)message);
            this.addActionError(message);
            return "error";
        }
        GitRepository gitRepository = (GitRepository)repository;
        final File cacheDirectoryFile = gitRepository.getCacheDirectory();
        return (String)GitCacheDirectory.getCacheLock(cacheDirectoryFile).withLock((Supplier)new Supplier<String>(){

            public String get() {
                if (cacheDirectoryFile.exists()) {
                    log.info((Object)DeleteGitCacheDirectoryAction.this.getText("repository.git.messages.cache.cleaning", Arrays.asList(buildKey, cacheDirectoryFile.getAbsolutePath())));
                    try {
                        FileUtils.forceDelete((File)cacheDirectoryFile);
                    }
                    catch (IOException e) {
                        String message = DeleteGitCacheDirectoryAction.this.getText("repository.git.messages.cache.cleanFailed", Arrays.asList(buildKey));
                        log.error((Object)message, (Throwable)e);
                        DeleteGitCacheDirectoryAction.this.addActionError(message);
                        return "error";
                    }
                } else {
                    String message = DeleteGitCacheDirectoryAction.this.getText("repository.git.messages.cache.notExist", Arrays.asList(buildKey, cacheDirectoryFile.getAbsolutePath()));
                    log.info((Object)message);
                }
                return "success";
            }
        });
    }
}

