/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.FetchProcess;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.PushProcess;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.TransferConfig;
import org.eclipse.jgit.transport.TransportAmazonS3;
import org.eclipse.jgit.transport.TransportBundleFile;
import org.eclipse.jgit.transport.TransportGitAnon;
import org.eclipse.jgit.transport.TransportGitSsh;
import org.eclipse.jgit.transport.TransportHttp;
import org.eclipse.jgit.transport.TransportLocal;
import org.eclipse.jgit.transport.TransportSftp;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Transport {
    public static final boolean DEFAULT_FETCH_THIN = true;
    public static final boolean DEFAULT_PUSH_THIN = false;
    public static final RefSpec REFSPEC_TAGS = new RefSpec("refs/tags/*:refs/tags/*");
    public static final RefSpec REFSPEC_PUSH_ALL = new RefSpec("refs/heads/*:refs/heads/*");
    protected final Repository local;
    protected final URIish uri;
    private String optionUploadPack = "git-upload-pack";
    private List<RefSpec> fetch = Collections.emptyList();
    private TagOpt tagopt = TagOpt.NO_TAGS;
    private boolean fetchThin = true;
    private String optionReceivePack = "git-receive-pack";
    private List<RefSpec> push = Collections.emptyList();
    private boolean pushThin = false;
    private boolean dryRun;
    private boolean checkFetchedObjects;
    private boolean removeDeletedRefs;
    private int timeout;
    private PackConfig packConfig;
    private CredentialsProvider credentialsProvider;

    public static Transport open(Repository local, String remote) throws NotSupportedException, URISyntaxException {
        return Transport.open(local, remote, Operation.FETCH);
    }

    public static Transport open(Repository local, String remote, Operation op) throws NotSupportedException, URISyntaxException {
        RemoteConfig cfg = new RemoteConfig(local.getConfig(), remote);
        if (Transport.doesNotExist(cfg)) {
            return Transport.open(local, new URIish(remote));
        }
        return Transport.open(local, cfg, op);
    }

    public static List<Transport> openAll(Repository local, String remote) throws NotSupportedException, URISyntaxException {
        return Transport.openAll(local, remote, Operation.FETCH);
    }

    public static List<Transport> openAll(Repository local, String remote, Operation op) throws NotSupportedException, URISyntaxException {
        RemoteConfig cfg = new RemoteConfig(local.getConfig(), remote);
        if (Transport.doesNotExist(cfg)) {
            ArrayList<Transport> transports = new ArrayList<Transport>(1);
            transports.add(Transport.open(local, new URIish(remote)));
            return transports;
        }
        return Transport.openAll(local, cfg, op);
    }

    public static Transport open(Repository local, RemoteConfig cfg) throws NotSupportedException {
        return Transport.open(local, cfg, Operation.FETCH);
    }

    public static Transport open(Repository local, RemoteConfig cfg, Operation op) throws NotSupportedException {
        List<URIish> uris = Transport.getURIs(cfg, op);
        if (uris.isEmpty()) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().remoteConfigHasNoURIAssociated, cfg.getName()));
        }
        Transport tn = Transport.open(local, uris.get(0));
        tn.applyConfig(cfg);
        return tn;
    }

    public static List<Transport> openAll(Repository local, RemoteConfig cfg) throws NotSupportedException {
        return Transport.openAll(local, cfg, Operation.FETCH);
    }

    public static List<Transport> openAll(Repository local, RemoteConfig cfg, Operation op) throws NotSupportedException {
        List<URIish> uris = Transport.getURIs(cfg, op);
        ArrayList<Transport> transports = new ArrayList<Transport>(uris.size());
        for (URIish uri : uris) {
            Transport tn = Transport.open(local, uri);
            tn.applyConfig(cfg);
            transports.add(tn);
        }
        return transports;
    }

    private static List<URIish> getURIs(RemoteConfig cfg, Operation op) {
        switch (op) {
            case FETCH: {
                return cfg.getURIs();
            }
            case PUSH: {
                List<URIish> uris = cfg.getPushURIs();
                if (uris.isEmpty()) {
                    uris = cfg.getURIs();
                }
                return uris;
            }
        }
        throw new IllegalArgumentException(op.toString());
    }

    private static boolean doesNotExist(RemoteConfig cfg) {
        return cfg.getURIs().isEmpty() && cfg.getPushURIs().isEmpty();
    }

    public static boolean canHandleProtocol(URIish remote, FS fs) {
        if (TransportGitSsh.canHandle(remote)) {
            return true;
        }
        if (TransportHttp.canHandle(remote)) {
            return true;
        }
        if (TransportSftp.canHandle(remote)) {
            return true;
        }
        if (TransportGitAnon.canHandle(remote)) {
            return true;
        }
        if (TransportAmazonS3.canHandle(remote)) {
            return true;
        }
        if (TransportBundleFile.canHandle(remote, fs)) {
            return true;
        }
        return TransportLocal.canHandle(remote, fs);
    }

    public static Transport open(Repository local, URIish remote) throws NotSupportedException {
        if (TransportGitSsh.canHandle(remote)) {
            return new TransportGitSsh(local, remote);
        }
        if (TransportHttp.canHandle(remote)) {
            return new TransportHttp(local, remote);
        }
        if (TransportSftp.canHandle(remote)) {
            return new TransportSftp(local, remote);
        }
        if (TransportGitAnon.canHandle(remote)) {
            return new TransportGitAnon(local, remote);
        }
        if (TransportAmazonS3.canHandle(remote)) {
            return new TransportAmazonS3(local, remote);
        }
        if (TransportBundleFile.canHandle(remote, local.getFS())) {
            return new TransportBundleFile(local, remote);
        }
        if (TransportLocal.canHandle(remote, local.getFS())) {
            return new TransportLocal(local, remote);
        }
        throw new NotSupportedException(MessageFormat.format(JGitText.get().URINotSupported, remote));
    }

    public static Collection<RemoteRefUpdate> findRemoteRefUpdatesFor(Repository db, Collection<RefSpec> specs, Collection<RefSpec> fetchSpecs) throws IOException {
        if (fetchSpecs == null) {
            fetchSpecs = Collections.emptyList();
        }
        LinkedList<RemoteRefUpdate> result = new LinkedList<RemoteRefUpdate>();
        Collection<RefSpec> procRefs = Transport.expandPushWildcardsFor(db, specs);
        for (RefSpec spec : procRefs) {
            String destSpec;
            String srcSpec = spec.getSource();
            Ref srcRef = db.getRef(srcSpec);
            if (srcRef != null) {
                srcSpec = srcRef.getName();
            }
            if ((destSpec = spec.getDestination()) == null) {
                destSpec = srcSpec;
            }
            if (srcRef != null && !destSpec.startsWith("refs/")) {
                String n = srcRef.getName();
                int kindEnd = n.indexOf(47, "refs/".length());
                destSpec = n.substring(0, kindEnd + 1) + destSpec;
            }
            boolean forceUpdate = spec.isForceUpdate();
            String localName = Transport.findTrackingRefName(destSpec, fetchSpecs);
            RemoteRefUpdate rru = new RemoteRefUpdate(db, srcSpec, destSpec, forceUpdate, localName, null);
            result.add(rru);
        }
        return result;
    }

    private static Collection<RefSpec> expandPushWildcardsFor(Repository db, Collection<RefSpec> specs) {
        Map<String, Ref> localRefs = db.getAllRefs();
        HashSet<RefSpec> procRefs = new HashSet<RefSpec>();
        for (RefSpec spec : specs) {
            if (spec.isWildcard()) {
                for (Ref localRef : localRefs.values()) {
                    if (!spec.matchSource(localRef)) continue;
                    procRefs.add(spec.expandFromSource(localRef));
                }
                continue;
            }
            procRefs.add(spec);
        }
        return procRefs;
    }

    private static String findTrackingRefName(String remoteName, Collection<RefSpec> fetchSpecs) {
        for (RefSpec fetchSpec : fetchSpecs) {
            if (!fetchSpec.matchSource(remoteName)) continue;
            if (fetchSpec.isWildcard()) {
                return fetchSpec.expandFromSource(remoteName).getDestination();
            }
            return fetchSpec.getDestination();
        }
        return null;
    }

    protected Transport(Repository local, URIish uri) {
        TransferConfig tc = local.getConfig().get(TransferConfig.KEY);
        this.local = local;
        this.uri = uri;
        this.checkFetchedObjects = tc.isFsckObjects();
        this.credentialsProvider = CredentialsProvider.getDefault();
    }

    public URIish getURI() {
        return this.uri;
    }

    public String getOptionUploadPack() {
        return this.optionUploadPack;
    }

    public void setOptionUploadPack(String where) {
        this.optionUploadPack = where != null && where.length() > 0 ? where : "git-upload-pack";
    }

    public TagOpt getTagOpt() {
        return this.tagopt;
    }

    public void setTagOpt(TagOpt option) {
        this.tagopt = option != null ? option : TagOpt.AUTO_FOLLOW;
    }

    public boolean isFetchThin() {
        return this.fetchThin;
    }

    public void setFetchThin(boolean fetchThin) {
        this.fetchThin = fetchThin;
    }

    public boolean isCheckFetchedObjects() {
        return this.checkFetchedObjects;
    }

    public void setCheckFetchedObjects(boolean check) {
        this.checkFetchedObjects = check;
    }

    public String getOptionReceivePack() {
        return this.optionReceivePack;
    }

    public void setOptionReceivePack(String optionReceivePack) {
        this.optionReceivePack = optionReceivePack != null && optionReceivePack.length() > 0 ? optionReceivePack : "git-receive-pack";
    }

    public boolean isPushThin() {
        return this.pushThin;
    }

    public void setPushThin(boolean pushThin) {
        this.pushThin = pushThin;
    }

    public boolean isRemoveDeletedRefs() {
        return this.removeDeletedRefs;
    }

    public void setRemoveDeletedRefs(boolean remove) {
        this.removeDeletedRefs = remove;
    }

    public void applyConfig(RemoteConfig cfg) {
        this.setOptionUploadPack(cfg.getUploadPack());
        this.setOptionReceivePack(cfg.getReceivePack());
        this.setTagOpt(cfg.getTagOpt());
        this.fetch = cfg.getFetchRefSpecs();
        this.push = cfg.getPushRefSpecs();
        this.timeout = cfg.getTimeout();
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int seconds) {
        this.timeout = seconds;
    }

    public PackConfig getPackConfig() {
        if (this.packConfig == null) {
            this.packConfig = new PackConfig(this.local);
        }
        return this.packConfig;
    }

    public void setPackConfig(PackConfig pc) {
        this.packConfig = pc;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public FetchResult fetch(ProgressMonitor monitor, Collection<RefSpec> toFetch) throws NotSupportedException, TransportException {
        return this.fetch(monitor, toFetch, 0);
    }

    public FetchResult fetch(ProgressMonitor monitor, Collection<RefSpec> toFetch, int depth) throws NotSupportedException, TransportException {
        if (toFetch == null || toFetch.isEmpty()) {
            if (this.fetch.isEmpty()) {
                throw new TransportException(JGitText.get().nothingToFetch);
            }
            toFetch = this.fetch;
        } else if (!this.fetch.isEmpty()) {
            ArrayList<RefSpec> tmp = new ArrayList<RefSpec>(toFetch);
            block0: for (RefSpec requested : toFetch) {
                String reqSrc = requested.getSource();
                for (RefSpec configured : this.fetch) {
                    String cfgSrc = configured.getSource();
                    String cfgDst = configured.getDestination();
                    if (!cfgSrc.equals(reqSrc) || cfgDst == null) continue;
                    tmp.add(configured);
                    continue block0;
                }
            }
            toFetch = tmp;
        }
        FetchResult result = new FetchResult();
        new FetchProcess(this, toFetch, depth).execute(monitor, result);
        return result;
    }

    public PushResult push(ProgressMonitor monitor, Collection<RemoteRefUpdate> toPush) throws NotSupportedException, TransportException {
        if (toPush == null || toPush.isEmpty()) {
            try {
                toPush = this.findRemoteRefUpdatesFor(this.push);
            }
            catch (IOException e) {
                throw new TransportException(MessageFormat.format(JGitText.get().problemWithResolvingPushRefSpecsLocally, e.getMessage()), e);
            }
            if (toPush.isEmpty()) {
                throw new TransportException(JGitText.get().nothingToPush);
            }
        }
        PushProcess pushProcess = new PushProcess(this, toPush);
        return pushProcess.execute(monitor);
    }

    public Collection<RemoteRefUpdate> findRemoteRefUpdatesFor(Collection<RefSpec> specs) throws IOException {
        return Transport.findRemoteRefUpdatesFor(this.local, specs, this.fetch);
    }

    public abstract FetchConnection openFetch() throws NotSupportedException, TransportException;

    public abstract PushConnection openPush() throws NotSupportedException, TransportException;

    public abstract void close();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        FETCH,
        PUSH;

    }
}

