/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.pack;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StoredObjectRepresentationNotAvailableException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.AsyncObjectSizeQueue;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSubclassMap;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.ThreadSafeProgressMonitor;
import org.eclipse.jgit.revwalk.AsyncRevObjectQueue;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.storage.file.PackIndexWriter;
import org.eclipse.jgit.storage.pack.BaseSearch;
import org.eclipse.jgit.storage.pack.CachedPack;
import org.eclipse.jgit.storage.pack.DeltaCache;
import org.eclipse.jgit.storage.pack.DeltaIndex;
import org.eclipse.jgit.storage.pack.DeltaTask;
import org.eclipse.jgit.storage.pack.DeltaWindow;
import org.eclipse.jgit.storage.pack.ObjectReuseAsIs;
import org.eclipse.jgit.storage.pack.ObjectToPack;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.storage.pack.PackOutputStream;
import org.eclipse.jgit.storage.pack.StoredObjectRepresentation;
import org.eclipse.jgit.storage.pack.ThreadSafeDeltaCache;
import org.eclipse.jgit.util.TemporaryBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackWriter {
    private static final int PACK_VERSION_GENERATED = 2;
    private final List<ObjectToPack>[] objectsLists = new List[5];
    private final ObjectIdSubclassMap<ObjectToPack> objectsMap;
    private List<ObjectToPack> edgeObjects;
    private List<CachedPack> cachedPacks;
    private Deflater myDeflater;
    private final ObjectReader reader;
    private final ObjectReuseAsIs reuseSupport;
    private final PackConfig config;
    private final Statistics stats;
    private List<ObjectToPack> sortedByName;
    private byte[] packcsum;
    private boolean deltaBaseAsOffset;
    private boolean reuseDeltas;
    private boolean thin;
    private boolean useCachedPacks;
    private boolean ignoreMissingUninteresting;

    public PackWriter(Repository repo) {
        this(repo, repo.newObjectReader());
    }

    public PackWriter(ObjectReader reader) {
        this(new PackConfig(), reader);
    }

    public PackWriter(Repository repo, ObjectReader reader) {
        this(new PackConfig(repo), reader);
    }

    public PackWriter(PackConfig config, ObjectReader reader) {
        this.objectsLists[0] = Collections.emptyList();
        this.objectsLists[1] = new ArrayList<ObjectToPack>();
        this.objectsLists[2] = new ArrayList<ObjectToPack>();
        this.objectsLists[3] = new ArrayList<ObjectToPack>();
        this.objectsLists[4] = new ArrayList<ObjectToPack>();
        this.objectsMap = new ObjectIdSubclassMap();
        this.edgeObjects = new ArrayList<ObjectToPack>();
        this.cachedPacks = new ArrayList<CachedPack>(2);
        this.ignoreMissingUninteresting = true;
        this.config = config;
        this.reader = reader;
        this.reuseSupport = reader instanceof ObjectReuseAsIs ? (ObjectReuseAsIs)((Object)reader) : null;
        this.deltaBaseAsOffset = config.isDeltaBaseAsOffset();
        this.reuseDeltas = config.isReuseDeltas();
        this.stats = new Statistics();
    }

    public boolean isDeltaBaseAsOffset() {
        return this.deltaBaseAsOffset;
    }

    public void setDeltaBaseAsOffset(boolean deltaBaseAsOffset) {
        this.deltaBaseAsOffset = deltaBaseAsOffset;
    }

    public boolean isThin() {
        return this.thin;
    }

    public void setThin(boolean packthin) {
        this.thin = packthin;
    }

    public boolean isUseCachedPacks() {
        return this.useCachedPacks;
    }

    public void setUseCachedPacks(boolean useCached) {
        this.useCachedPacks = useCached;
    }

    public boolean isIgnoreMissingUninteresting() {
        return this.ignoreMissingUninteresting;
    }

    public void setIgnoreMissingUninteresting(boolean ignore) {
        this.ignoreMissingUninteresting = ignore;
    }

    public long getObjectsNumber() {
        return this.stats.totalObjects;
    }

    public void preparePack(Iterator<RevObject> objectsSource) throws IOException {
        while (objectsSource.hasNext()) {
            this.addObject(objectsSource.next());
        }
    }

    public void preparePack(ProgressMonitor countingMonitor, Collection<? extends ObjectId> interestingObjects, Collection<? extends ObjectId> uninterestingObjects) throws IOException {
        if (countingMonitor == null) {
            countingMonitor = NullProgressMonitor.INSTANCE;
        }
        this.findObjectsToPack(countingMonitor, interestingObjects, uninterestingObjects);
    }

    public boolean willInclude(AnyObjectId id) throws IOException {
        ObjectToPack obj = this.objectsMap.get(id);
        if (obj != null && !obj.isEdge()) {
            return true;
        }
        Set<ObjectId> toFind = Collections.singleton(id.toObjectId());
        for (CachedPack pack : this.cachedPacks) {
            if (!pack.hasObject(toFind).contains(id)) continue;
            return true;
        }
        return false;
    }

    public ObjectToPack get(AnyObjectId id) {
        ObjectToPack obj = this.objectsMap.get(id);
        return obj != null && !obj.isEdge() ? obj : null;
    }

    public ObjectId computeName() {
        byte[] buf = new byte[20];
        MessageDigest md = Constants.newMessageDigest();
        for (ObjectToPack otp : this.sortByName()) {
            otp.copyRawTo(buf, 0);
            md.update(buf, 0, 20);
        }
        return ObjectId.fromRaw(md.digest());
    }

    public void writeIndex(OutputStream indexStream) throws IOException {
        if (!this.cachedPacks.isEmpty()) {
            throw new IOException(JGitText.get().cachedPacksPreventsIndexCreation);
        }
        List<ObjectToPack> list = this.sortByName();
        int indexVersion = this.config.getIndexVersion();
        PackIndexWriter iw = indexVersion <= 0 ? PackIndexWriter.createOldestPossible(indexStream, list) : PackIndexWriter.createVersion(indexStream, indexVersion);
        iw.write(list, this.packcsum);
    }

    private List<ObjectToPack> sortByName() {
        if (this.sortedByName == null) {
            int cnt = 0;
            for (List<ObjectToPack> list : this.objectsLists) {
                cnt += list.size();
            }
            this.sortedByName = new ArrayList<ObjectToPack>(cnt);
            for (List<ObjectToPack> list : this.objectsLists) {
                for (ObjectToPack otp : list) {
                    this.sortedByName.add(otp);
                }
            }
            Collections.sort(this.sortedByName);
        }
        return this.sortedByName;
    }

    public void writePack(ProgressMonitor compressMonitor, ProgressMonitor writeMonitor, OutputStream packStream) throws IOException {
        if (compressMonitor == null) {
            compressMonitor = NullProgressMonitor.INSTANCE;
        }
        if (writeMonitor == null) {
            writeMonitor = NullProgressMonitor.INSTANCE;
        }
        if ((this.reuseDeltas || this.config.isReuseObjects()) && this.reuseSupport != null) {
            this.searchForReuse(compressMonitor);
        }
        if (this.config.isDeltaCompress()) {
            this.searchForDeltas(compressMonitor);
        }
        PackOutputStream out = new PackOutputStream(writeMonitor, packStream, this);
        long objCnt = 0L;
        for (List<ObjectToPack> list : this.objectsLists) {
            objCnt += (long)list.size();
        }
        for (CachedPack pack : this.cachedPacks) {
            objCnt += pack.getObjectCount();
        }
        this.stats.totalObjects = objCnt;
        writeMonitor.beginTask(JGitText.get().writingObjects, (int)objCnt);
        out.writeFileHeader(2, objCnt);
        out.flush();
        this.writeObjects(out);
        for (CachedPack pack : this.cachedPacks) {
            this.stats.reusedObjects += pack.getObjectCount();
            this.reuseSupport.copyPackAsIs(out, pack);
        }
        this.writeChecksum(out);
        this.reader.release();
        writeMonitor.endTask();
    }

    public Statistics getStatistics() {
        return this.stats;
    }

    public void release() {
        this.reader.release();
        if (this.myDeflater != null) {
            this.myDeflater.end();
            this.myDeflater = null;
        }
    }

    private void searchForReuse(ProgressMonitor monitor) throws IOException {
        int cnt = 0;
        for (List<ObjectToPack> list : this.objectsLists) {
            cnt += list.size();
        }
        monitor.beginTask(JGitText.get().searchForReuse, cnt);
        for (List<ObjectToPack> list : this.objectsLists) {
            this.reuseSupport.selectObjectRepresentation(this, monitor, list);
        }
        monitor.endTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchForDeltas(ProgressMonitor monitor) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectToPack[] list = new ObjectToPack[this.objectsLists[2].size() + this.objectsLists[3].size() + this.edgeObjects.size()];
        int cnt = 0;
        cnt = this.findObjectsNeedingDelta(list, cnt, 2);
        if ((cnt = this.findObjectsNeedingDelta(list, cnt, 3)) == 0) {
            return;
        }
        int nonEdgeCnt = cnt;
        for (ObjectToPack eo : this.edgeObjects) {
            eo.setWeight(0);
            list[cnt++] = eo;
        }
        monitor.beginTask(JGitText.get().searchForSizes, cnt);
        AsyncObjectSizeQueue<ObjectToPack> sizeQueue = this.reader.getObjectSize(Arrays.asList(list).subList(0, cnt), false);
        try {
            long limit = this.config.getBigFileThreshold();
            while (true) {
                long sz;
                block17: {
                    monitor.update(1);
                    try {
                        if (sizeQueue.next()) break block17;
                        break;
                    }
                    catch (MissingObjectException notFound) {
                        if (this.ignoreMissingUninteresting) {
                            ObjectToPack otp = sizeQueue.getCurrent();
                            if (otp != null && otp.isEdge()) {
                                otp.setDoNotDelta(true);
                                continue;
                            }
                            otp = this.objectsMap.get(notFound.getObjectId());
                            if (otp != null && otp.isEdge()) {
                                otp.setDoNotDelta(true);
                                continue;
                            }
                        }
                        throw notFound;
                    }
                }
                ObjectToPack otp = sizeQueue.getCurrent();
                if (otp == null) {
                    otp = this.objectsMap.get(sizeQueue.getObjectId());
                }
                if (limit <= (sz = sizeQueue.getSize()) || Integer.MAX_VALUE <= sz) {
                    otp.setDoNotDelta(true);
                    continue;
                }
                if (sz <= 16L) {
                    otp.setDoNotDelta(true);
                    continue;
                }
                otp.setWeight((int)sz);
            }
        }
        finally {
            sizeQueue.release();
        }
        monitor.endTask();
        Arrays.sort(list, 0, cnt, new Comparator<ObjectToPack>(){

            @Override
            public int compare(ObjectToPack a, ObjectToPack b) {
                int cmp = (a.isDoNotDelta() ? 1 : 0) - (b.isDoNotDelta() ? 1 : 0);
                if (cmp != 0) {
                    return cmp;
                }
                cmp = a.getType() - b.getType();
                if (cmp != 0) {
                    return cmp;
                }
                cmp = (a.getPathHash() >>> 1) - (b.getPathHash() >>> 1);
                if (cmp != 0) {
                    return cmp;
                }
                cmp = (a.getPathHash() & 1) - (b.getPathHash() & 1);
                if (cmp != 0) {
                    return cmp;
                }
                cmp = (a.isEdge() ? 0 : 1) - (b.isEdge() ? 0 : 1);
                if (cmp != 0) {
                    return cmp;
                }
                return b.getWeight() - a.getWeight();
            }
        });
        while (0 < cnt && list[cnt - 1].isDoNotDelta()) {
            if (!list[cnt - 1].isEdge()) {
                --nonEdgeCnt;
            }
            --cnt;
        }
        if (cnt == 0) {
            return;
        }
        monitor.beginTask(JGitText.get().compressingObjects, nonEdgeCnt);
        this.searchForDeltas(monitor, list, cnt);
        monitor.endTask();
    }

    private int findObjectsNeedingDelta(ObjectToPack[] list, int cnt, int type) {
        for (ObjectToPack otp : this.objectsLists[type]) {
            if (otp.isDoNotDelta() || otp.isDeltaRepresentation()) continue;
            otp.setWeight(0);
            list[cnt++] = otp;
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchForDeltas(ProgressMonitor monitor, ObjectToPack[] list, int cnt) throws MissingObjectException, IncorrectObjectTypeException, LargeObjectException, IOException {
        List<Throwable> errors;
        block25: {
            int batchSize;
            int threads = this.config.getThreads();
            if (threads == 0) {
                threads = Runtime.getRuntime().availableProcessors();
            }
            if (threads <= 1 || cnt <= 2 * this.config.getDeltaSearchWindowSize()) {
                DeltaCache dc = new DeltaCache(this.config);
                DeltaWindow dw = new DeltaWindow(this.config, dc, this.reader);
                dw.search(monitor, list, 0, cnt);
                return;
            }
            ThreadSafeDeltaCache dc = new ThreadSafeDeltaCache(this.config);
            ThreadSafeProgressMonitor pm = new ThreadSafeProgressMonitor(monitor);
            int estSize = cnt / (threads * 2);
            if (estSize < 2 * this.config.getDeltaSearchWindowSize()) {
                estSize = 2 * this.config.getDeltaSearchWindowSize();
            }
            ArrayList<DeltaTask> myTasks = new ArrayList<DeltaTask>(threads * 2);
            for (int i = 0; i < cnt; i += batchSize) {
                int start = i;
                if (cnt - i < estSize) {
                    batchSize = cnt - i;
                } else {
                    int end;
                    for (end = start + estSize; end < cnt; ++end) {
                        ObjectToPack a = list[end - 1];
                        ObjectToPack b = list[end];
                        if (a.getPathHash() != b.getPathHash()) break;
                    }
                    batchSize = end - start;
                }
                myTasks.add(new DeltaTask(this.config, this.reader, dc, pm, batchSize, start, list));
            }
            pm.startWorkers(myTasks.size());
            Executor executor = this.config.getExecutor();
            errors = Collections.synchronizedList(new ArrayList());
            if (executor instanceof ExecutorService) {
                this.runTasks((ExecutorService)executor, pm, myTasks, errors);
            } else {
                if (executor == null) {
                    ExecutorService pool = Executors.newFixedThreadPool(threads);
                    try {
                        this.runTasks(pool, pm, myTasks, errors);
                    }
                    finally {
                        pool.shutdown();
                        try {
                            while (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                            }
                            break block25;
                        }
                        catch (InterruptedException e) {
                            throw new IOException(JGitText.get().packingCancelledDuringObjectsWriting);
                        }
                    }
                }
                for (final DeltaTask task : myTasks) {
                    executor.execute(new Runnable(){

                        public void run() {
                            try {
                                task.call();
                            }
                            catch (Throwable failure) {
                                errors.add(failure);
                            }
                        }
                    });
                }
                try {
                    pm.waitForCompletion();
                }
                catch (InterruptedException ie) {
                    throw new IOException(JGitText.get().packingCancelledDuringObjectsWriting);
                }
            }
        }
        if (!errors.isEmpty()) {
            Throwable err = errors.get(0);
            if (err instanceof Error) {
                throw (Error)err;
            }
            if (err instanceof RuntimeException) {
                throw (RuntimeException)err;
            }
            if (err instanceof IOException) {
                throw (IOException)err;
            }
            IOException fail = new IOException(err.getMessage());
            fail.initCause(err);
            throw fail;
        }
    }

    private void runTasks(ExecutorService pool, ThreadSafeProgressMonitor pm, List<DeltaTask> tasks, List<Throwable> errors) throws IOException {
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>(tasks.size());
        for (DeltaTask deltaTask : tasks) {
            futures.add(pool.submit(deltaTask));
        }
        try {
            pm.waitForCompletion();
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (ExecutionException executionException) {
                    errors.add(executionException.getCause());
                }
            }
        }
        catch (InterruptedException ie) {
            for (Future future : futures) {
                future.cancel(true);
            }
            throw new IOException(JGitText.get().packingCancelledDuringObjectsWriting);
        }
    }

    private void writeObjects(PackOutputStream out) throws IOException {
        if (this.reuseSupport != null) {
            for (List<ObjectToPack> list : this.objectsLists) {
                this.reuseSupport.writeObjects(out, list);
            }
        } else {
            for (List<ObjectToPack> list : this.objectsLists) {
                for (ObjectToPack otp : list) {
                    out.writeObject(otp);
                }
            }
        }
    }

    void writeObject(PackOutputStream out, ObjectToPack otp) throws IOException {
        if (otp.isWritten()) {
            return;
        }
        otp.markWantWrite();
        if (otp.isDeltaRepresentation()) {
            this.writeBaseFirst(out, otp);
        }
        out.resetCRC32();
        otp.setOffset(out.length());
        while (otp.isReuseAsIs()) {
            try {
                this.reuseSupport.copyObjectAsIs(out, otp);
                out.endObject();
                otp.setCRC(out.getCRC32());
                ++this.stats.reusedObjects;
                if (otp.isDeltaRepresentation()) {
                    ++this.stats.reusedDeltas;
                }
                return;
            }
            catch (StoredObjectRepresentationNotAvailableException gone) {
                if (otp.getOffset() == out.length()) {
                    this.redoSearchForReuse(otp);
                    continue;
                }
                CorruptObjectException coe = new CorruptObjectException(otp, "");
                coe.initCause(gone);
                throw coe;
            }
        }
        if (otp.isDeltaRepresentation()) {
            this.writeDeltaObjectDeflate(out, otp);
        } else {
            this.writeWholeObjectDeflate(out, otp);
        }
        out.endObject();
        otp.setCRC(out.getCRC32());
    }

    private void writeBaseFirst(PackOutputStream out, ObjectToPack otp) throws IOException {
        ObjectToPack baseInPack = otp.getDeltaBase();
        if (baseInPack != null) {
            if (!baseInPack.isWritten()) {
                if (baseInPack.wantWrite()) {
                    this.reuseDeltas = false;
                    this.redoSearchForReuse(otp);
                    this.reuseDeltas = true;
                } else {
                    this.writeObject(out, baseInPack);
                }
            }
        } else if (!this.thin) {
            otp.clearDeltaBase();
            otp.clearReuseAsIs();
        }
    }

    private void redoSearchForReuse(ObjectToPack otp) throws IOException, MissingObjectException {
        otp.clearDeltaBase();
        otp.clearReuseAsIs();
        this.reuseSupport.selectObjectRepresentation(this, NullProgressMonitor.INSTANCE, Collections.singleton(otp));
    }

    private void writeWholeObjectDeflate(PackOutputStream out, ObjectToPack otp) throws IOException {
        Deflater deflater = this.deflater();
        ObjectLoader ldr = this.reader.open(otp, otp.getType());
        out.writeHeader(otp, ldr.getSize());
        deflater.reset();
        DeflaterOutputStream dst = new DeflaterOutputStream((OutputStream)out, deflater);
        ldr.copyTo(dst);
        dst.finish();
    }

    private void writeDeltaObjectDeflate(PackOutputStream out, ObjectToPack otp) throws IOException {
        byte[] zbuf;
        DeltaCache.Ref ref = otp.popCachedDelta();
        if (ref != null && (zbuf = (byte[])ref.get()) != null) {
            out.writeHeader(otp, otp.getCachedSize());
            out.write(zbuf);
            return;
        }
        TemporaryBuffer.Heap delta = this.delta(otp);
        out.writeHeader(otp, delta.length());
        Deflater deflater = this.deflater();
        deflater.reset();
        DeflaterOutputStream dst = new DeflaterOutputStream((OutputStream)out, deflater);
        delta.writeTo(dst, null);
        dst.finish();
        ++this.stats.totalDeltas;
    }

    private TemporaryBuffer.Heap delta(ObjectToPack otp) throws IOException {
        DeltaIndex index = new DeltaIndex(this.buffer(otp.getDeltaBaseId()));
        byte[] res = this.buffer(otp);
        TemporaryBuffer.Heap delta = new TemporaryBuffer.Heap(res.length);
        index.encode(delta, res);
        return delta;
    }

    private byte[] buffer(AnyObjectId objId) throws IOException {
        return PackWriter.buffer(this.config, this.reader, objId);
    }

    static byte[] buffer(PackConfig config, ObjectReader or, AnyObjectId objId) throws IOException {
        return or.open(objId).getCachedBytes(config.getBigFileThreshold());
    }

    private Deflater deflater() {
        if (this.myDeflater == null) {
            this.myDeflater = new Deflater(this.config.getCompressionLevel());
        }
        return this.myDeflater;
    }

    private void writeChecksum(PackOutputStream out) throws IOException {
        this.packcsum = out.getDigest();
        out.write(this.packcsum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findObjectsToPack(ProgressMonitor countingMonitor, Collection<? extends ObjectId> want, Collection<? extends ObjectId> have) throws MissingObjectException, IOException, IncorrectObjectTypeException {
        RevObject o;
        ArrayList<RevObject> haveObjs;
        ArrayList<RevObject> wantObjs;
        RevFlagSet keepOnRestart;
        RevFlag include;
        RevFlag inCachedPack;
        ObjectWalk walker;
        HashMap<ObjectId, CachedPack> tipToPack;
        block30: {
            countingMonitor.beginTask(JGitText.get().countingObjects, 0);
            if (have == null) {
                have = Collections.emptySet();
            }
            ArrayList<ObjectId> all = new ArrayList<ObjectId>(want.size() + have.size());
            all.addAll(want);
            all.addAll(have);
            tipToPack = new HashMap<ObjectId, CachedPack>();
            walker = new ObjectWalk(this.reader);
            inCachedPack = walker.newFlag("inCachedPack");
            include = walker.newFlag("include");
            keepOnRestart = new RevFlagSet();
            keepOnRestart.add(inCachedPack);
            walker.setRetainBody(false);
            walker.carry(include);
            int haveEst = have.size();
            if (have.isEmpty()) {
                walker.sort(RevSort.COMMIT_TIME_DESC);
                if (this.useCachedPacks && this.reuseSupport != null) {
                    for (CachedPack pack : this.reuseSupport.getCachedPacks()) {
                        for (ObjectId id : pack.getTips()) {
                            tipToPack.put(id, pack);
                            all.add(id);
                        }
                    }
                    haveEst += tipToPack.size();
                }
            } else {
                walker.sort(RevSort.TOPO);
                if (this.thin) {
                    walker.sort(RevSort.BOUNDARY, true);
                }
            }
            wantObjs = new ArrayList<RevObject>(want.size());
            haveObjs = new ArrayList<RevObject>(haveEst);
            AsyncRevObjectQueue q = walker.parseAny(all, true);
            try {
                while (true) {
                    try {
                        while (true) {
                            RevObject o2;
                            if ((o2 = q.next()) == null) {
                                break block30;
                            }
                            if (tipToPack.containsKey(o2)) {
                                o2.add(inCachedPack);
                            }
                            if (have.contains(o2)) {
                                haveObjs.add(o2);
                                walker.markUninteresting(o2);
                                continue;
                            }
                            if (!want.contains(o2)) continue;
                            o2.add(include);
                            wantObjs.add(o2);
                            walker.markStart(o2);
                        }
                    }
                    catch (MissingObjectException e) {
                        if (this.ignoreMissingUninteresting && have.contains(e.getObjectId())) continue;
                        throw e;
                    }
                    break;
                }
            }
            finally {
                q.release();
            }
        }
        int typesToPrune = 0;
        int maxBases = this.config.getDeltaSearchWindowSize();
        HashSet<RevTree> baseTrees = new HashSet<RevTree>();
        while ((o = walker.next()) != null) {
            CachedPack pack;
            if (o.has(inCachedPack) && PackWriter.includesAllTips(pack = (CachedPack)tipToPack.get(o), include, walker)) {
                this.useCachedPack(walker, keepOnRestart, wantObjs, haveObjs, pack);
                countingMonitor.endTask();
                countingMonitor.beginTask(JGitText.get().countingObjects, 0);
                continue;
            }
            if (o.has(RevFlag.UNINTERESTING)) {
                if (baseTrees.size() > maxBases) continue;
                baseTrees.add(((RevCommit)o).getTree());
                continue;
            }
            this.addObject(o, 0);
            countingMonitor.update(1);
        }
        for (CachedPack p : this.cachedPacks) {
            for (ObjectId d : p.hasObject(this.objectsLists[1])) {
                if (baseTrees.size() <= maxBases) {
                    baseTrees.add(walker.lookupCommit(d).getTree());
                }
                this.objectsMap.get(d).setEdge();
                typesToPrune |= 2;
            }
        }
        BaseSearch bases = new BaseSearch(countingMonitor, baseTrees, this.objectsMap, this.edgeObjects, this.reader);
        while ((o = walker.nextObject()) != null) {
            if (o.has(RevFlag.UNINTERESTING)) continue;
            int pathHash = walker.getPathHashCode();
            byte[] pathBuf = walker.getPathBuffer();
            int pathLen = walker.getPathLength();
            bases.addBase(o.getType(), pathBuf, pathLen, pathHash);
            this.addObject(o, pathHash);
            countingMonitor.update(1);
        }
        for (CachedPack p : this.cachedPacks) {
            for (ObjectId d : p.hasObject(this.objectsLists[2])) {
                this.objectsMap.get(d).setEdge();
                typesToPrune |= 4;
            }
            for (ObjectId d : p.hasObject(this.objectsLists[3])) {
                this.objectsMap.get(d).setEdge();
                typesToPrune |= 8;
            }
            for (ObjectId d : p.hasObject(this.objectsLists[4])) {
                this.objectsMap.get(d).setEdge();
                typesToPrune |= 0x10;
            }
        }
        if (typesToPrune != 0) {
            this.pruneObjectList(typesToPrune, 1);
            this.pruneObjectList(typesToPrune, 2);
            this.pruneObjectList(typesToPrune, 3);
            this.pruneObjectList(typesToPrune, 4);
        }
        for (CachedPack pack : this.cachedPacks) {
            countingMonitor.update((int)pack.getObjectCount());
        }
        countingMonitor.endTask();
    }

    private void pruneObjectList(int typesToPrune, int typeCode) {
        if ((typesToPrune & 1 << typeCode) == 0) {
            return;
        }
        List<ObjectToPack> list = this.objectsLists[typeCode];
        int size = list.size();
        int dst = 0;
        for (int src = 0; src < size; ++src) {
            ObjectToPack obj = list.get(src);
            if (obj.isEdge()) continue;
            if (dst != src) {
                list.set(dst, obj);
            }
            ++dst;
        }
        while (dst < list.size()) {
            list.remove(dst);
        }
    }

    private void useCachedPack(ObjectWalk walker, RevFlagSet keepOnRestart, List<RevObject> wantObj, List<RevObject> baseObj, CachedPack pack) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        this.cachedPacks.add(pack);
        for (ObjectId objectId : pack.getTips()) {
            baseObj.add(walker.lookupOrNull(objectId));
        }
        this.objectsMap.clear();
        this.objectsLists[1] = new ArrayList<ObjectToPack>();
        this.setThin(true);
        walker.resetRetain(keepOnRestart);
        walker.sort(RevSort.TOPO);
        walker.sort(RevSort.BOUNDARY, true);
        for (RevObject revObject : wantObj) {
            walker.markStart(revObject);
        }
        for (RevObject revObject : baseObj) {
            walker.markUninteresting(revObject);
        }
    }

    private static boolean includesAllTips(CachedPack pack, RevFlag include, ObjectWalk walker) {
        for (ObjectId id : pack.getTips()) {
            if (walker.lookupOrNull(id).has(include)) continue;
            return false;
        }
        return true;
    }

    public void addObject(RevObject object) throws IncorrectObjectTypeException {
        this.addObject(object, 0);
    }

    private void addObject(RevObject object, int pathHashCode) throws IncorrectObjectTypeException {
        ObjectToPack otp = this.reuseSupport != null ? this.reuseSupport.newObjectToPack(object) : new ObjectToPack(object);
        otp.setPathHash(pathHashCode);
        try {
            this.objectsLists[object.getType()].add(otp);
        }
        catch (ArrayIndexOutOfBoundsException x) {
            throw new IncorrectObjectTypeException((ObjectId)object, JGitText.get().incorrectObjectType_COMMITnorTREEnorBLOBnorTAG);
        }
        catch (UnsupportedOperationException x) {
            throw new IncorrectObjectTypeException((ObjectId)object, JGitText.get().incorrectObjectType_COMMITnorTREEnorBLOBnorTAG);
        }
        this.objectsMap.add(otp);
    }

    public void select(ObjectToPack otp, StoredObjectRepresentation next) {
        int nWeight;
        int nFmt = next.getFormat();
        if (otp.isReuseAsIs()) {
            if (1 < nFmt) {
                return;
            }
            if (0 < nFmt && otp.isDeltaRepresentation()) {
                return;
            }
            nWeight = next.getWeight();
            if (otp.getWeight() <= nWeight) {
                return;
            }
        } else {
            nWeight = next.getWeight();
        }
        if (nFmt == 0 && this.reuseDeltas) {
            ObjectId baseId = next.getDeltaBase();
            ObjectToPack ptr = this.objectsMap.get(baseId);
            if (ptr != null && !ptr.isEdge()) {
                otp.setDeltaBase(ptr);
                otp.setReuseAsIs();
                otp.setWeight(nWeight);
            } else if (this.thin && ptr != null && ptr.isEdge()) {
                otp.setDeltaBase(baseId);
                otp.setReuseAsIs();
                otp.setWeight(nWeight);
            } else {
                otp.clearDeltaBase();
                otp.clearReuseAsIs();
            }
        } else if (nFmt == 1 && this.config.isReuseObjects()) {
            otp.clearDeltaBase();
            otp.setReuseAsIs();
            otp.setWeight(nWeight);
        } else {
            otp.clearDeltaBase();
            otp.clearReuseAsIs();
        }
        otp.select(next);
    }

    public static class Statistics {
        long totalObjects;
        long totalDeltas;
        long reusedObjects;
        long reusedDeltas;

        public String getMessage() {
            return MessageFormat.format(JGitText.get().packWriterStatistics, this.totalObjects, this.totalDeltas, this.reusedObjects, this.reusedDeltas);
        }
    }
}

