/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshConfigSessionFactory;
import org.eclipse.jgit.util.FS;
import org.jetbrains.annotations.Nullable;

public class GitSshSessionFactory
extends SshConfigSessionFactory {
    private final String key;
    private final String passphrase;

    GitSshSessionFactory(@Nullable String key, @Nullable String passphrase) {
        this.key = key;
        this.passphrase = passphrase;
    }

    protected void configure(OpenSshConfig.Host hc, Session session) {
        session.setConfig("StrictHostKeyChecking", "no");
    }

    protected JSch getJSch(OpenSshConfig.Host hc, FS fs) throws JSchException {
        JSch jsch = super.getJSch(hc, fs);
        jsch.removeAllIdentity();
        if (StringUtils.isNotEmpty((String)this.key)) {
            jsch.addIdentity("identityName", this.key.getBytes(), null, this.passphrase.getBytes());
        }
        return jsch;
    }
}

