/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.LockFile;
import org.eclipse.jgit.storage.file.PackLock;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.FetchHeadRecord;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.transport.Transport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FetchProcess {
    private final Transport transport;
    private final Collection<RefSpec> toFetch;
    private final HashMap<ObjectId, Ref> askFor = new HashMap();
    private final HashSet<ObjectId> have = new HashSet();
    private final ArrayList<TrackingRefUpdate> localUpdates = new ArrayList();
    private final ArrayList<FetchHeadRecord> fetchHeadUpdates = new ArrayList();
    private final ArrayList<PackLock> packLocks = new ArrayList();
    private FetchConnection conn;
    private final int depth;

    FetchProcess(Transport t, Collection<RefSpec> f, int d) {
        this.transport = t;
        this.toFetch = f;
        this.depth = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(ProgressMonitor monitor, FetchResult result) throws NotSupportedException, TransportException {
        this.askFor.clear();
        this.localUpdates.clear();
        this.fetchHeadUpdates.clear();
        this.packLocks.clear();
        try {
            this.executeImp(monitor, result);
        }
        finally {
            try {
                for (PackLock lock : this.packLocks) {
                    lock.unlock();
                }
            }
            catch (IOException e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void executeImp(ProgressMonitor monitor, FetchResult result) throws NotSupportedException, TransportException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchObjects(ProgressMonitor monitor) throws TransportException {
        try {
            this.conn.setPackLockMessage("jgit fetch " + this.transport.uri);
            this.conn.fetch(monitor, this.askFor.values(), this.have, this.transport.local.getShallows(), this.depth);
        }
        finally {
            this.packLocks.addAll(this.conn.getPackLocks());
        }
        if (this.transport.isCheckFetchedObjects() && !this.conn.didFetchTestConnectivity() && !this.askForIsComplete()) {
            throw new TransportException(this.transport.getURI(), JGitText.get().peerDidNotSupplyACompleteObjectGraph);
        }
    }

    private void closeConnection(FetchResult result) {
        if (this.conn != null) {
            this.conn.close();
            result.addMessages(this.conn.getMessages());
            this.conn = null;
        }
    }

    private void reopenConnection() throws NotSupportedException, TransportException {
        if (this.conn != null) {
            return;
        }
        this.conn = this.transport.openFetch();
        HashMap<ObjectId, Ref> avail = new HashMap<ObjectId, Ref>();
        for (Ref r : this.conn.getRefs()) {
            avail.put(r.getObjectId(), r);
        }
        ArrayList<Ref> wants = new ArrayList<Ref>(this.askFor.values());
        this.askFor.clear();
        for (Ref want : wants) {
            Ref newRef = (Ref)avail.get(want.getObjectId());
            if (newRef != null) {
                this.askFor.put(newRef.getObjectId(), newRef);
                continue;
            }
            this.removeFetchHeadRecord(want.getObjectId());
            this.removeTrackingRefUpdate(want.getObjectId());
        }
    }

    private void removeTrackingRefUpdate(ObjectId want) {
        Iterator<TrackingRefUpdate> i = this.localUpdates.iterator();
        while (i.hasNext()) {
            TrackingRefUpdate u = i.next();
            if (!u.getNewObjectId().equals(want)) continue;
            i.remove();
        }
    }

    private void removeFetchHeadRecord(ObjectId want) {
        Iterator<FetchHeadRecord> i = this.fetchHeadUpdates.iterator();
        while (i.hasNext()) {
            FetchHeadRecord fh = i.next();
            if (!fh.newValue.equals(want)) continue;
            i.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFETCH_HEAD(FetchResult result) throws IOException {
        block8: {
            File meta = this.transport.local.getDirectory();
            if (meta == null) {
                return;
            }
            LockFile lock = new LockFile(new File(meta, "FETCH_HEAD"), this.transport.local.getFS());
            try {
                if (!lock.lock()) break block8;
                OutputStreamWriter w = new OutputStreamWriter(lock.getOutputStream());
                try {
                    for (FetchHeadRecord h : this.fetchHeadUpdates) {
                        h.write(w);
                        result.add(h);
                    }
                }
                finally {
                    ((Writer)w).close();
                }
                lock.commit();
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean askForIsComplete() throws TransportException {
        try {
            ObjectWalk ow = new ObjectWalk(this.transport.local);
            try {
                for (ObjectId want : this.askFor.keySet()) {
                    ow.markStart(ow.parseAny(want));
                }
                for (Ref ref : this.transport.local.getAllRefs().values()) {
                    ow.markUninteresting(ow.parseAny(ref.getObjectId()));
                }
                ow.checkConnectivity();
            }
            finally {
                ow.release();
            }
            return true;
        }
        catch (MissingObjectException e) {
            return false;
        }
        catch (IOException e) {
            throw new TransportException(JGitText.get().unableToCheckConnectivity, e);
        }
    }

    private void expandWildcard(RefSpec spec, Set<Ref> matched) throws TransportException {
        for (Ref src : this.conn.getRefs()) {
            if (!spec.matchSource(src) || !matched.add(src)) continue;
            this.want(src, spec.expandFromSource(src));
        }
    }

    private void expandSingle(RefSpec spec, Set<Ref> matched) throws TransportException {
        Ref src = this.conn.getRef(spec.getSource());
        if (src == null) {
            throw new TransportException(MessageFormat.format(JGitText.get().remoteDoesNotHaveSpec, spec.getSource()));
        }
        if (matched.add(src)) {
            this.want(src, spec);
        }
    }

    private Collection<Ref> expandAutoFollowTags() throws TransportException {
        ArrayList<Ref> additionalTags = new ArrayList<Ref>();
        Map<String, Ref> haveRefs = this.transport.local.getAllRefs();
        for (Ref r : this.conn.getRefs()) {
            if (!FetchProcess.isTag(r)) continue;
            if (r.getPeeledObjectId() == null) {
                additionalTags.add(r);
                continue;
            }
            Ref local = haveRefs.get(r.getName());
            if (local != null) {
                if (r.getObjectId().equals(local.getObjectId())) continue;
                this.wantTag(r);
                continue;
            }
            if (this.askFor.containsKey(r.getPeeledObjectId()) || this.transport.local.hasObject(r.getPeeledObjectId())) {
                this.wantTag(r);
                continue;
            }
            additionalTags.add(r);
        }
        return additionalTags;
    }

    private void expandFetchTags() throws TransportException {
        Map<String, Ref> haveRefs = this.transport.local.getAllRefs();
        for (Ref r : this.conn.getRefs()) {
            Ref local;
            if (!FetchProcess.isTag(r) || (local = haveRefs.get(r.getName())) != null && r.getObjectId().equals(local.getObjectId())) continue;
            this.wantTag(r);
        }
    }

    private void wantTag(Ref r) throws TransportException {
        this.want(r, new RefSpec().setSource(r.getName()).setDestination(r.getName()));
    }

    private void want(Ref src, RefSpec spec) throws TransportException {
        ObjectId newId = src.getObjectId();
        if (spec.getDestination() != null) {
            try {
                TrackingRefUpdate tru = this.createUpdate(spec, newId);
                if (newId.equals(tru.getOldObjectId())) {
                    return;
                }
                this.localUpdates.add(tru);
            }
            catch (IOException err) {
                throw new TransportException(MessageFormat.format(JGitText.get().cannotResolveLocalTrackingRefForUpdating, spec.getDestination()), err);
            }
        }
        this.askFor.put(newId, src);
        FetchHeadRecord fhr = new FetchHeadRecord();
        fhr.newValue = newId;
        fhr.notForMerge = spec.getDestination() != null;
        fhr.sourceName = src.getName();
        fhr.sourceURI = this.transport.getURI();
        this.fetchHeadUpdates.add(fhr);
    }

    private TrackingRefUpdate createUpdate(RefSpec spec, ObjectId newId) throws IOException {
        return new TrackingRefUpdate(this.transport.local, spec, newId, "fetch");
    }

    private void deleteStaleTrackingRefs(FetchResult result, RevWalk walk) throws TransportException {
        Repository db = this.transport.local;
        for (Ref ref : db.getAllRefs().values()) {
            String refname = ref.getName();
            for (RefSpec spec : this.toFetch) {
                RefSpec s;
                if (!spec.matchDestination(refname) || result.getAdvertisedRef((s = spec.expandFromDestination(refname)).getSource()) != null) continue;
                this.deleteTrackingRef(result, db, walk, s, ref);
            }
        }
    }

    private void deleteTrackingRef(FetchResult result, Repository db, RevWalk walk, RefSpec spec, Ref localRef) throws TransportException {
        String name = localRef.getName();
        try {
            TrackingRefUpdate u = new TrackingRefUpdate(db, name, spec.getSource(), true, ObjectId.zeroId(), "deleted");
            result.add(u);
            if (this.transport.isDryRun()) {
                return;
            }
            u.delete(walk);
            switch (u.getResult()) {
                case NEW: 
                case NO_CHANGE: 
                case FAST_FORWARD: 
                case FORCED: {
                    break;
                }
                default: {
                    throw new TransportException(this.transport.getURI(), MessageFormat.format(JGitText.get().cannotDeleteStaleTrackingRef2, name, u.getResult().name()));
                }
            }
        }
        catch (IOException e) {
            throw new TransportException(this.transport.getURI(), MessageFormat.format(JGitText.get().cannotDeleteStaleTrackingRef, name), e);
        }
    }

    private static boolean isTag(Ref r) {
        return FetchProcess.isTag(r.getName());
    }

    private static boolean isTag(String name) {
        return name.startsWith("refs/tags/");
    }
}

