/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.storage.file;

import java.io.File;
import java.io.IOException;
import org.shaded.eclipse.jgit.lib.Constants;
import org.shaded.eclipse.jgit.storage.file.LockFile;
import org.shaded.eclipse.jgit.util.FS;
import org.shaded.eclipse.jgit.util.FileUtils;

public class PackLock {
    private final File keepFile;
    private final FS fs;

    public PackLock(File packFile, FS fs) {
        File p = packFile.getParentFile();
        String n = packFile.getName();
        this.keepFile = new File(p, n.substring(0, n.length() - 5) + ".keep");
        this.fs = fs;
    }

    public boolean lock(String msg) throws IOException {
        LockFile lf;
        if (msg == null) {
            return false;
        }
        if (!msg.endsWith("\n")) {
            msg = msg + "\n";
        }
        if (!(lf = new LockFile(this.keepFile, this.fs)).lock()) {
            return false;
        }
        lf.write(Constants.encode(msg));
        return lf.commit();
    }

    public void unlock() throws IOException {
        FileUtils.delete(this.keepFile);
    }
}

