/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.transport.BasePackFetchConnection;
import org.eclipse.jgit.transport.BasePackPushConnection;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.PackTransport;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UploadPack;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.io.MessageWriter;
import org.eclipse.jgit.util.io.StreamCopyThread;

class TransportLocal
extends Transport
implements PackTransport {
    private static final String PWD = ".";
    private final File remoteGitDir;

    static boolean canHandle(URIish uri, FS fs) {
        if (uri.getHost() != null || uri.getPort() > 0 || uri.getUser() != null || uri.getPass() != null || uri.getPath() == null) {
            return false;
        }
        if ("file".equals(uri.getScheme()) || uri.getScheme() == null) {
            return fs.resolve(new File(PWD), uri.getPath()).isDirectory();
        }
        return false;
    }

    TransportLocal(Repository local, URIish uri) {
        super(local, uri);
        File d = local.getFS().resolve(new File(PWD), uri.getPath()).getAbsoluteFile();
        if (new File(d, ".git").isDirectory()) {
            d = new File(d, ".git");
        }
        this.remoteGitDir = d;
    }

    UploadPack createUploadPack(Repository dst) {
        return new UploadPack(dst);
    }

    ReceivePack createReceivePack(Repository dst) {
        return new ReceivePack(dst);
    }

    public FetchConnection openFetch() throws TransportException {
        String up = this.getOptionUploadPack();
        if ("git-upload-pack".equals(up) || "git upload-pack".equals(up)) {
            return new InternalLocalFetchConnection();
        }
        return new ForkLocalFetchConnection();
    }

    public PushConnection openPush() throws NotSupportedException, TransportException {
        String rp = this.getOptionReceivePack();
        if ("git-receive-pack".equals(rp) || "git receive-pack".equals(rp)) {
            return new InternalLocalPushConnection();
        }
        return new ForkLocalPushConnection();
    }

    public void close() {
    }

    protected Process spawn(String cmd) throws TransportException {
        try {
            String[] args;
            if (cmd.startsWith("git-")) {
                args = new String[]{"git", cmd.substring(4), PWD};
            } else {
                int gitspace = cmd.indexOf("git ");
                if (gitspace >= 0) {
                    String git = cmd.substring(0, gitspace + 3);
                    String subcmd = cmd.substring(gitspace + 4);
                    args = new String[]{git, subcmd, PWD};
                } else {
                    args = new String[]{cmd, PWD};
                }
            }
            return Runtime.getRuntime().exec(args, null, this.remoteGitDir);
        }
        catch (IOException err) {
            throw new TransportException(this.uri, err.getMessage(), err);
        }
    }

    class ForkLocalPushConnection
    extends BasePackPushConnection {
        private Process receivePack;
        private Thread errorReaderThread;

        ForkLocalPushConnection() throws TransportException {
            super(TransportLocal.this);
            MessageWriter msg = new MessageWriter();
            this.setMessageWriter(msg);
            this.receivePack = TransportLocal.this.spawn(TransportLocal.this.getOptionReceivePack());
            InputStream rpErr = this.receivePack.getErrorStream();
            this.errorReaderThread = new StreamCopyThread(rpErr, msg.getRawStream());
            this.errorReaderThread.start();
            InputStream rpIn = this.receivePack.getInputStream();
            OutputStream rpOut = this.receivePack.getOutputStream();
            rpIn = new BufferedInputStream(rpIn);
            rpOut = new BufferedOutputStream(rpOut);
            this.init(rpIn, rpOut);
            this.readAdvertisedRefs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            super.close();
            if (this.receivePack != null) {
                try {
                    try {
                        this.receivePack.waitFor();
                    }
                    catch (InterruptedException ie) {
                        Object var3_2 = null;
                        this.receivePack = null;
                    }
                    Object var3_1 = null;
                    this.receivePack = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.receivePack = null;
                    throw throwable;
                }
            }
            if (this.errorReaderThread != null) {
                try {
                    try {
                        this.errorReaderThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        Object var5_8 = null;
                        this.errorReaderThread = null;
                    }
                    Object var5_7 = null;
                    this.errorReaderThread = null;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    this.errorReaderThread = null;
                    throw throwable;
                }
            }
        }
    }

    class InternalLocalPushConnection
    extends BasePackPushConnection {
        private Thread worker;

        InternalLocalPushConnection() throws TransportException {
            PipedOutputStream out_w;
            PipedInputStream out_r;
            PipedOutputStream in_w;
            PipedInputStream in_r;
            FileRepository dst;
            super(TransportLocal.this);
            try {
                dst = new FileRepository(TransportLocal.this.remoteGitDir);
            }
            catch (IOException err) {
                throw new TransportException(this.uri, JGitText.get().notAGitDirectory);
            }
            try {
                in_r = new PipedInputStream();
                in_w = new PipedOutputStream(in_r);
                out_r = new PipedInputStream();
                out_w = new PipedOutputStream(out_r);
            }
            catch (IOException err) {
                dst.close();
                throw new TransportException(this.uri, JGitText.get().cannotConnectPipes, err);
            }
            this.worker = new Thread("JGit-Receive-Pack"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block17: {
                        ReceivePack rp = TransportLocal.this.createReceivePack(dst);
                        rp.receive(out_r, in_w, System.err);
                        Object var3_4 = null;
                        try {
                            out_r.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        try {
                            in_w.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        dst.close();
                        {
                            break block17;
                            catch (IOException err) {
                                Object var3_5 = null;
                                try {
                                    out_r.close();
                                }
                                catch (IOException e2) {
                                    // empty catch block
                                }
                                try {
                                    in_w.close();
                                }
                                catch (IOException e2) {
                                    // empty catch block
                                }
                                dst.close();
                                break block17;
                            }
                            catch (RuntimeException runtimeException) {
                                Object var3_6 = null;
                                try {
                                    out_r.close();
                                }
                                catch (IOException e2) {
                                    // empty catch block
                                }
                                try {
                                    in_w.close();
                                }
                                catch (IOException e2) {
                                    // empty catch block
                                }
                                dst.close();
                            }
                        }
                        catch (Throwable throwable) {
                            Object var3_7 = null;
                            try {
                                out_r.close();
                            }
                            catch (IOException e2) {
                                // empty catch block
                            }
                            try {
                                in_w.close();
                            }
                            catch (IOException e2) {
                                // empty catch block
                            }
                            dst.close();
                            throw throwable;
                        }
                    }
                }
            };
            this.worker.start();
            this.init(in_r, out_w);
            this.readAdvertisedRefs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            super.close();
            if (this.worker != null) {
                try {
                    try {
                        this.worker.join();
                    }
                    catch (InterruptedException interruptedException) {
                        Object var3_2 = null;
                        this.worker = null;
                    }
                    Object var3_1 = null;
                    this.worker = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.worker = null;
                    throw throwable;
                }
            }
        }
    }

    class ForkLocalFetchConnection
    extends BasePackFetchConnection {
        private Process uploadPack;
        private Thread errorReaderThread;

        ForkLocalFetchConnection() throws TransportException {
            super(TransportLocal.this);
            MessageWriter msg = new MessageWriter();
            this.setMessageWriter(msg);
            this.uploadPack = TransportLocal.this.spawn(TransportLocal.this.getOptionUploadPack());
            InputStream upErr = this.uploadPack.getErrorStream();
            this.errorReaderThread = new StreamCopyThread(upErr, msg.getRawStream());
            this.errorReaderThread.start();
            InputStream upIn = this.uploadPack.getInputStream();
            OutputStream upOut = this.uploadPack.getOutputStream();
            upIn = new BufferedInputStream(upIn);
            upOut = new BufferedOutputStream(upOut);
            this.init(upIn, upOut);
            this.readAdvertisedRefs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            super.close();
            if (this.uploadPack != null) {
                try {
                    try {
                        this.uploadPack.waitFor();
                    }
                    catch (InterruptedException ie) {
                        Object var3_2 = null;
                        this.uploadPack = null;
                    }
                    Object var3_1 = null;
                    this.uploadPack = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.uploadPack = null;
                    throw throwable;
                }
            }
            if (this.errorReaderThread != null) {
                try {
                    try {
                        this.errorReaderThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        Object var5_8 = null;
                        this.errorReaderThread = null;
                    }
                    Object var5_7 = null;
                    this.errorReaderThread = null;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    this.errorReaderThread = null;
                    throw throwable;
                }
            }
        }
    }

    class InternalLocalFetchConnection
    extends BasePackFetchConnection {
        private Thread worker;

        InternalLocalFetchConnection() throws TransportException {
            PipedOutputStream out_w;
            PipedInputStream out_r;
            PipedOutputStream in_w;
            PipedInputStream in_r;
            FileRepository dst;
            super(TransportLocal.this);
            try {
                dst = new FileRepository(TransportLocal.this.remoteGitDir);
            }
            catch (IOException err) {
                throw new TransportException(this.uri, JGitText.get().notAGitDirectory);
            }
            try {
                in_r = new PipedInputStream();
                in_w = new PipedOutputStream(in_r);
                out_r = new PipedInputStream(){
                    {
                        this.buffer = new byte[2952];
                    }
                };
                out_w = new PipedOutputStream(out_r);
            }
            catch (IOException err) {
                dst.close();
                throw new TransportException(this.uri, JGitText.get().cannotConnectPipes, err);
            }
            this.worker = new Thread("JGit-Upload-Pack"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block17: {
                        UploadPack rp = TransportLocal.this.createUploadPack(dst);
                        rp.upload(out_r, in_w, null);
                        Object var3_4 = null;
                        try {
                            out_r.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        try {
                            in_w.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        dst.close();
                        {
                            break block17;
                            catch (IOException err) {
                                err.printStackTrace();
                                Object var3_5 = null;
                                try {
                                    out_r.close();
                                }
                                catch (IOException e2) {
                                    // empty catch block
                                }
                                try {
                                    in_w.close();
                                }
                                catch (IOException e2) {
                                    // empty catch block
                                }
                                dst.close();
                                break block17;
                            }
                            catch (RuntimeException err) {
                                err.printStackTrace();
                                Object var3_6 = null;
                                try {
                                    out_r.close();
                                }
                                catch (IOException e2) {
                                    // empty catch block
                                }
                                try {
                                    in_w.close();
                                }
                                catch (IOException e2) {
                                    // empty catch block
                                }
                                dst.close();
                            }
                        }
                        catch (Throwable throwable) {
                            Object var3_7 = null;
                            try {
                                out_r.close();
                            }
                            catch (IOException e2) {
                                // empty catch block
                            }
                            try {
                                in_w.close();
                            }
                            catch (IOException e2) {
                                // empty catch block
                            }
                            dst.close();
                            throw throwable;
                        }
                    }
                }
            };
            this.worker.start();
            this.init(in_r, out_w);
            this.readAdvertisedRefs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            super.close();
            if (this.worker != null) {
                try {
                    try {
                        this.worker.join();
                    }
                    catch (InterruptedException interruptedException) {
                        Object var3_2 = null;
                        this.worker = null;
                    }
                    Object var3_1 = null;
                    this.worker = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.worker = null;
                    throw throwable;
                }
            }
        }
    }
}

