/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.DateRevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

class PendingGenerator
extends Generator {
    private static final int PARSED = 1;
    private static final int SEEN = 2;
    private static final int UNINTERESTING = 4;
    static final int OVER_SCAN = 6;
    private static final RevCommit INIT_LAST = new RevCommit(ObjectId.zeroId());
    private final RevWalk walker;
    private final DateRevQueue pending;
    private final RevFilter filter;
    private final int output;
    private RevCommit last = INIT_LAST;
    private int overScan = 6;
    boolean canDispose;

    PendingGenerator(RevWalk w, DateRevQueue p, RevFilter f, int out) {
        this.walker = w;
        this.pending = p;
        this.filter = f;
        this.output = out;
        this.canDispose = true;
    }

    int outputType() {
        return this.output | 1;
    }

    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        try {
            while (true) {
                RevCommit c;
                if ((c = this.pending.next()) == null) {
                    this.walker.reader.walkAdviceEnd();
                    if (!(this.walker instanceof ObjectWalk)) {
                        this.walker.reader.release();
                    }
                    return null;
                }
                boolean produce = (c.flags & 4) != 0 ? false : this.filter.include(this.walker, c);
                if (this.walker.repository == null || !this.walker.repository.getShallows().contains(c.getId())) {
                    for (RevCommit p : c.parents) {
                        if ((p.flags & 2) != 0) continue;
                        if ((p.flags & 1) == 0) {
                            p.parseHeaders(this.walker);
                        }
                        p.flags |= 2;
                        this.pending.add(p);
                    }
                }
                this.walker.carryFlagsImpl(c);
                if ((c.flags & 4) != 0) {
                    if (this.pending.everbodyHasFlag(4)) {
                        RevCommit n = this.pending.peek();
                        if (n != null && n.commitTime >= this.last.commitTime) {
                            this.overScan = 6;
                        } else if (--this.overScan == 0) {
                            throw StopWalkException.INSTANCE;
                        }
                    } else {
                        this.overScan = 6;
                    }
                    if (!this.canDispose) continue;
                    c.disposeBody();
                    continue;
                }
                if (produce) {
                    this.last = c;
                    return this.last;
                }
                if (!this.canDispose) continue;
                c.disposeBody();
            }
        }
        catch (StopWalkException swe) {
            this.walker.reader.walkAdviceEnd();
            this.walker.reader.release();
            this.pending.clear();
            return null;
        }
    }

    static {
        PendingGenerator.INIT_LAST.commitTime = Integer.MAX_VALUE;
    }
}

