/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.AuthorImpl;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.commit.CommitImpl;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plugins.git.AbstractGitCacheDirectoryOperation;
import com.atlassian.bamboo.plugins.git.GitAuthenticationType;
import com.atlassian.bamboo.plugins.git.GitCacheDirectory;
import com.atlassian.bamboo.plugins.git.GitMavenPomAccessor;
import com.atlassian.bamboo.plugins.git.GitOperationHelper;
import com.atlassian.bamboo.repository.AbstractRepository;
import com.atlassian.bamboo.repository.MavenPomAccessor;
import com.atlassian.bamboo.repository.MavenPomAccessorCapableRepository;
import com.atlassian.bamboo.repository.NameValuePair;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.repository.SelectableAuthenticationRepository;
import com.atlassian.bamboo.security.StringEncrypter;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildChangesImpl;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.opensymphony.xwork.TextProvider;
import com.opensymphony.xwork.util.LocalizedTextUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitRepository
extends AbstractRepository
implements MavenPomAccessorCapableRepository,
SelectableAuthenticationRepository {
    private static final String REPOSITORY_GIT_NAME = "repository.git.name";
    private static final String REPOSITORY_GIT_REPOSITORY_URL = "repository.git.repositoryUrl";
    private static final String REPOSITORY_GIT_AUTHENTICATION_TYPE = "repository.git.authenticationType";
    private static final String REPOSITORY_GIT_USERNAME = "repository.git.username";
    private static final String REPOSITORY_GIT_PASSWORD = "repository.git.password";
    private static final String REPOSITORY_GIT_BRANCH = "repository.git.branch";
    private static final String REPOSITORY_GIT_SSH_KEY = "repository.git.ssh.key";
    private static final String REPOSITORY_GIT_SSH_PASSPHRASE = "repository.git.ssh.passphrase";
    private static final String REPOSITORY_GIT_MAVEN_PATH = "repository.git.maven.path";
    private static final String TEMPORARY_GIT_PASSWORD = "temporary.git.password";
    private static final String TEMPORARY_GIT_PASSWORD_CHANGE = "temporary.git.password.change";
    private static final String TEMPORARY_GIT_SSH_PASSPHRASE = "temporary.git.ssh.passphrase";
    private static final String TEMPORARY_GIT_SSH_PASSPHRASE_CHANGE = "temporary.git.ssh.passphrase.change";
    private static final String TEMPORARY_GIT_SSH_KEY_FROM_FILE = "temporary.git.ssh.keyfile";
    private static final String TEMPORARY_GIT_SSH_KEY_CHANGE = "temporary.git.ssh.key.change";
    private static final GitAuthenticationType defaultAuthenticationType = GitAuthenticationType.NONE;
    private static boolean USE_SHALLOW_CLONES = new SystemProperty(false, new String[]{"atlassian.bamboo.git.useShallowClones", "ATLASSIAN_BAMBO_GIT_USE_SHALLOW_CLONES"}).getValue(true);
    private static final Logger log = Logger.getLogger(GitRepository.class);
    final GitRepositoryAccessData accessData = new GitRepositoryAccessData();
    private transient String pathToPom;

    @NotNull
    public String getName() {
        return this.textProvider.getText(REPOSITORY_GIT_NAME);
    }

    public String getHost() {
        return null;
    }

    public boolean isRepositoryDifferent(@NotNull Repository repository) {
        if (repository instanceof GitRepository) {
            GitRepository gitRepo = (GitRepository)repository;
            return !new EqualsBuilder().append((Object)this.accessData.repositoryUrl, (Object)gitRepo.accessData.repositoryUrl).append((Object)this.accessData.branch, (Object)gitRepo.accessData.branch).append((Object)this.accessData.username, (Object)gitRepo.accessData.username).append((Object)this.accessData.sshKey, (Object)gitRepo.accessData.sshKey).isEquals();
        }
        return true;
    }

    @NotNull
    public BuildChanges collectChangesSinceLastBuild(@NotNull String planKey, final @Nullable String lastVcsRevisionKey) throws RepositoryException {
        try {
            List<Commit> extractedChanges;
            final BuildLogger buildLogger = this.buildLoggerManager.getBuildLogger(PlanKeys.getPlanKey((String)planKey));
            BuildChangesImpl changes = new BuildChangesImpl();
            final String targetRevision = new GitOperationHelper(buildLogger, this.textProvider).obtainLatestRevision(this.accessData);
            changes.setVcsRevisionKey(targetRevision);
            if (targetRevision.equals(lastVcsRevisionKey)) {
                return changes;
            }
            if (lastVcsRevisionKey == null) {
                log.info((Object)("Never checked logs for '" + planKey + "' setting latest revision to " + targetRevision));
                return changes;
            }
            try {
                extractedChanges = GitCacheDirectory.callOnCacheWithLock(this, new AbstractGitCacheDirectoryOperation<List<Commit>>(){

                    @Override
                    public List<Commit> call(@NotNull File cacheDirectory) throws Exception {
                        new GitOperationHelper(buildLogger, GitRepository.this.textProvider).fetch(cacheDirectory, GitRepository.this.accessData);
                        return new GitOperationHelper(buildLogger, GitRepository.this.textProvider).extractCommits(cacheDirectory, lastVcsRevisionKey, targetRevision);
                    }
                });
            }
            catch (Exception e) {
                try {
                    extractedChanges = GitCacheDirectory.callOnCacheWithLock(this, new AbstractGitCacheDirectoryOperation<List<Commit>>(){

                        @Override
                        public List<Commit> call(@NotNull File cacheDirectory) throws Exception {
                            buildLogger.addBuildLogEntry(GitRepository.this.textProvider.getText("repository.git.messages.ccRecover.failedToCollectChangesets", Arrays.asList(cacheDirectory)));
                            FileUtils.deleteQuietly((File)cacheDirectory);
                            buildLogger.addBuildLogEntry(GitRepository.this.textProvider.getText("repository.git.messages.ccRecover.cleanedCacheDirectory", Arrays.asList(cacheDirectory)));
                            new GitOperationHelper(buildLogger, GitRepository.this.textProvider).fetch(cacheDirectory, GitRepository.this.accessData);
                            buildLogger.addBuildLogEntry(GitRepository.this.textProvider.getText("repository.git.messages.ccRecover.fetchedRemoteRepository", Arrays.asList(cacheDirectory)));
                            List<Commit> extractedChanges = new GitOperationHelper(buildLogger, GitRepository.this.textProvider).extractCommits(cacheDirectory, lastVcsRevisionKey, targetRevision);
                            buildLogger.addBuildLogEntry(GitRepository.this.textProvider.getText("repository.git.messages.ccRecover.completed"));
                            return extractedChanges;
                        }
                    });
                }
                catch (Exception e2) {
                    log.error((Object)buildLogger.addBuildLogEntry(this.textProvider.getText("repository.git.messages.ccRecover.failedToExtractChangesets")), (Throwable)e2);
                    extractedChanges = null;
                }
            }
            if (extractedChanges == null || extractedChanges.isEmpty()) {
                changes.setChanges(Collections.singletonList(new CommitImpl((Author)new AuthorImpl("[unknown]"), this.textProvider.getText("repository.git.messages.unknownChanges", Arrays.asList(lastVcsRevisionKey, targetRevision)), new Date())));
            } else {
                changes.setChanges(extractedChanges);
            }
            return changes;
        }
        catch (RuntimeException e) {
            throw new RepositoryException(this.textProvider.getText("repository.git.messages.runtimeException"), (Throwable)e);
        }
    }

    @NotNull
    public String retrieveSourceCode(@NotNull BuildContext buildContext, @Nullable String targetRevision) throws RepositoryException {
        try {
            BuildLogger buildLogger = this.buildLoggerManager.getBuildLogger(buildContext.getPlanResultKey());
            String planKey = buildContext.getPlanKey();
            File sourceDirectory = this.getSourceCodeDirectory(planKey);
            try {
                return new GitOperationHelper(buildLogger, this.textProvider).fetchAndCheckout(sourceDirectory, this.accessData, targetRevision, USE_SHALLOW_CLONES);
            }
            catch (Exception e) {
                buildLogger.addBuildLogEntry(this.textProvider.getText("repository.git.messages.rsRecover.failedToRetrieveSource", Arrays.asList(sourceDirectory)));
                FileUtils.deleteQuietly((File)sourceDirectory);
                buildLogger.addBuildLogEntry(this.textProvider.getText("repository.git.messages.rsRecover.cleanedSourceDirectory", Arrays.asList(sourceDirectory)));
                String returnRevision = new GitOperationHelper(buildLogger, this.textProvider).fetchAndCheckout(sourceDirectory, this.accessData, targetRevision);
                buildLogger.addBuildLogEntry(this.textProvider.getText("repository.git.messages.rsRecover.completed"));
                return returnRevision;
            }
        }
        catch (RuntimeException e) {
            throw new RepositoryException(this.textProvider.getText("repository.git.messages.runtimeException"), (Throwable)e);
        }
    }

    @NotNull
    public String retrieveSourceCode(@NotNull String planKey, @Nullable String vcsRevisionKey) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void prepareConfigObject(@NotNull BuildConfiguration buildConfiguration) {
        LazyReference<StringEncrypter> encrypterRef = new LazyReference<StringEncrypter>(){

            protected StringEncrypter create() throws Exception {
                return new StringEncrypter();
            }
        };
        if (buildConfiguration.getBoolean(TEMPORARY_GIT_PASSWORD_CHANGE)) {
            buildConfiguration.setProperty(REPOSITORY_GIT_PASSWORD, (Object)((StringEncrypter)encrypterRef.get()).encrypt(buildConfiguration.getString(TEMPORARY_GIT_PASSWORD)));
        }
        if (buildConfiguration.getBoolean(TEMPORARY_GIT_SSH_PASSPHRASE_CHANGE)) {
            buildConfiguration.setProperty(REPOSITORY_GIT_SSH_PASSPHRASE, (Object)((StringEncrypter)encrypterRef.get()).encrypt(buildConfiguration.getString(TEMPORARY_GIT_SSH_PASSPHRASE)));
        }
        if (buildConfiguration.getBoolean(TEMPORARY_GIT_SSH_KEY_CHANGE)) {
            Object o = buildConfiguration.getProperty(TEMPORARY_GIT_SSH_KEY_FROM_FILE);
            if (o instanceof File) {
                String key;
                try {
                    key = FileUtils.readFileToString((File)((File)o));
                }
                catch (IOException e) {
                    log.error((Object)"Cannot read uploaded ssh key file", (Throwable)e);
                    return;
                }
                buildConfiguration.setProperty(REPOSITORY_GIT_SSH_KEY, (Object)((StringEncrypter)encrypterRef.get()).encrypt(key));
            } else {
                buildConfiguration.clearProperty(REPOSITORY_GIT_SSH_KEY);
            }
        }
    }

    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        super.populateFromConfig(config);
        this.accessData.repositoryUrl = StringUtils.trimToEmpty((String)config.getString(REPOSITORY_GIT_REPOSITORY_URL));
        this.accessData.username = config.getString(REPOSITORY_GIT_USERNAME);
        this.accessData.password = config.getString(REPOSITORY_GIT_PASSWORD);
        this.accessData.branch = config.getString(REPOSITORY_GIT_BRANCH);
        this.accessData.sshKey = config.getString(REPOSITORY_GIT_SSH_KEY);
        this.accessData.sshPassphrase = config.getString(REPOSITORY_GIT_SSH_PASSPHRASE);
        this.accessData.authenticationType = this.safeParseAuthenticationType(config.getString(REPOSITORY_GIT_AUTHENTICATION_TYPE));
        this.pathToPom = config.getString(REPOSITORY_GIT_MAVEN_PATH);
    }

    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        HierarchicalConfiguration configuration = super.toConfiguration();
        configuration.setProperty(REPOSITORY_GIT_REPOSITORY_URL, (Object)this.accessData.repositoryUrl);
        configuration.setProperty(REPOSITORY_GIT_USERNAME, (Object)this.accessData.username);
        configuration.setProperty(REPOSITORY_GIT_PASSWORD, (Object)this.accessData.password);
        configuration.setProperty(REPOSITORY_GIT_BRANCH, (Object)this.accessData.branch);
        configuration.setProperty(REPOSITORY_GIT_SSH_KEY, (Object)this.accessData.sshKey);
        configuration.setProperty(REPOSITORY_GIT_SSH_PASSPHRASE, (Object)this.accessData.sshPassphrase);
        configuration.setProperty(REPOSITORY_GIT_AUTHENTICATION_TYPE, this.accessData.authenticationType != null ? this.accessData.authenticationType.name() : null);
        return configuration;
    }

    @NotNull
    public ErrorCollection validate(@NotNull BuildConfiguration buildConfiguration) {
        ErrorCollection errorCollection = super.validate(buildConfiguration);
        String repoUrl = StringUtils.trim((String)buildConfiguration.getString(REPOSITORY_GIT_REPOSITORY_URL));
        String username = buildConfiguration.getString(REPOSITORY_GIT_USERNAME);
        GitAuthenticationType authenticationType = this.safeParseAuthenticationType(buildConfiguration.getString(REPOSITORY_GIT_AUTHENTICATION_TYPE));
        if (StringUtils.isBlank((String)repoUrl)) {
            errorCollection.addError(REPOSITORY_GIT_REPOSITORY_URL, this.textProvider.getText("repository.git.messages.missingRepositoryUrl"));
        } else {
            boolean isHttp;
            boolean bl = isHttp = repoUrl.startsWith("http://") || repoUrl.startsWith("https://");
            if (isHttp && authenticationType == GitAuthenticationType.SSH_KEYPAIR) {
                errorCollection.addError(REPOSITORY_GIT_AUTHENTICATION_TYPE, this.textProvider.getText("repository.git.messages.unsupportedHttpAuthenticationType"));
            }
            if (!isHttp && StringUtils.isNotEmpty((String)username) && authenticationType == GitAuthenticationType.PASSWORD) {
                errorCollection.addError(REPOSITORY_GIT_USERNAME, this.textProvider.getText("repository.git.messages.unsupportedUsernameField"));
            }
        }
        if (buildConfiguration.getString(REPOSITORY_GIT_MAVEN_PATH, "").contains("..")) {
            errorCollection.addError(REPOSITORY_GIT_MAVEN_PATH, this.textProvider.getText("repository.git.messages.invalidPomPath"));
        }
        return errorCollection;
    }

    @NotNull
    public MavenPomAccessor getMavenPomAccessor() {
        return new GitMavenPomAccessor(this, this.textProvider).withPath(this.pathToPom);
    }

    @NotNull
    public List<NameValuePair> getAuthenticationTypes() {
        return Lists.transform(Arrays.asList(GitAuthenticationType.values()), (Function)new Function<GitAuthenticationType, NameValuePair>(){

            public NameValuePair apply(GitAuthenticationType from) {
                String typeName = from.name();
                return new NameValuePair(typeName, GitRepository.this.getAuthTypeName(typeName));
            }
        });
    }

    public String getAuthType() {
        return this.accessData.authenticationType != null ? this.accessData.authenticationType.name() : defaultAuthenticationType.name();
    }

    GitAuthenticationType safeParseAuthenticationType(String typeName) {
        if (typeName == null) {
            return defaultAuthenticationType;
        }
        try {
            return GitAuthenticationType.valueOf(typeName);
        }
        catch (IllegalArgumentException e) {
            return defaultAuthenticationType;
        }
    }

    String getAuthTypeName(String authType) {
        return this.textProvider.getText("repository.git.authenticationType." + StringUtils.lowerCase((String)authType));
    }

    public String getRepositoryUrl() {
        return this.accessData.repositoryUrl;
    }

    public String getBranch() {
        return this.accessData.branch;
    }

    public String getAuthTypeName() {
        return this.getAuthTypeName(this.getAuthType());
    }

    public File getCacheDirectory() {
        return GitCacheDirectory.getCacheDirectory(this.getWorkingDirectory(), this.accessData);
    }

    public synchronized void setTextProvider(TextProvider textProvider) {
        super.setTextProvider(textProvider);
        if (textProvider.getText(REPOSITORY_GIT_NAME) == null) {
            LocalizedTextUtil.addDefaultResourceBundle((String)"com.atlassian.bamboo.plugins.git.i18n");
        }
    }

    static class GitRepositoryAccessData
    implements Serializable {
        String repositoryUrl;
        String branch;
        String username;
        String password;
        String sshKey;
        String sshPassphrase;
        GitAuthenticationType authenticationType;

        GitRepositoryAccessData() {
        }
    }
}

