/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.AuthorImpl;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.commit.CommitFile;
import com.atlassian.bamboo.commit.CommitFileImpl;
import com.atlassian.bamboo.commit.CommitImpl;
import com.atlassian.bamboo.plugins.git.BuildLoggerProgressMonitor;
import com.atlassian.bamboo.plugins.git.GitAuthenticationType;
import com.atlassian.bamboo.plugins.git.GitRepository;
import com.atlassian.bamboo.plugins.git.GitSshSessionFactory;
import com.atlassian.bamboo.plugins.git.TweakedUsernamePasswordCredentialsProvider;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.security.StringEncrypter;
import com.atlassian.bamboo.utils.SystemProperty;
import com.opensymphony.xwork.TextProvider;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.transport.Connection;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitOperationHelper {
    private static int DEFAULT_TRANSFER_TIMEOUT = new SystemProperty(false, new String[]{"atlassian.bamboo.git.timeout", "GIT_TIMEOUT"}).getValue(600);
    private static int CHANGESET_LIMIT = new SystemProperty(false, new String[]{"atlassian.bamboo.git.changeset.limit", "GIT_CHANGESET_LIMIT"}).getValue(100);
    private static final Logger log = Logger.getLogger(GitOperationHelper.class);
    private final BuildLogger buildLogger;
    private final TextProvider textProvider;

    public GitOperationHelper(@NotNull BuildLogger buildLogger, @NotNull TextProvider textProvider) {
        this.buildLogger = buildLogger;
        this.textProvider = textProvider;
    }

    @NotNull
    public String obtainLatestRevision(@NotNull GitRepository.GitRepositoryAccessData repositoryData) throws RepositoryException {
        Transport transport = null;
        Connection fetchConnection = null;
        try {
            transport = this.open(new FileRepository(""), repositoryData);
            fetchConnection = transport.openFetch();
            Ref headRef = fetchConnection.getRef("refs/heads/" + (StringUtils.isNotBlank((String)repositoryData.branch) ? repositoryData.branch : "master"));
            Ref ref = headRef != null ? headRef : (headRef = fetchConnection.getRef(StringUtils.isNotBlank((String)repositoryData.branch) ? repositoryData.branch : "HEAD"));
            if (headRef == null) {
                throw new RepositoryException(this.textProvider.getText("repository.git.messages.cannotDetermineHead", Arrays.asList(repositoryData.repositoryUrl, repositoryData.branch)));
            }
            String string = headRef.getObjectId().getName();
            return string;
        }
        catch (NotSupportedException e) {
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(this.textProvider.getText("repository.git.messages.protocolUnsupported", Arrays.asList(repositoryData.repositoryUrl))), (Throwable)e);
        }
        catch (TransportException e) {
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(this.textProvider.getText("repository.git.messages.failedToCreateFileRepository")), (Throwable)e);
        }
        finally {
            if (fetchConnection != null) {
                fetchConnection.close();
            }
            if (transport != null) {
                transport.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getCurrentRevision(@NotNull File sourceDirectory) {
        File gitDirectory = new File(sourceDirectory, ".git");
        if (!gitDirectory.exists()) {
            return null;
        }
        Repository localRepository = null;
        try {
            localRepository = new FileRepository(new File(sourceDirectory, ".git"));
            ObjectId objId = localRepository.resolve("HEAD");
            String string = objId != null ? objId.getName() : null;
            return string;
        }
        catch (IOException e) {
            log.warn((Object)this.buildLogger.addBuildLogEntry(this.textProvider.getText("repository.git.messages.cannotDetermineRevision", Arrays.asList(sourceDirectory)) + " " + e.getMessage()), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (localRepository != null) {
                localRepository.close();
            }
        }
    }

    @NotNull
    public String fetchAndCheckout(@NotNull File sourceDirectory, @NotNull GitRepository.GitRepositoryAccessData accessData, @Nullable String targetRevision) throws RepositoryException {
        return this.fetchAndCheckout(sourceDirectory, accessData, targetRevision, false);
    }

    @NotNull
    public String fetchAndCheckout(@NotNull File sourceDirectory, @NotNull GitRepository.GitRepositoryAccessData accessData, @Nullable String targetRevision, boolean useShallow) throws RepositoryException {
        String previousRevision = this.getCurrentRevision(sourceDirectory);
        String notNullTargetRevision = targetRevision != null ? targetRevision : this.obtainLatestRevision(accessData);
        this.fetch(sourceDirectory, accessData, useShallow);
        return this.checkout(sourceDirectory, notNullTargetRevision, previousRevision);
    }

    void fetch(@NotNull File sourceDirectory, @NotNull GitRepository.GitRepositoryAccessData accessData) throws RepositoryException {
        this.fetch(sourceDirectory, accessData, false);
    }

    void fetch(@NotNull File sourceDirectory, @NotNull GitRepository.GitRepositoryAccessData accessData, boolean useShallow) throws RepositoryException {
        String realBranch = StringUtils.isNotBlank((String)accessData.branch) ? accessData.branch : "master";
        Transport transport = null;
        Repository localRepository = null;
        try {
            File gitDirectory = new File(sourceDirectory, ".git");
            localRepository = new FileRepository(gitDirectory);
            if (!gitDirectory.exists()) {
                this.buildLogger.addBuildLogEntry(this.textProvider.getText("repository.git.messages.creatingGitRepository", Arrays.asList(gitDirectory)));
                localRepository.create();
            }
            transport = this.open((FileRepository)localRepository, accessData);
            this.buildLogger.addBuildLogEntry(this.textProvider.getText("repository.git.messages.fetchingBranch", Arrays.asList(realBranch)) + (useShallow ? " " + this.textProvider.getText("repository.git.messages.doingShallowFetch") : ""));
            RefSpec refSpec = new RefSpec().setForceUpdate(true).setSource("refs/heads/" + realBranch).setDestination("refs/heads/" + realBranch);
            transport.fetch(new BuildLoggerProgressMonitor(this.buildLogger), Arrays.asList(refSpec), useShallow ? 1 : 0);
        }
        catch (IOException e) {
            String message = this.textProvider.getText("repository.git.messages.fetchingFailed", Arrays.asList(accessData.repositoryUrl, realBranch, sourceDirectory));
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(message + " " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (localRepository != null) {
                localRepository.close();
            }
            if (transport != null) {
                transport.close();
            }
        }
    }

    @NotNull
    String checkout(@NotNull File sourceDirectory, @NotNull String targetRevision, @Nullable String previousRevision) throws RepositoryException {
        this.buildLogger.addBuildLogEntry(this.textProvider.getText("repository.git.messages.checkingOutRevision", Arrays.asList(targetRevision)));
        File gitDirectory = new File(sourceDirectory, ".git");
        FileRepository localRepository = null;
        RevWalk revWalk = null;
        try {
            localRepository = new FileRepository(gitDirectory);
            revWalk = new RevWalk(localRepository);
            RevCommit targetCommit = revWalk.parseCommit(localRepository.resolve(targetRevision));
            RevCommit previousCommit = previousRevision == null ? null : revWalk.parseCommit(localRepository.resolve(previousRevision));
            File lck = new File(localRepository.getIndexFile().getParentFile(), localRepository.getIndexFile().getName() + ".lock");
            FileUtils.deleteQuietly((File)lck);
            DirCacheCheckout dirCacheCheckout = new DirCacheCheckout((Repository)localRepository, previousCommit == null ? null : previousCommit.getTree(), localRepository.lockDirCache(), targetCommit.getTree());
            dirCacheCheckout.setFailOnConflict(true);
            dirCacheCheckout.checkout();
            RefUpdate refUpdate = localRepository.updateRef("HEAD");
            refUpdate.setNewObjectId(targetCommit);
            refUpdate.forceUpdate();
            String string = targetCommit.getId().getName();
            return string;
        }
        catch (IOException e) {
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(this.textProvider.getText("repository.git.messages.checkoutFailed", Arrays.asList(targetRevision))) + e.getMessage(), (Throwable)e);
        }
        finally {
            if (revWalk != null) {
                revWalk.release();
            }
            if (localRepository != null) {
                localRepository.close();
            }
        }
    }

    List<Commit> extractCommits(@NotNull File directory, @Nullable String previousRevision, @Nullable String targetRevision) throws RepositoryException {
        ArrayList<Commit> commits = new ArrayList<Commit>();
        Repository localRepository = null;
        RevWalk revWalk = null;
        TreeWalk treeWalk = null;
        try {
            File gitDirectory = new File(directory, ".git");
            localRepository = new FileRepository(gitDirectory);
            revWalk = new RevWalk(localRepository);
            if (targetRevision != null) {
                revWalk.markStart(revWalk.parseCommit(localRepository.resolve(targetRevision)));
            }
            if (previousRevision != null) {
                revWalk.markUninteresting(revWalk.parseCommit(localRepository.resolve(previousRevision)));
            }
            treeWalk = new TreeWalk(localRepository);
            treeWalk.setRecursive(true);
            int skippedCommits = 0;
            for (RevCommit commit : revWalk) {
                if (commits.size() >= CHANGESET_LIMIT) {
                    ++skippedCommits;
                    continue;
                }
                CommitImpl curr = new CommitImpl();
                curr.setComment(commit.getFullMessage());
                curr.setAuthor((Author)new AuthorImpl(commit.getAuthorIdent().getName()));
                curr.setDate(commit.getAuthorIdent().getWhen());
                commits.add((Commit)curr);
                if (commit.getParentCount() >= 2) continue;
                treeWalk.reset();
                int treePosition = commit.getParentCount() > 0 ? treeWalk.addTree(commit.getParent(0).getTree()) : treeWalk.addTree(new EmptyTreeIterator());
                treeWalk.addTree(commit.getTree());
                for (DiffEntry entry : DiffEntry.scan(treeWalk)) {
                    if (entry.getOldId().equals(entry.getNewId())) continue;
                    CommitFileImpl commitFile = new CommitFileImpl(entry.getChangeType() == DiffEntry.ChangeType.DELETE ? entry.getOldPath() : entry.getNewPath());
                    commitFile.setRevision(commit.getId().getName());
                    curr.addFile((CommitFile)commitFile);
                }
            }
        }
        catch (IOException e) {
            String message = this.textProvider.getText("repository.git.messages.extractingChangesetsException", Arrays.asList(directory, previousRevision, targetRevision));
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(message + " " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (treeWalk != null) {
                treeWalk.release();
            }
            if (revWalk != null) {
                revWalk.release();
            }
            if (localRepository != null) {
                localRepository.close();
            }
        }
        return commits;
    }

    Transport open(@NotNull FileRepository localRepository, @NotNull GitRepository.GitRepositoryAccessData accessData) throws RepositoryException {
        try {
            StringEncrypter encrypter = new StringEncrypter();
            Transport transport = Transport.open((Repository)localRepository, new URIish(accessData.repositoryUrl));
            transport.setTimeout(DEFAULT_TRANSFER_TIMEOUT);
            if (transport instanceof SshTransport) {
                boolean useKey = accessData.authenticationType == GitAuthenticationType.SSH_KEYPAIR;
                String sshKey = useKey ? encrypter.decrypt(accessData.sshKey) : null;
                String passphrase = useKey ? encrypter.decrypt(accessData.sshPassphrase) : null;
                GitSshSessionFactory factory = new GitSshSessionFactory(sshKey, passphrase);
                ((SshTransport)transport).setSshSessionFactory(factory);
            }
            if (accessData.authenticationType == GitAuthenticationType.PASSWORD) {
                transport.setCredentialsProvider(new TweakedUsernamePasswordCredentialsProvider(accessData.username, encrypter.decrypt(accessData.password)));
            }
            return transport;
        }
        catch (URISyntaxException e) {
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(this.textProvider.getText("repository.git.messages.invalidURI", Arrays.asList(accessData.repositoryUrl))), (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(this.textProvider.getText("repository.git.messages.failedToOpenTransport", Arrays.asList(accessData.repositoryUrl))), (Throwable)e);
        }
    }
}

