/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.RefDirectory;
import org.eclipse.jgit.storage.file.RefDirectoryUpdate;
import org.eclipse.jgit.util.FileUtils;

class RefDirectoryRename
extends RefRename {
    private final RefDirectory refdb;
    private ObjectId objId;
    private boolean updateHEAD;
    private RefDirectoryUpdate tmp;

    RefDirectoryRename(RefDirectoryUpdate src, RefDirectoryUpdate dst) {
        super(src, dst);
        this.refdb = src.getRefDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected RefUpdate.Result doRename() throws IOException {
        block39: {
            block31: {
                block38: {
                    block30: {
                        block37: {
                            block29: {
                                block36: {
                                    block28: {
                                        block35: {
                                            block27: {
                                                block34: {
                                                    block26: {
                                                        block33: {
                                                            block25: {
                                                                if (this.source.getRef().isSymbolic()) {
                                                                    return RefUpdate.Result.IO_FAILURE;
                                                                }
                                                                this.objId = this.source.getOldObjectId();
                                                                this.updateHEAD = this.needToUpdateHEAD();
                                                                this.tmp = this.refdb.newTemporaryUpdate();
                                                                rw = new RevWalk(this.refdb.getRepository());
                                                                try {
                                                                    this.tmp.setNewObjectId(this.objId);
                                                                    this.tmp.setForceUpdate(true);
                                                                    this.tmp.disableRefLog();
                                                                    switch (1.$SwitchMap$org$eclipse$jgit$lib$RefUpdate$Result[this.tmp.update(rw).ordinal()]) {
                                                                        case 1: 
                                                                        case 2: 
                                                                        case 3: {
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            var2_2 = this.tmp.getResult();
                                                                            var5_5 = null;
                                                                            break block25;
                                                                        }
                                                                    }
                                                                    if (!this.renameLog(this.source, this.tmp)) {
                                                                        var2_3 = RefUpdate.Result.IO_FAILURE;
                                                                        break block26;
                                                                    }
                                                                    dst = this.destination;
                                                                    if (this.updateHEAD) {
                                                                        if (!this.linkHEAD(this.destination)) {
                                                                            this.renameLog(this.tmp, this.source);
                                                                            var3_21 = RefUpdate.Result.LOCK_FAILURE;
                                                                            break block27;
                                                                        }
                                                                        dst = this.refdb.newUpdate("HEAD", false);
                                                                        dst.setRefLogIdent(this.destination.getRefLogIdent());
                                                                        dst.setRefLogMessage(this.destination.getRefLogMessage(), false);
                                                                    }
                                                                    this.source.setExpectedOldObjectId(this.objId);
                                                                    this.source.setForceUpdate(true);
                                                                    this.source.disableRefLog();
                                                                    if (this.source.delete(rw) != RefUpdate.Result.FORCED) {
                                                                        this.renameLog(this.tmp, this.source);
                                                                        if (this.updateHEAD) {
                                                                            this.linkHEAD(this.source);
                                                                        }
                                                                        var3_22 = this.source.getResult();
                                                                        break block28;
                                                                    }
                                                                    if (!this.renameLog(this.tmp, this.destination)) {
                                                                        this.renameLog(this.tmp, this.source);
                                                                        this.source.setExpectedOldObjectId(ObjectId.zeroId());
                                                                        this.source.setNewObjectId(this.objId);
                                                                        this.source.update(rw);
                                                                        if (this.updateHEAD) {
                                                                            this.linkHEAD(this.source);
                                                                        }
                                                                        var3_23 = RefUpdate.Result.IO_FAILURE;
                                                                        break block29;
                                                                    }
                                                                    dst.setExpectedOldObjectId(ObjectId.zeroId());
                                                                    dst.setNewObjectId(this.objId);
                                                                    if (dst.update(rw) != RefUpdate.Result.NEW) {
                                                                        if (this.renameLog(this.destination, this.tmp)) {
                                                                            this.renameLog(this.tmp, this.source);
                                                                        }
                                                                        this.source.setExpectedOldObjectId(ObjectId.zeroId());
                                                                        this.source.setNewObjectId(this.objId);
                                                                        this.source.update(rw);
                                                                        if (this.updateHEAD) {
                                                                            this.linkHEAD(this.source);
                                                                        }
                                                                        var3_24 = dst.getResult();
                                                                        break block30;
                                                                    }
                                                                    var3_25 = RefUpdate.Result.RENAMED;
                                                                    break block31;
                                                                }
                                                                catch (Throwable var4_26) {
                                                                    var5_12 = null;
                                                                    try {
                                                                        this.refdb.delete(this.tmp);
                                                                    }
                                                                    catch (IOException err) {
                                                                        FileUtils.delete(this.refdb.fileFor(this.tmp.getName()));
                                                                    }
                                                                    rw.release();
                                                                    throw var4_26;
                                                                }
                                                            }
                                                            ** try [egrp 1[TRYBLOCK] [8 : 545->559)] { 
lbl91:
                                                            // 1 sources

                                                            this.refdb.delete(this.tmp);
                                                            break block33;
lbl93:
                                                            // 1 sources

                                                            catch (IOException err) {
                                                                FileUtils.delete(this.refdb.fileFor(this.tmp.getName()));
                                                            }
                                                        }
                                                        rw.release();
                                                        return var2_2;
                                                    }
                                                    var5_6 = null;
                                                    ** try [egrp 1[TRYBLOCK] [8 : 545->559)] { 
lbl101:
                                                    // 1 sources

                                                    this.refdb.delete(this.tmp);
                                                    break block34;
lbl103:
                                                    // 1 sources

                                                    catch (IOException err) {
                                                        FileUtils.delete(this.refdb.fileFor(this.tmp.getName()));
                                                    }
                                                }
                                                rw.release();
                                                return var2_3;
                                            }
                                            var5_7 = null;
                                            ** try [egrp 1[TRYBLOCK] [8 : 545->559)] { 
lbl111:
                                            // 1 sources

                                            this.refdb.delete(this.tmp);
                                            break block35;
lbl113:
                                            // 1 sources

                                            catch (IOException err) {
                                                FileUtils.delete(this.refdb.fileFor(this.tmp.getName()));
                                            }
                                        }
                                        rw.release();
                                        return var3_21;
                                    }
                                    var5_8 = null;
                                    ** try [egrp 1[TRYBLOCK] [8 : 545->559)] { 
lbl121:
                                    // 1 sources

                                    this.refdb.delete(this.tmp);
                                    break block36;
lbl123:
                                    // 1 sources

                                    catch (IOException err) {
                                        FileUtils.delete(this.refdb.fileFor(this.tmp.getName()));
                                    }
                                }
                                rw.release();
                                return var3_22;
                            }
                            var5_9 = null;
                            ** try [egrp 1[TRYBLOCK] [8 : 545->559)] { 
lbl131:
                            // 1 sources

                            this.refdb.delete(this.tmp);
                            break block37;
lbl133:
                            // 1 sources

                            catch (IOException err) {
                                FileUtils.delete(this.refdb.fileFor(this.tmp.getName()));
                            }
                        }
                        rw.release();
                        return var3_23;
                    }
                    var5_10 = null;
                    ** try [egrp 1[TRYBLOCK] [8 : 545->559)] { 
lbl141:
                    // 1 sources

                    this.refdb.delete(this.tmp);
                    break block38;
lbl143:
                    // 1 sources

                    catch (IOException err) {
                        FileUtils.delete(this.refdb.fileFor(this.tmp.getName()));
                    }
                }
                rw.release();
                return var3_24;
            }
            var5_11 = null;
            ** try [egrp 1[TRYBLOCK] [8 : 545->559)] { 
lbl151:
            // 1 sources

            this.refdb.delete(this.tmp);
            break block39;
lbl153:
            // 1 sources

            catch (IOException err) {
                FileUtils.delete(this.refdb.fileFor(this.tmp.getName()));
            }
        }
        rw.release();
        return var3_25;
    }

    private boolean renameLog(RefUpdate src, RefUpdate dst) {
        File srcLog = this.refdb.logFor(src.getName());
        File dstLog = this.refdb.logFor(dst.getName());
        if (!srcLog.exists()) {
            return true;
        }
        if (!RefDirectoryRename.rename(srcLog, dstLog)) {
            return false;
        }
        try {
            int levels = RefDirectory.levelsIn(src.getName()) - 2;
            RefDirectory.delete(srcLog, levels);
            return true;
        }
        catch (IOException e) {
            RefDirectoryRename.rename(dstLog, srcLog);
            return false;
        }
    }

    private static boolean rename(File src, File dst) {
        if (src.renameTo(dst)) {
            return true;
        }
        File dir = dst.getParentFile();
        if (!(!dir.exists() && dir.mkdirs() || dir.isDirectory())) {
            return false;
        }
        return src.renameTo(dst);
    }

    private boolean linkHEAD(RefUpdate target) {
        try {
            RefDirectoryUpdate u = this.refdb.newUpdate("HEAD", false);
            u.disableRefLog();
            switch (u.link(target.getName())) {
                case NEW: 
                case FORCED: 
                case NO_CHANGE: {
                    return true;
                }
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }
}

