/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plugins.git.GitRepository;
import com.atlassian.bamboo.v2.build.repository.RepositoryV2;
import com.atlassian.bamboo.ww2.actions.PlanActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import java.io.File;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class DeleteGitCacheDirectory
extends PlanActionSupport
implements PlanEditSecurityAware {
    private static final Logger log = Logger.getLogger(DeleteGitCacheDirectory.class);

    public String doExecute() throws Exception {
        String buildKey = this.getBuildKey();
        Plan plan = this.planManager.getPlanByKey(buildKey);
        if (plan == null) {
            String message = this.getText("repository.git.messages.cache.cleanFailedNoPlan", Arrays.asList(buildKey));
            log.error((Object)message);
            this.addActionError(message);
            return "error";
        }
        RepositoryV2 repository = plan.getBuildDefinition().getRepositoryV2();
        if (!(repository instanceof GitRepository)) {
            String message = this.getText("repository.git.messages.cache.notGit", Arrays.asList(buildKey));
            log.error((Object)message);
            this.addActionError(message);
            return "error";
        }
        GitRepository gitRepository = (GitRepository)repository;
        try {
            File cacheDirectoryFile = gitRepository.getCacheDirectory();
            if (cacheDirectoryFile == null) {
                String message = this.getText("repository.git.messages.cache.cleanFailed", Arrays.asList(buildKey));
                this.addActionError(message);
                return "error";
            }
            if (cacheDirectoryFile.exists()) {
                String message = this.getText("repository.git.messages.cache.cleaning", Arrays.asList(buildKey, cacheDirectoryFile.getAbsolutePath()));
                log.info((Object)message);
                FileUtils.forceDelete((File)cacheDirectoryFile);
            } else {
                String message = this.getText("repository.git.messages.cache.notExist", Arrays.asList(buildKey, cacheDirectoryFile.getAbsolutePath()));
                log.info((Object)message);
            }
            return "success";
        }
        catch (Exception e) {
            String message = this.getText("repository.git.messages.cache.cleanFailed", Arrays.asList(buildKey));
            log.error((Object)message, (Throwable)e);
            this.addActionError(message);
            return "error";
        }
    }
}

