[#-- @ftlvariable name="action" type="com.atlassian.bamboo.build.coverage.ViewCloverCoverageSummary" --]
[#-- @ftlvariable name="" type="com.atlassian.bamboo.build.coverage.ViewCloverCoverageSummary" --]
<html>
<head>
    <title> [@ui.header pageKey='Coverage Summary' object='${build.name}' title=true /]</title>

</head>

<body>
    <style>
        .barNegative {
            background:#cc0000 none repeat scroll 0 0;
            border:1px solid #9C9C9C;
            font-size:2px;
            height:12px;
            text-align:left;
            width:100%;
        }
        .barPositive {
            background:#00cc00 none repeat scroll 0 0;
            font-size:2px;
            height:12px;
        }
    </style>

    [@ui.header pageKey='Coverage Summary' object='${build.name}' showPlanSuspended=true /]
    [@cp.buildSubMenu selectedTab='clover' /]

<div class="section">

[@ui.bambooPanel title="Code Coverage Summary" content=true]
    [#if reportLinker??]
        [#assign latestBuild =  reportLinker.buildResultsSummary /]

        [#if (latestBuild.customBuildData.CLOVER_BUILD_COVERAGE)?has_content]
            [#assign coverageNumber = numberUtils.stringToDouble(latestBuild.customBuildData.CLOVER_BUILD_COVERAGE)!0 /]
            <div id="successRatePercentage" class="successRatePercentagePadded" style="float: right;">
                <h2>
                    ${coverageNumber?round}%
                </h2>
                <p>
                    Latest coverage
                </p>
            </div>
        [/#if]

        <p>
            <img src="${req.contextPath}/download/resources/com.atlassian.bamboo.plugin.clover/logo.gif"/>
            [#if reportLinker.html??]
                <a href="${req.contextPath}${reportLinker.html}">[#rt]
                     <strong>View latest Clover HTML report</strong>[#t]
                </a>[#lt]

            [#else]
                <a href="${req.contextPath}/build/viewCloverResult.action?buildKey=${latestBuild.buildKey}&buildNumber=${latestBuild.buildNumber}">[#rt]
                     <strong>View latest Clover information</strong>[#t]
                </a>[#lt]
            [/#if]
            from <a href="${req.contextPath}/browse/${latestBuild.buildResultKey}">${latestBuild.buildResultKey}</a>
            (${latestBuild.buildCompletedDate?datetime?string("hh:mm a, EEE, d MMM yyyy")})
        </p>

        [#if (coverageNumber)?has_content]
            <div style="width: 80%; padding: 10px 0;">
                <div title="${100 - coverageNumber}% Not Covered" style="min-width: 200px;" class="barNegative">
                   <div title="${coverageNumber}% Covered" class="barPositive " style="width: ${coverageNumber}%"></div>
                </div>
            </div>
        [/#if]
    [#else]
        <p>No Clover coverage data found.</p>
    [/#if]

[/@ui.bambooPanel]


    <div id="graphs" class="topPadded">
        <div id="graph1">
            [@ww.action name="viewCloverCoverageSummary" namespace="/build" executeResult="true" /]
        </div>
        <div id="graph2">
            [@ww.action name="viewCloverLinesOfCodeSummary" namespace="/build" executeResult="true" /]
        </div>
    </div>
</div>    
<div class="paddedClearer" ></div>
</body>
</html>