<html>
<head>
	<title> [@ui.header pageKey='Coverage' object='${build.name} ${buildResults.buildNumber}' title=true /]</title>
</head>

<body>
    [@cp.resultsSubMenu selectedTab='clover' /]
    <div class="section">

    <p class="headingInfo">
        <a href="${req.contextPath}/build/viewCloverSummary.action?buildKey=${build.key}">[#rt]
             View history[#t]
        </a>[#lt]
    </p>
    <h2>
        <img src="${req.contextPath}/download/resources/com.atlassian.bamboo.plugin.clover/logo.gif"/> Clover Code Coverage
    </h2>
        
[#if reportLinker??  && reportLinker.html??]

    [#include "cloverReportHtml.ftl" /]

[#else]


[#assign customDataMap=buildResults.buildResultsSummary.customBuildData/]

[#if customDataMap.CLOVER_BUILD_COVERAGE??]

    [@ui.bambooInfoDisplay titleKey='clover.testCoverage.title' float=true]

        [@ww.label id='buildCoverage' labelKey='clover.testCoverage.build' descriptionKey='clover.testCoverage.build.description']
            [@ww.param name='value' ]${customDataMap.CLOVER_BUILD_COVERAGE!}%
            [#if customDataMap.CLOVER_COVERAGE_DELTA?? ]
                (${numberUtils.stringToDouble(customDataMap.CLOVER_COVERAGE_DELTA)}%)
            [/#if]
            [/@ww.param]
        [/@ww.label]

        [#if customDataMap.CLOVER_STATEMENTS?? && customDataMap.CLOVER_COVERED_STATEMENTS??]
            [@ww.label labelKey='clover.testCoverage.statement' descriptionKey='clover.testCoverage.statement.description']
            [#if numberUtils.stringToDouble(customDataMap.CLOVER_STATEMENTS) == 0]
                [@ww.param name='value']-[/@ww.param]
            [#else]
                [@ww.param name='value']
                    ${(numberUtils.stringToDouble(customDataMap.CLOVER_COVERED_STATEMENTS)
                    / numberUtils.stringToDouble(customDataMap.CLOVER_STATEMENTS))?string('0.0%')}
                [/@ww.param]
            [/#if]
            [/@ww.label]
        [/#if]

        [#if customDataMap.CLOVER_METHODS?? && customDataMap.CLOVER_COVERED_METHODS??]
            [@ww.label labelKey='clover.testCoverage.methods' descriptionKey='clover.testCoverage.methods.description']
            [#if numberUtils.stringToDouble(customDataMap.CLOVER_METHODS) == 0]
                [@ww.param name='value']-[/@ww.param]
            [#else]
                [@ww.param name='value']
                    ${(numberUtils.stringToDouble(customDataMap.CLOVER_COVERED_METHODS)
                    / numberUtils.stringToDouble(customDataMap.CLOVER_METHODS))?string('0.0%')}
                [/@ww.param]
            [/#if]
            [/@ww.label]
        [/#if]

        [#if customDataMap.CLOVER_CONDITIONALS?? && customDataMap.CLOVER_COVERED_CONDITIONALS??]
            [@ww.label labelKey='clover.testCoverage.conditionals' descriptionKey='clover.testCoverage.conditionals.description']
                [#if numberUtils.stringToDouble(customDataMap.CLOVER_CONDITIONALS) == 0]
                    [@ww.param name='value']-[/@ww.param]
                [#else]
                    [@ww.param name='value']
                        ${(numberUtils.stringToDouble(customDataMap.CLOVER_COVERED_CONDITIONALS)
                        / numberUtils.stringToDouble(customDataMap.CLOVER_CONDITIONALS))?string('0.0%')}
                    [/@ww.param]
                [/#if]
            [/@ww.label]
        [/#if]




    [/@ui.bambooInfoDisplay]


    [@ui.bambooInfoDisplay titleKey='clover.buildStatistics.title' float=true]

    [@ww.label labelKey='clover.buildStatistics.loc' descriptionKey='clover.buildStatistics.loc.description'
        value='${customDataMap.CLOVER_LOC!}' /]
    [@ww.label labelKey='clover.buildStatistics.ncloc' descriptionKey='clover.buildStatistics.ncloc.description'
        value='${customDataMap.CLOVER_NCLOC!}' /]
    [@ww.label labelKey='clover.buildStatistics.files'
        value='${customDataMap.CLOVER_FILES!}' /]
    [@ww.label labelKey='clover.buildStatistics.methods'
        value='${customDataMap.CLOVER_METHODS!}' /]
    [@ww.label labelKey='clover.buildStatistics.classes'
        value='${customDataMap.CLOVER_CLASSES!}' /]
    [@ww.label labelKey='clover.buildStatistics.packages'
        value='${customDataMap.CLOVER_PACKAGES!}' /]


    [/@ui.bambooInfoDisplay]
[#else]
    <p>[@ww.text name='clover.noCoverageData'/]</p>
[/#if]

[/#if]


        </div>
<div class="paddedClearer" ></div>
</body>
</html>