package com.atlassian.bamboo.builder.coverage;

import com.atlassian.bamboo.resultsummary.ExtendedBuildResultsSummary;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CurrentBuildResultImpl;
import junit.framework.TestCase;
import org.easymock.EasyMock;

import java.util.HashMap;
import java.util.Map;

public class CloverDeltaCalculatorTest extends TestCase
{
    private CloverDeltaCalculator cloverDeltaCalculator;
    private BuildContext mockBuildContext;
    private ExtendedBuildResultsSummary mockExtendedBuildResultsSummary;
    private Map<String,String> previousCustomDataMap;
    private Map<String,String> customBuildData;
    private CurrentBuildResultImpl currentBuildResult;

    @Override
    protected void setUp() throws Exception
    {
        mockBuildContext = EasyMock.createMock(BuildContext.class);
        EasyMock.expect(mockBuildContext.getPlanKey())
                .andReturn("BAM-MAIN")
                .anyTimes();

        currentBuildResult = new CurrentBuildResultImpl();
        customBuildData = currentBuildResult.getCustomBuildData();

        mockExtendedBuildResultsSummary = EasyMock.createMock(ExtendedBuildResultsSummary.class);
        previousCustomDataMap = new HashMap<String, String>();
        EasyMock.expect(mockExtendedBuildResultsSummary.getCustomBuildData())
                .andReturn(previousCustomDataMap);

        cloverDeltaCalculator = new CloverDeltaCalculator()
        {
            @Override
            protected ExtendedBuildResultsSummary getPreviousBuildResultsSummary()
            {
                return mockExtendedBuildResultsSummary;
            }
        };
        cloverDeltaCalculator.init(mockBuildContext);
    }

    public void testCalculatesDeltaForCloverCorrectly() throws Exception
    {
        // setup
        EasyMock.expect(mockBuildContext.getBuildResult())
                .andReturn(currentBuildResult);

        previousCustomDataMap.put(CloverBuildProcessor.CLOVER_BUILD_COVERAGE, "0.75");
        customBuildData.put(CloverBuildProcessor.CLOVER_BUILD_COVERAGE, "0.80");

        // expectations
        replay();

        // execute
        cloverDeltaCalculator.call();
        
        // verify
        assertEquals("Delta matches", "0.05" , customBuildData.get(CloverBuildProcessor.CLOVER_COVERAGE_DELTA));

        verify();
    }

    public void testHandlesNullPreviousAndCurrentCoverage() throws Exception
    {
        // setup

        // expectations
        replay();

        // execute
        cloverDeltaCalculator.call();

        // verify
        assertNull(customBuildData.get(CloverBuildProcessor.CLOVER_COVERAGE_DELTA));
        verify();

    }

    public void testHandlesNullPreviousCoverage() throws Exception
    {
        // setup
        customBuildData.put(CloverBuildProcessor.CLOVER_BUILD_COVERAGE, "0.80");

        // expectations
        replay();

        // execute
        cloverDeltaCalculator.call();

        // verify
        assertNull(customBuildData.get(CloverBuildProcessor.CLOVER_COVERAGE_DELTA));
        verify();

    }

    public void testHandlesNullCurrentCoverage() throws Exception
    {
        // setup
        previousCustomDataMap.put(CloverBuildProcessor.CLOVER_BUILD_COVERAGE, "0.75");
        EasyMock.expect(mockBuildContext.getBuildResult())
                .andReturn(currentBuildResult);
        // expectations
        replay();

        // execute
        cloverDeltaCalculator.call();

        // verify
        assertNull(customBuildData.get(CloverBuildProcessor.CLOVER_COVERAGE_DELTA));
        verify();

    }


    private void verify()
    {
        EasyMock.verify(mockBuildContext);
        EasyMock.verify(mockExtendedBuildResultsSummary);

    }

    private void replay()
    {
        EasyMock.replay(mockBuildContext);
        EasyMock.replay(mockExtendedBuildResultsSummary);
    }

}
