/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.aws.credentials.api.service;

import com.amazonaws.auth.AWSCredentials;
import com.atlassian.bamboo.plugins.aws.core.AwsException;
import com.atlassian.bamboo.plugins.aws.core.s3.S3Service;
import com.atlassian.bamboo.plugins.aws.credentials.AwsCredentials;
import com.atlassian.bamboo.plugins.aws.credentials.AwsCredentialsService;
import com.atlassian.bamboo.plugins.aws.credentials.api.LinkHelper;
import com.atlassian.bamboo.plugins.aws.credentials.api.RestConstants;
import com.atlassian.bamboo.plugins.aws.credentials.api.model.RestS3Bucket;
import com.atlassian.bamboo.plugins.aws.credentials.api.service.RestS3Service;
import com.atlassian.bamboo.rest.model.ListResponse;
import com.atlassian.bamboo.rest.model.RestResource;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RestS3ServiceImpl
implements RestS3Service {
    private static final Function<String, RestS3Bucket> BUCKET_NAMES_TO_REST_BUCKETS = new Function<String, RestS3Bucket>(){

        public RestS3Bucket apply(String bucketName) {
            return new RestS3Bucket(bucketName);
        }
    };
    private final AwsCredentialsService awsCredentialsService;
    private final LinkHelper linkHelper;
    private final S3Service s3Service;

    public RestS3ServiceImpl(AwsCredentialsService awsCredentialsService, LinkHelper linkHelper, S3Service s3Service) {
        this.awsCredentialsService = awsCredentialsService;
        this.linkHelper = linkHelper;
        this.s3Service = s3Service;
    }

    @Override
    @NotNull
    public ListResponse<RestS3Bucket> getBuckets(long credentialsId) throws AwsException {
        AwsCredentials credentials = this.awsCredentialsService.getCredentials(credentialsId);
        List buckets = this.s3Service.getBuckets((AWSCredentials)credentials);
        return this.toRestS3Buckets(credentialsId, buckets);
    }

    @NotNull
    private ListResponse<RestS3Bucket> toRestS3Buckets(long credentialsId, @NotNull List<String> buckets) {
        ListResponse restS3Buckets = new ListResponse(Lists.transform(buckets, BUCKET_NAMES_TO_REST_BUCKETS));
        this.linkHelper.addLinks((RestResource)restS3Buckets, String.format(RestConstants.S3_BUCKETS_LIST_URL, credentialsId));
        return restS3Buckets;
    }
}

