/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.aws.credentials.api.service;

import com.amazonaws.auth.AWSCredentials;
import com.atlassian.bamboo.exception.NotFoundException;
import com.atlassian.bamboo.plugins.aws.core.AwsException;
import com.atlassian.bamboo.plugins.aws.core.AwsRegion;
import com.atlassian.bamboo.plugins.aws.core.AwsService;
import com.atlassian.bamboo.plugins.aws.core.codedeploy.CodeDeployService;
import com.atlassian.bamboo.plugins.aws.credentials.AwsCredentials;
import com.atlassian.bamboo.plugins.aws.credentials.AwsCredentialsService;
import com.atlassian.bamboo.plugins.aws.credentials.api.LinkHelper;
import com.atlassian.bamboo.plugins.aws.credentials.api.RestConstants;
import com.atlassian.bamboo.plugins.aws.credentials.api.model.RestCodeDeployApplication;
import com.atlassian.bamboo.plugins.aws.credentials.api.model.RestCodeDeployDeploymentGroup;
import com.atlassian.bamboo.plugins.aws.credentials.api.service.RestCodeDeployService;
import com.atlassian.bamboo.rest.model.ListResponse;
import com.atlassian.bamboo.rest.model.RestResource;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RestCodeDeployServiceImpl
implements RestCodeDeployService {
    private static final Function<String, RestCodeDeployApplication> APPLICATION_NAMES_TO_REST_APPLICATIONS = new Function<String, RestCodeDeployApplication>(){

        public RestCodeDeployApplication apply(String applicationName) {
            return new RestCodeDeployApplication(applicationName);
        }
    };
    private static final Function<String, RestCodeDeployDeploymentGroup> DEPLOYMENT_GROUP_NAMES_TO_REST_DEPLOYMENT_GROUPS = new Function<String, RestCodeDeployDeploymentGroup>(){

        public RestCodeDeployDeploymentGroup apply(String deploymentGroupName) {
            return new RestCodeDeployDeploymentGroup(deploymentGroupName);
        }
    };
    private final AwsCredentialsService awsCredentialsService;
    private final LinkHelper linkHelper;
    private final CodeDeployService codeDeployService;
    private final I18nResolver i18nResolver;

    public RestCodeDeployServiceImpl(AwsCredentialsService awsCredentialsService, LinkHelper linkHelper, CodeDeployService codeDeployService, I18nResolver i18nResolver) {
        this.awsCredentialsService = awsCredentialsService;
        this.linkHelper = linkHelper;
        this.codeDeployService = codeDeployService;
        this.i18nResolver = i18nResolver;
    }

    @Override
    @NotNull
    public ListResponse<RestCodeDeployApplication> getApplications(long credentialsId, @NotNull String regionName) throws AwsException {
        AwsCredentials credentials = this.awsCredentialsService.getCredentials(credentialsId);
        AwsRegion region = this.getAwsRegion(regionName);
        List applications = this.codeDeployService.getApplications((AWSCredentials)credentials, region);
        return this.toApplicationsResponse(credentialsId, applications);
    }

    @Override
    @NotNull
    public ListResponse<RestCodeDeployDeploymentGroup> getDeploymentGroups(long credentialsId, @NotNull String regionName, @NotNull String applicationName) throws AwsException {
        AwsCredentials credentials = this.awsCredentialsService.getCredentials(credentialsId);
        AwsRegion region = this.getAwsRegion(regionName);
        List deploymentGroups = this.codeDeployService.getDeploymentGroups((AWSCredentials)credentials, region, applicationName);
        return this.toDeploymentGroupsResponse(credentialsId, applicationName, deploymentGroups);
    }

    @NotNull
    private AwsRegion getAwsRegion(@NotNull String regionName) {
        AwsRegion region;
        try {
            region = AwsRegion.valueOf((String)regionName);
        }
        catch (IllegalArgumentException e) {
            throw new NotFoundException(this.i18nResolver.getText("aws.region.error.notFound", new Serializable[]{regionName}));
        }
        if (!region.isServiceSupported(AwsService.CODE_DEPLOY)) {
            throw new NotFoundException(this.i18nResolver.getText("aws.service.error.notFound", new Serializable[]{"codedeploy", regionName}));
        }
        return region;
    }

    @NotNull
    private ListResponse<RestCodeDeployApplication> toApplicationsResponse(long credentialsId, @NotNull List<String> applications) {
        ListResponse restApplications = new ListResponse(Lists.transform(applications, APPLICATION_NAMES_TO_REST_APPLICATIONS));
        this.linkHelper.addLinks((RestResource)restApplications, String.format(RestConstants.CODEDEPLOY_APPLICATIONS_LIST_URL, credentialsId));
        return restApplications;
    }

    @NotNull
    private ListResponse<RestCodeDeployDeploymentGroup> toDeploymentGroupsResponse(long credentialsId, @NotNull String applicationName, @NotNull List<String> deploymentGroups) {
        ListResponse restDeploymentGroups = new ListResponse(Lists.transform(deploymentGroups, DEPLOYMENT_GROUP_NAMES_TO_REST_DEPLOYMENT_GROUPS));
        this.linkHelper.addLinks((RestResource)restDeploymentGroups, String.format(RestConstants.CODEDEPLOY_DEPLOYMENT_GROUPS_LIST_URL, credentialsId, applicationName));
        return restDeploymentGroups;
    }
}

