/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.aws.credentials.api;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.plugins.aws.credentials.api.model.RestAwsCredentials;
import com.atlassian.bamboo.plugins.aws.credentials.api.service.RestAwsCredentialsService;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

@Path(value="credentials")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ExperimentalApi
public class AwsCredentialsResource {
    public static final RestAwsCredentials AWS_ADD_CREDENTIALS_EXAMPLE = new RestAwsCredentials();
    public static final RestAwsCredentials AWS_CREDENTIALS_EXAMPLE = new RestAwsCredentials();
    private final RestAwsCredentialsService restAwsCredentialsService;

    public AwsCredentialsResource(RestAwsCredentialsService restAwsCredentialsService) {
        this.restAwsCredentialsService = restAwsCredentialsService;
    }

    @POST
    public Response addAwsCredentials(RestAwsCredentials restAwsCredentials) throws WebValidationException {
        RestAwsCredentials credentials = this.restAwsCredentialsService.addCredentials(restAwsCredentials);
        URI self = UriBuilder.fromUri((String)credentials.getLinks().getBase()).path(credentials.getLinks().getSelf()).build(new Object[0]);
        return Response.created((URI)self).entity((Object)credentials).build();
    }

    @PUT
    @Path(value="{credentialsId}")
    public Response updateAwsCredentials(@PathParam(value="credentialsId") long credentialsId, RestAwsCredentials restAwsCredentials) throws WebValidationException {
        RestAwsCredentials credentials = this.restAwsCredentialsService.updateCredentials(credentialsId, restAwsCredentials);
        return Response.ok((Object)((Object)credentials)).build();
    }

    @GET
    @Path(value="{credentialsId}")
    public Response getAwsCredentials(@PathParam(value="credentialsId") long credentialsId) throws WebValidationException {
        RestAwsCredentials credentials = this.restAwsCredentialsService.getCredentials(credentialsId);
        return Response.ok((Object)((Object)credentials)).build();
    }

    @DELETE
    @Path(value="{credentialsId}")
    public Response deleteAwsCredentials(@PathParam(value="credentialsId") long credentialsId) throws WebValidationException {
        this.restAwsCredentialsService.deleteCredentials(credentialsId);
        return Response.noContent().build();
    }

    static {
        AWS_ADD_CREDENTIALS_EXAMPLE.setName("AWS Credentials (US East 1)");
        AWS_ADD_CREDENTIALS_EXAMPLE.setAccessKey("AI5F5D3WVCEQKY3ERNP");
        AWS_ADD_CREDENTIALS_EXAMPLE.setSecretKey("anJrSkW4e7GsdhrUHsFYc6diloSodOSKwz1nTrgL");
        AWS_CREDENTIALS_EXAMPLE.setId(1L);
        AWS_CREDENTIALS_EXAMPLE.setName("AWS Credentials (US East 1)");
        AWS_CREDENTIALS_EXAMPLE.setAccessKey("AI5F5D3WVCEQKY3ERNP");
    }
}

