/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.aws.credentials;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.atlassian.bamboo.credentials.CredentialTypeModuleDescriptor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.credentials.CredentialsManager;
import com.atlassian.bamboo.exception.NotFoundException;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.plugins.aws.core.AwsException;
import com.atlassian.bamboo.plugins.aws.core.iam.IdentityManagementService;
import com.atlassian.bamboo.plugins.aws.credentials.AwsCredentials;
import com.atlassian.bamboo.plugins.aws.credentials.AwsCredentialsService;
import com.atlassian.bamboo.plugins.aws.credentials.Constants;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Map;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.acls.Permission;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AwsCredentialsServiceImpl
implements AwsCredentialsService {
    private static final Logger log = Logger.getLogger(AwsCredentialsServiceImpl.class);
    private final BambooPermissionManager bambooPermissionManager;
    private final CredentialsManager credentialsManager;
    private final I18nResolver i18nResolver;
    private final IdentityManagementService iamService;

    public AwsCredentialsServiceImpl(BambooPermissionManager bambooPermissionManager, CredentialsManager credentialsManager, I18nResolver i18nResolver, IdentityManagementService iamService) {
        this.bambooPermissionManager = bambooPermissionManager;
        this.credentialsManager = credentialsManager;
        this.i18nResolver = i18nResolver;
        this.iamService = iamService;
    }

    @Override
    @NotNull
    public AwsCredentials createCredentials(@Nullable String name, @Nullable String accessKey, @Nullable String secretKey) throws WebValidationException {
        if (!this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.RESTRICTEDADMINISTRATION)) {
            throw new AccessDeniedException("No global restricted administration permission");
        }
        ErrorCollection errorCollection = this.validateCredentials(name, accessKey, secretKey);
        if (errorCollection.hasAnyErrors()) {
            throw new WebValidationException(errorCollection);
        }
        CredentialTypeModuleDescriptor credentialDescriptor = this.credentialsManager.getCredentialTypeDescriptor(Constants.AWS_CREDENTIALS_TYPE_KEY);
        CredentialsData credentialsData = this.credentialsManager.createCredentials(credentialDescriptor, name, (Map)ImmutableMap.of((Object)Constants.CFG_ACCESS_KEY, (Object)accessKey, (Object)Constants.CFG_SECRET_KEY, (Object)secretKey));
        return AwsCredentials.fromCredentialsData((CredentialsData)credentialsData);
    }

    @Override
    @NotNull
    public AwsCredentials updateCredentials(long credentialsId, @Nullable String name, @Nullable String accessKey, @Nullable String secretKey) throws WebValidationException {
        if (!this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.RESTRICTEDADMINISTRATION)) {
            throw new AccessDeniedException("No global restricted administration permission");
        }
        CredentialsData existingCredentialsData = this.credentialsManager.getCredentials(credentialsId);
        if (existingCredentialsData == null) {
            throw new NotFoundException(this.i18nResolver.getText("aws.credentials.error.notFound", new Serializable[]{Long.valueOf(credentialsId)}));
        }
        ErrorCollection errorCollection = this.validateCredentials(name, accessKey, secretKey);
        if (errorCollection.hasAnyErrors()) {
            throw new WebValidationException(errorCollection);
        }
        CredentialsData credentialsData = this.credentialsManager.editCredentials(credentialsId, name, (Map)ImmutableMap.of((Object)Constants.CFG_ACCESS_KEY, (Object)accessKey, (Object)Constants.CFG_SECRET_KEY, (Object)secretKey));
        return AwsCredentials.fromCredentialsData((CredentialsData)credentialsData);
    }

    @NotNull
    private ErrorCollection validateCredentials(@Nullable String name, @Nullable String accessKey, @Nullable String secretKey) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (StringUtils.isBlank((CharSequence)name)) {
            errorCollection.addError(Constants.CFG_NAME, this.i18nResolver.getText("credentials.name.empty"));
        } else if (name.length() > 255) {
            errorCollection.addError(Constants.CFG_NAME, this.i18nResolver.getText("credentials.name.tooLong"));
        }
        errorCollection.addErrorCollection(this.validateCredentials(accessKey, secretKey));
        return errorCollection;
    }

    @Override
    @NotNull
    public ErrorCollection validateCredentials(@Nullable String accessKey, @Nullable String secretKey) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (StringUtils.isBlank((CharSequence)accessKey)) {
            errorCollection.addError(Constants.CFG_ACCESS_KEY, this.i18nResolver.getText("aws.credentials.accessKey.empty"));
        }
        if (StringUtils.isBlank((CharSequence)secretKey)) {
            errorCollection.addError(Constants.CFG_SECRET_KEY, this.i18nResolver.getText("aws.credentials.secretKey.empty"));
        }
        if (StringUtils.isNotBlank((CharSequence)accessKey) && StringUtils.isNotBlank((CharSequence)secretKey)) {
            try {
                String error = this.iamService.getAccountValidationError((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey));
                if (!StringUtils.isBlank((CharSequence)error)) {
                    errorCollection.addError(Constants.CFG_SECRET_KEY, this.i18nResolver.getText("aws.credentials.invalid", new Serializable[]{error}));
                }
            }
            catch (AwsException e) {
                log.warn((Object)this.i18nResolver.getText("aws.credentials.error"), (Throwable)e);
                errorCollection.addError(Constants.CFG_SECRET_KEY, this.i18nResolver.getText("aws.credentials.error"));
            }
        }
        return errorCollection;
    }

    @Override
    @NotNull
    public AwsCredentials getCredentials(long credentialsId) {
        CredentialsData credentialsData = this.credentialsManager.getCredentials(credentialsId);
        if (credentialsData == null) {
            throw new NotFoundException(this.i18nResolver.getText("aws.credentials.error.notFound", new Serializable[]{Long.valueOf(credentialsId)}));
        }
        return AwsCredentials.fromCredentialsData((CredentialsData)credentialsData);
    }

    @Override
    public void deleteCredentials(long credentialsId) {
        if (!this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.RESTRICTEDADMINISTRATION)) {
            throw new AccessDeniedException("No global restricted administration permission");
        }
        this.credentialsManager.deleteCredentials(credentialsId);
    }
}

