/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.aws.credentials;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.credentials.AbstractCredentialType;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.plugins.aws.credentials.AwsCredentials;
import com.atlassian.bamboo.plugins.aws.credentials.AwsCredentialsService;
import com.atlassian.bamboo.plugins.aws.credentials.Constants;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AwsCredentialType
extends AbstractCredentialType {
    private static final String CFG_CHANGE_SECRET_KEY = "changeSecretKey";
    private AwsCredentialsService awsCredentialsService;

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull CredentialsData previousCredentialsData) {
        super.populateContextForEdit(context, previousCredentialsData);
        AwsCredentials awsCredentials = AwsCredentials.fromCredentialsData((CredentialsData)previousCredentialsData);
        context.put(Constants.CFG_ACCESS_KEY, awsCredentials.getAccessKey());
    }

    public void validate(@NotNull ActionParametersMap params, @Nullable CredentialsData previousCredentialsData, @NotNull ErrorCollection errorCollection) {
        super.validate(params, previousCredentialsData, errorCollection);
        String secretKey = this.getSecretKey(params, previousCredentialsData);
        errorCollection.addErrorCollection(this.awsCredentialsService.validateCredentials(params.getString(Constants.CFG_ACCESS_KEY), secretKey));
    }

    @NotNull
    public Map<String, String> generateCredentialsConfigMap(@NotNull ActionParametersMap params, @Nullable CredentialsData previousCredentialsData) {
        HashMap configMap = Maps.newHashMap();
        configMap.put(Constants.CFG_ACCESS_KEY, params.getString(Constants.CFG_ACCESS_KEY));
        configMap.put(Constants.CFG_SECRET_KEY, this.getSecretKey(params, previousCredentialsData));
        return configMap;
    }

    @Nullable
    private String getSecretKey(@NotNull ActionParametersMap params, @Nullable CredentialsData previousCredentialsData) {
        if (params.getBoolean(CFG_CHANGE_SECRET_KEY) || previousCredentialsData == null) {
            return params.getString(Constants.CFG_SECRET_KEY);
        }
        return AwsCredentials.fromCredentialsData((CredentialsData)previousCredentialsData).getSecretKey();
    }

    public void setAwsCredentialsService(AwsCredentialsService awsCredentialsService) {
        this.awsCredentialsService = awsCredentialsService;
    }
}

