<div class="aws-plugin">
    [@ui.bambooSection titleKey="aws.codedeploy.title" cssClass="titled-group"]
        <div class="description">
            [@ww.text name="aws.codedeploy.title.description"]
                [@ww.param][@ww.text name="help.prefix"/][@ww.text name="aws.codedeploy.help"/][@ww.text name="aws.codedeploy.help.link"/][/@ww.param]
            [/@ww.text]
        </div>
        [#assign addSharedCredentialsLink][#if fn.hasRestrictedAdminPermission()]<a class="addSharedCredentials" href="/bamboo/admin/credentials/configureSharedCredentials.action">[@ww.text name="aws.codedeploy.credentials.add"/]</a>[/#if][/#assign]
        [@ww.select labelKey='aws.codedeploy.credentials' name='credentialsId' list=availableCredentials listKey='id' listValue='name' extraUtility=addSharedCredentialsLink /]
        [@ww.select labelKey='aws.codedeploy.region' name='region' list=availableRegions listKey='name()' listValue='displayName' /]
    [/@ui.bambooSection]
    [@ui.bambooSection titleKey="aws.codedeploy.deployment.title" cssClass="titled-group"]
        <div class="description">[@s.text name='aws.codedeploy.deployment.description' /]</div>
        [@s.textfield
            labelKey='aws.codedeploy.deployment.label'
            labelClass='aws-plugin__directory-label'
            name='workingSubDirectory'
            cssClass="long-field"
        /]
        [@s.checkbox
            labelKey='aws.codedeploy.deployment.hiddenfiles'
            name='includeHiddenFiles'
        /]
    [/@ui.bambooSection]
    [@ui.bambooSection titleKey="aws.codedeploy.upload.title" cssClass="titled-group"]
        <div class="description">[@s.text name='aws.codedeploy.upload.title.description' /]</div>
        [@s.textfield
            labelKey='aws.codedeploy.s3bucket'
            name='s3Bucket'
            cssClass='long-field aws-plugin__typeahead'
            required=true
            helpIconCssClass='aui-iconfont-info'
            helpDialogKey='aws.codedeploy.s3bucket.help'
        /]
    [/@ui.bambooSection]
    [@ui.bambooSection titleKey="aws.codedeploy.app.title" cssClass="titled-group"]
        <div class="description">[@s.text name='aws.codedeploy.app.description' /]</div>
        [@s.textfield
            labelKey='aws.codedeploy.applicationName'
            name='applicationName'
            cssClass='long-field aws-plugin__typeahead'
            required=true
            helpIconCssClass='aui-iconfont-info'
            helpDialogKey='aws.codedeploy.applicationName.help'
        /]
        [@s.textfield
            labelKey='aws.codedeploy.deploymentGroup'
            name='deploymentGroup'
            cssClass='long-field aws-plugin__typeahead'
            required=true
            helpIconCssClass='aui-iconfont-info'
            helpDialogKey='aws.codedeploy.deploymentGroup.help'
        /]
        [@s.textfield
            labelKey='aws.codedeploy.maxtimeout.title'
            name='deploymentTimeout'
            cssClass='long-field aws-plugin__typeahead'
            required=true
        /]
    [/@ui.bambooSection]
    <script type="text/javascript">
        require([
            'jquery',
            'codedeploy/aws-autocomplete'
        ], function(
            $,
            AWSAutocomplete
        ){

            return new AWSAutocomplete({
                $credentialsEl: $('#credentialsId'),
                $addCredentialsEl: $('.addSharedCredentials'),
                $regionEl: $('select[name="region"]'),
                $bucketsEl: $('input[name="s3Bucket"]'),
                $applicationsEl: $('input[name="applicationName"]'),
                $deploymentGroupsEl: $('input[name="deploymentGroup"]')
            });

        });
    </script>
</div>

