/*global module, test*/
define([
    'jquery',
    'credentials/dialog-form-add-credentials'
], function(
    $,
    DialogFormAddCredentials
) {

    'use strict';

    module('Bamboo.Plugin.AWS.DialogFormAddCredentials', {
        setup: function() {
            this.$fixture = $('<div><select></select></div>');

            // fake all XHR
            this.server = sinon.useFakeXMLHttpRequest();
            this.requests = [];

            this.server.onCreate = _.bind(function(xhr) {
                this.requests.push(xhr);
            }, this);

            this.widget = new DialogFormAddCredentials({
                $credentialsEl: this.$fixture.find('select')
            });
        },
        teardown: function() {
            this.server.restore();
        }
    });

    test('add valid credentials to select field', function() {
        var callback = sinon.spy();
        var saveButton = this.widget.dialog.getPage(0)
            .element.find('button:last');

        // submit dialog form
        saveButton.click();

        // mock response
        this.requests[0].respond(200,
            { 'Content-Type': 'application/json' },
            JSON.stringify({
                id: 'foo',
                name: 'bar'
            })
        );
        ok(this.$fixture.html().indexOf('<option value="foo">bar</option>') > 1, 'option added');
    });

});
