/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.maven.sandbox;

import com.atlassian.bamboo.specs.api.rsbs.RunnerSettings;
import com.atlassian.bamboo.specs.maven.sandbox.FileToBambooSpecsMapper;
import com.atlassian.bamboo.specs.maven.sandbox.LowPrivilegeThreadPermissionVerifier;
import com.atlassian.bamboo.specs.maven.sandbox.ReflectionEnabledThreadPermissionVerifier;
import com.atlassian.bamboo.specs.maven.sandbox.SecureMethodInvoker;
import com.atlassian.bamboo.specs.maven.sandbox.ThreadPermissionVerifier;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessControlException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpecsRunner {
    private final Log log;
    private final Collection<Path> classFiles;
    private final FileToBambooSpecsMapper fileToBambooSpecsMapper;
    private final ClassLoader classLoader;
    private final Set<File> priorityClasspath;

    public SpecsRunner(Log log, Collection<Path> classFiles, ClassLoader classloader, Set<File> priorityClasspath) {
        this.log = log;
        this.classFiles = classFiles;
        this.classLoader = classloader;
        this.priorityClasspath = priorityClasspath;
        this.fileToBambooSpecsMapper = new FileToBambooSpecsMapper(log, classloader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Class<?>, Object> runSpecs(boolean useSecurityManager) {
        if (useSecurityManager) {
            LowPrivilegeThreadPermissionVerifier permissionVerifier = new LowPrivilegeThreadPermissionVerifier(Paths.get("", new String[0]).toAbsolutePath(), RunnerSettings.getYamlDir());
            SecureMethodInvoker.startPerThreadSecurity(this.customPermissionVerifiers(), permissionVerifier);
            try {
                Map map = SecureMethodInvoker.invoke(this::runSpecsInternal);
                return map;
            }
            finally {
                SecureMethodInvoker.endPerThreadSecurity();
            }
        }
        return this.runSpecsInternal();
    }

    @NotNull
    private Map<Thread, ThreadPermissionVerifier> customPermissionVerifiers() {
        HashMap<Thread, ThreadPermissionVerifier> customVerfiers = new HashMap<Thread, ThreadPermissionVerifier>();
        try {
            Class<?> aClass = this.classLoader.loadClass("com.atlassian.bamboo.specs.util.PrivilegedThreadRegistry");
            Field instance = aClass.getField("INSTANCE");
            Supplier threadSupplier = (Supplier)instance.get(null);
            customVerfiers.put((Thread)threadSupplier.get(), new ReflectionEnabledThreadPermissionVerifier(this.classLoader, this.priorityClasspath));
            return customVerfiers;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private Map<Class<?>, Object> runSpecsInternal() {
        List bambooSpecClasses = this.classFiles.stream().map(this.fileToBambooSpecsMapper).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        for (Class bambooSpecClass : bambooSpecClasses) {
            this.log.info((CharSequence)("Running " + bambooSpecClass));
            this.callMainMethod(bambooSpecClass);
        }
        return Collections.emptyMap();
    }

    @Nullable
    private Object callMainMethod(Class<?> aClass) {
        Method mainMethod = SpecsRunner.getMainMethod(aClass);
        if (mainMethod == null) {
            this.log.warn((CharSequence)("No public static void main() method in " + aClass));
            return null;
        }
        Object[] args = new Object[]{new String[0]};
        try {
            return mainMethod.invoke(null, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            if (e.getCause() instanceof AccessControlException) {
                throw (AccessControlException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    private static Method getMainMethod(Class<?> aClass) {
        try {
            return aClass.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException ignored) {
            return null;
        }
    }
}

