/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.maven.sandbox;

import com.atlassian.bamboo.specs.maven.sandbox.AbstractThreadPermissionVerifier;
import com.atlassian.bamboo.specs.maven.sandbox.LowPrivilegeThreadPermissionVerifier;
import com.atlassian.bamboo.specs.maven.sandbox.StackTraceUtils;
import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.ReflectPermission;
import java.security.Permission;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class ReflectionEnabledThreadPermissionVerifier
extends AbstractThreadPermissionVerifier {
    private final ClassLoader classLoader;
    private final Set<File> priorityClasspath;

    ReflectionEnabledThreadPermissionVerifier(ClassLoader classLoader, Set<File> priorityClasspath) {
        this.classLoader = classLoader;
        this.priorityClasspath = priorityClasspath;
    }

    @Override
    public boolean checkPermissionFor(Permission perm) {
        LowPrivilegeThreadPermissionVerifier lowPrivilegeThreadPermissionVerifier = new LowPrivilegeThreadPermissionVerifier(null, null);
        if (lowPrivilegeThreadPermissionVerifier.checkPermissionFor(perm)) {
            return true;
        }
        if (ReflectionEnabledThreadPermissionVerifier.narrow(perm, ReflectPermission.class).map(Permission::getName).filter("suppressAccessChecks"::equals).isPresent()) {
            StackTraceElement[] callerStackTrace = Objects.requireNonNull(StackTraceUtils.getCallerStack(AccessibleObject.class));
            Set<File> jarsOnStack = StackTraceUtils.getClassLocationsOnStack(this.classLoader, callerStackTrace);
            return this.priorityClasspath.containsAll(jarsOnStack);
        }
        if (ReflectionEnabledThreadPermissionVerifier.narrow(perm, RuntimePermission.class).map(Permission::getName).filter("accessDeclaredMembers"::equals).isPresent()) {
            StackTraceElement[] callerStackTrace = Objects.requireNonNull(StackTraceUtils.getCallerStack(Class.class));
            Set<File> jarsOnStack = StackTraceUtils.getClassLocationsOnStack(this.classLoader, callerStackTrace);
            return this.priorityClasspath.containsAll(jarsOnStack);
        }
        return false;
    }

    private static <S, T extends S> Optional<T> narrow(S superclass, Class<T> runtimePermissionClass) {
        return runtimePermissionClass.isInstance(superclass) ? Optional.of(runtimePermissionClass.cast(superclass)) : Optional.empty();
    }
}

