/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.maven;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.maven.plugin.logging.Log;

public final class BambooSpecsFileScanner {
    private BambooSpecsFileScanner() {
    }

    public static Collection<Path> getClassFiles(final Log log, final Path root) throws IOException {
        final ArrayList<Path> classFiles = new ArrayList<Path>();
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.toString().endsWith(".class")) {
                    log.debug((CharSequence)("Adding " + file + " to scan candidates"));
                    classFiles.add(root.relativize(file));
                }
                return super.visitFile(file, attrs);
            }
        });
        return classFiles;
    }
}

